package com.bringspring.ai.mcp.config;

import org.springaicommunity.mcp.annotation.McpTool;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@Component
public class McpToolGroupScanner implements BeanPostProcessor {
    private final List<McpToolGroupMeta> scannedTools = new ArrayList<>();

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName)
            throws BeansException {

        // ⚠️ 关键：处理 AOP 代理
        Class<?> targetClass = AopUtils.getTargetClass(bean);

        // 1. 判断类上是否有 @JbosMcpTool
        McpToolGroup groupAnn =
                AnnotatedElementUtils.findMergedAnnotation(
                        targetClass,
                        McpToolGroup.class
                );

        if (groupAnn == null) {
            return bean;
        }

        String groupId = groupAnn.value();
        String groupName = groupAnn.name();

        // 2. 扫描方法上的 @McpTool
        for (Method method : targetClass.getMethods()) {

            McpTool mcpTool =
                    AnnotatedElementUtils.findMergedAnnotation(
                            method,
                            McpTool.class
                    );

            if (mcpTool == null) {
                continue;
            }

            // 3. 取 name
            String toolName = mcpTool.name();

            scannedTools.add(
                    McpToolGroupMeta.builder()
                            .groupId(groupId)
                            .groupName(groupName)
                            .toolName(toolName)
                            .build()
            );
        }

        return bean;
    }

    public List<McpToolGroupMeta> getScannedTools() {
        return scannedTools;
    }
}
