package com.bringspring.ai.mcp.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.ai.mcp.config.McpToolGroupMeta;
import com.bringspring.ai.mcp.config.McpToolGroupScanner;
import com.bringspring.ai.mcp.vo.McpMonitorGroupVO;
import com.bringspring.common.base.ActionResult;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/monitor/mcp/tools")
public class McpServerToolsMonitorController {

    @Autowired(required = false)
    private McpToolGroupScanner groupScanner;

    @Autowired(required = false)
    private ObjectProvider<List<McpServerFeatures.SyncToolSpecification>> tools;

    @GetMapping("/group")
    public ActionResult group(){
        List<McpMonitorGroupVO> mcpMonitorGroupVOS = new ArrayList<>();
        List<McpToolGroupMeta> scannedTools = groupScanner.getScannedTools();


        if(CollectionUtil.isNotEmpty(scannedTools)){
            Map<String, List<McpToolGroupMeta>> groupMap =
                    scannedTools.stream()
                            .collect(Collectors.groupingBy(item -> item.getGroupId() + "|" + item.getGroupName()));

            for(Map.Entry<String, List<McpToolGroupMeta>> entry : groupMap.entrySet()){
                String[] split = entry.getKey().split("\\|");
                McpMonitorGroupVO monitorGroupVO = McpMonitorGroupVO.builder()
                        .groupId(split[0])
                        .groupName(split[1])
                        .count(entry.getValue().size())
                        .build();
                mcpMonitorGroupVOS.add(monitorGroupVO);
            }

        }
        return ActionResult.success(mcpMonitorGroupVOS);
    }

    @GetMapping("/group/{groupId}")
    public ActionResult groupByGroupId(@PathVariable("groupId") String groupId){

        List<McpToolGroupMeta> scannedTools = groupScanner.getScannedTools();

        List<McpToolGroupMeta> targetList = scannedTools.stream().filter(item -> groupId.equals(item.getGroupId())).toList();

        Set<String> targetNames = targetList.stream()
                .map(McpToolGroupMeta::getToolName)
                .collect(Collectors.toSet());

        List<McpServerFeatures.SyncToolSpecification> toolSpecifications = new ArrayList(tools.stream().flatMap(Collection::stream).toList());
        List<McpSchema.Tool > matchedTools =
                toolSpecifications.stream()
                        .filter(spec -> targetNames.contains(spec.tool().name()))
                        .map(item -> item.tool())
                        .toList();


        return ActionResult.success(matchedTools);
    }
}
