/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ai.mcp.config;

import com.bringspring.ai.mcp.config.McpToolGroup;
import com.bringspring.ai.mcp.config.McpToolGroupMeta;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springaicommunity.mcp.annotation.McpTool;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;

@Component
public class McpToolGroupScanner
implements BeanPostProcessor {
    private final List<McpToolGroupMeta> scannedTools = new ArrayList<McpToolGroupMeta>();

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        McpToolGroup groupAnn = (McpToolGroup)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)targetClass, McpToolGroup.class);
        if (groupAnn == null) {
            return bean;
        }
        String groupId = groupAnn.value();
        String groupName = groupAnn.name();
        for (Method method : targetClass.getMethods()) {
            McpTool mcpTool = (McpTool)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, McpTool.class);
            if (mcpTool == null) continue;
            String toolName = mcpTool.name();
            this.scannedTools.add(McpToolGroupMeta.builder().groupId(groupId).groupName(groupName).toolName(toolName).build());
        }
        return bean;
    }

    public List<McpToolGroupMeta> getScannedTools() {
        return this.scannedTools;
    }
}

