/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ai.mcp.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.ai.mcp.config.McpToolGroupMeta;
import com.bringspring.ai.mcp.config.McpToolGroupScanner;
import com.bringspring.ai.mcp.vo.McpMonitorGroupVO;
import com.bringspring.common.base.ActionResult;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor/mcp/tools"})
public class McpServerToolsMonitorController {
    @Autowired(required=false)
    private McpToolGroupScanner groupScanner;
    @Autowired(required=false)
    private ObjectProvider<List<McpServerFeatures.SyncToolSpecification>> tools;

    @GetMapping(value={"/group"})
    public ActionResult group() {
        ArrayList<McpMonitorGroupVO> mcpMonitorGroupVOS = new ArrayList<McpMonitorGroupVO>();
        List<McpToolGroupMeta> scannedTools = this.groupScanner.getScannedTools();
        if (CollectionUtil.isNotEmpty(scannedTools)) {
            Map<String, List<McpToolGroupMeta>> groupMap = scannedTools.stream().collect(Collectors.groupingBy(item -> item.getGroupId() + "|" + item.getGroupName()));
            for (Map.Entry<String, List<McpToolGroupMeta>> entry : groupMap.entrySet()) {
                String[] split = entry.getKey().split("\\|");
                McpMonitorGroupVO monitorGroupVO = McpMonitorGroupVO.builder().groupId(split[0]).groupName(split[1]).count(entry.getValue().size()).build();
                mcpMonitorGroupVOS.add(monitorGroupVO);
            }
        }
        return ActionResult.success(mcpMonitorGroupVOS);
    }

    @GetMapping(value={"/group/{groupId}"})
    public ActionResult groupByGroupId(@PathVariable(value="groupId") String groupId) {
        List<McpToolGroupMeta> scannedTools = this.groupScanner.getScannedTools();
        List<McpToolGroupMeta> targetList = scannedTools.stream().filter(item -> groupId.equals(item.getGroupId())).toList();
        Set targetNames = targetList.stream().map(McpToolGroupMeta::getToolName).collect(Collectors.toSet());
        ArrayList toolSpecifications = new ArrayList(this.tools.stream().flatMap(Collection::stream).toList());
        List<McpSchema.Tool> matchedTools = toolSpecifications.stream().filter(spec -> targetNames.contains(spec.tool().name())).map(item -> item.tool()).toList();
        return ActionResult.success(matchedTools);
    }
}

