/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ai.config;

import com.bringspring.ai.service.McpBaseServer;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.Filter;
import org.noear.solon.Solon;
import org.noear.solon.ai.chat.tool.MethodToolProvider;
import org.noear.solon.ai.chat.tool.ToolProvider;
import org.noear.solon.ai.mcp.server.McpServerEndpointProvider;
import org.noear.solon.ai.mcp.server.annotation.McpServerEndpoint;
import org.noear.solon.ai.mcp.server.prompt.MethodPromptProvider;
import org.noear.solon.ai.mcp.server.prompt.PromptProvider;
import org.noear.solon.ai.mcp.server.resource.MethodResourceProvider;
import org.noear.solon.ai.mcp.server.resource.ResourceProvider;
import org.noear.solon.web.servlet.SolonServletFilter;
import org.springframework.aop.support.AopUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationUtils;

@ConditionalOnProperty(name={"config.mcp.enabled"}, havingValue="true", matchIfMissing=false)
@Configuration
public class McpServerConfig {
    @PostConstruct
    public void start() {
        Solon.start(McpServerConfig.class, (String[])new String[]{"--cfg=application-mcp.yml"});
    }

    @PreDestroy
    public void stop() {
        if (Solon.app() != null) {
            Solon.stopBlock((boolean)false, (int)Solon.cfg().stopDelay());
        }
    }

    @Bean
    public McpServerConfig init(List<McpBaseServer> serverEndpoints) {
        for (McpBaseServer serverEndpoint : serverEndpoints) {
            Class serverEndpointClz = AopUtils.getTargetClass((Object)serverEndpoint);
            McpServerEndpoint anno = (McpServerEndpoint)AnnotationUtils.findAnnotation((Class)serverEndpointClz, McpServerEndpoint.class);
            if (anno == null) continue;
            McpServerEndpointProvider serverEndpointProvider = McpServerEndpointProvider.builder().from(serverEndpointClz, anno).build();
            serverEndpointProvider.addTool((ToolProvider)new MethodToolProvider(serverEndpointClz, (Object)serverEndpoint));
            serverEndpointProvider.addResource((ResourceProvider)new MethodResourceProvider(serverEndpointClz, (Object)serverEndpoint));
            serverEndpointProvider.addPrompt((PromptProvider)new MethodPromptProvider(serverEndpointClz, (Object)serverEndpoint));
            serverEndpointProvider.postStart();
        }
        return this;
    }

    @Bean
    public FilterRegistrationBean mcpServerFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setName("SolonFilter");
        filter.addUrlPatterns(new String[]{"/mcp/*"});
        filter.setFilter((Filter)new SolonServletFilter());
        return filter;
    }
}

