package com.bringspring.ai.example;

import cn.hutool.core.date.DateUtil;
import com.bringspring.ai.service.McpBaseServer;
import org.noear.solon.ai.annotation.ResourceMapping;
import org.noear.solon.ai.annotation.ToolMapping;
import org.noear.solon.ai.mcp.client.McpClientProvider;
import org.noear.solon.ai.mcp.server.annotation.McpServerEndpoint;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.Map;

/**
 * 公共MCP服务端工具类
 * */
@Service
@McpServerEndpoint(name="common", sseEndpoint = "/mcp/common")
public class McpServerToolExample implements McpBaseServer {

    /**
     * 获取当前时间
     * */
    @ResourceMapping(uri = "common://getCurrentTime", description = "获取当前登陆人信息")
    public String getCurrentTime() {
        return "当前时间："+ DateUtil.now();
    }

    public static void main(String[] args) {
        McpClientProvider toolProvider = McpClientProvider.builder()
                .apiUrl("http://localhost:30000/mcp/common")
                .build();
        //工具
        Map<String, Object> map = Collections.singletonMap("location", "杭州");
        String rst = toolProvider.callToolAsText("getCurrentTime", map).getContent();
        System.out.println(rst);
    }
}