package com.bringspring.ai.util;

import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AiRequestUtils {
    // 创建并绑定模拟请求
    public static void bindMockRequest(String token) {
        if (RequestContextHolder.getRequestAttributes() == null) {
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.addHeader("Authorization", token);
            request.addHeader("jsbos-origin", "pc");
            MockHttpServletResponse response = new MockHttpServletResponse();
            ServletRequestAttributes attributes = new ServletRequestAttributes(request, response);
            RequestContextHolder.setRequestAttributes(attributes);
        }
    }

    // 清理请求绑定（重要！）
    public static void unbindRequest() {
        RequestContextHolder.resetRequestAttributes();
    }
}