package com.bringspring.app.controller;

import com.bringspring.app.entity.AppDataEntity;
import com.bringspring.app.model.AppDataCrForm;
import com.bringspring.app.model.AppDataListAllVO;
import com.bringspring.app.model.AppDataListVO;
import com.bringspring.app.model.AppFlowListAllVO;
import com.bringspring.app.service.AppDataService;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.workflow.engine.model.flowengine.FlowPagination;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.List;

/**
 * app常用数据
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-07-08
 */
@Api(tags = "app常用数据", value = "data")
@RestController
@RequestMapping("/api/app/Data")
public class AppDataController {

    @Autowired
    private AppDataService appDataService;

    /**
     * 常用数据
     *
     * @return
     */
    @ApiOperation("常用数据")
    @GetMapping
    public ActionResult list(String type) {
        List<AppDataEntity> list = appDataService.getList(type);
        List<AppDataListVO> data = JsonUtil.getJsonToList(list, AppDataListVO.class);
        ListVO listVO = new ListVO();
        listVO.setList(data);
        return ActionResult.success(listVO);
    }

    /**
     * 新建
     *
     * @param appDataCrForm dto实体
     * @return
     */
    @PostMapping
    @ApiOperation("新建")
    public ActionResult create(@RequestBody @Valid AppDataCrForm appDataCrForm) {
        AppDataEntity entity = JsonUtil.getJsonToBean(appDataCrForm, AppDataEntity.class);
        if (appDataService.isExistByObjectId(entity.getObjectId())) {
            return ActionResult.fail("常用数据已存在");
        }
        appDataService.create(entity);
        return ActionResult.success("创建成功");
    }

    /**
     * 删除
     *
     * @param objectId 对象主键
     * @return
     */
    @ApiOperation("删除")
    @DeleteMapping("/{objectId}")
    public ActionResult create(@PathVariable("objectId") String objectId) {
        AppDataEntity entity = appDataService.getInfo(objectId);
        if (entity != null) {
            appDataService.delete(entity);
            return ActionResult.success(MsgCode.SU003.get());
        }
        return ActionResult.fail(MsgCode.FA003.get());
    }

    /**
     * 所有流程
     *
     * @return
     */
    @ApiOperation("所有流程")
    @GetMapping("/getFlowList")
    public ActionResult getFlowList(FlowPagination pagination) {
        List<AppFlowListAllVO> list = appDataService.getFlowList(pagination);
        PaginationVO paginationVO = JsonUtil.getJsonToBean(pagination, PaginationVO.class);
        return ActionResult.page(list, paginationVO);
    }

    /**
     * 所有应用
     *
     * @return
     */
    @ApiOperation("所有应用")
    @GetMapping("/getDataList")
    public ActionResult getAllList() {
        List<AppDataListAllVO> result = appDataService.getDataList("2");
        ListVO listVO = new ListVO();
        listVO.setList(result);
        return ActionResult.success(listVO);
    }

}
