/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.app.controller;

import com.bringspring.app.entity.AppDataEntity;
import com.bringspring.app.model.AppDataCrForm;
import com.bringspring.app.model.AppDataListAllVO;
import com.bringspring.app.model.AppDataListVO;
import com.bringspring.app.model.AppFlowListAllVO;
import com.bringspring.app.service.AppDataService;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.workflow.engine.model.flowengine.FlowPagination;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"app\u5e38\u7528\u6570\u636e"}, value="data")
@RestController
@RequestMapping(value={"/api/app/Data"})
public class AppDataController {
    @Autowired
    private AppDataService appDataService;

    @ApiOperation(value="\u5e38\u7528\u6570\u636e")
    @GetMapping
    public ActionResult list(String type) {
        List<AppDataEntity> list = this.appDataService.getList(type);
        List data = JsonUtil.getJsonToList(list, AppDataListVO.class);
        ListVO listVO = new ListVO();
        listVO.setList(data);
        return ActionResult.success((Object)listVO);
    }

    @PostMapping
    @ApiOperation(value="\u65b0\u5efa")
    public ActionResult create(@RequestBody @Valid AppDataCrForm appDataCrForm) {
        AppDataEntity entity = (AppDataEntity)JsonUtil.getJsonToBean((Object)appDataCrForm, AppDataEntity.class);
        if (this.appDataService.isExistByObjectId(entity.getObjectId())) {
            return ActionResult.fail((String)"\u5e38\u7528\u6570\u636e\u5df2\u5b58\u5728");
        }
        this.appDataService.create(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/{objectId}"})
    public ActionResult create(@PathVariable(value="objectId") String objectId) {
        AppDataEntity entity = this.appDataService.getInfo(objectId);
        if (entity != null) {
            this.appDataService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @ApiOperation(value="\u6240\u6709\u6d41\u7a0b")
    @GetMapping(value={"/getFlowList"})
    public ActionResult getFlowList(FlowPagination pagination) {
        List<AppFlowListAllVO> list = this.appDataService.getFlowList(pagination);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page(list, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u6240\u6709\u5e94\u7528")
    @GetMapping(value={"/getDataList"})
    public ActionResult getAllList() {
        List<AppDataListAllVO> result = this.appDataService.getDataList("2");
        ListVO listVO = new ListVO();
        listVO.setList(result);
        return ActionResult.success((Object)listVO);
    }
}

