package com.bringspring.app.service.impl;

import cn.hutool.core.collection.ListUtil;
import com.bringspring.app.model.AppPositionVO;
import com.bringspring.app.model.AppUserInfoVO;
import com.bringspring.app.model.AppUsersVO;
import com.bringspring.app.service.AppService;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.*;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.user.vo.UserIdListVo;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.PermissionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import static com.bringspring.common.constant.CacheConsts.SHORT_CACHE;

/**
 * app用户信息
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-08-08
 */
@Service
public class AppServiceImpl implements AppService {

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private UserRelationService userRelationService;

    @Override
    public AppUsersVO userInfo() {
        UserInfo userInfo = userProvider.get();
        UserEntity userEntity = userService.getInfo(userInfo.getUserId());
        AppUsersVO usersVO = new AppUsersVO();
        usersVO.setBirthday(userEntity.getBirthday() != null ? userEntity.getBirthday().getTime() : null);
        usersVO.setEmail(userEntity.getEmail());
        usersVO.setGender(userEntity.getGender());
        usersVO.setMobilePhone(userEntity.getMobilePhone());
        this.data(usersVO, userEntity, userInfo);
        this.userInfo(usersVO, userInfo);
        //岗位
        PositionEntity position = positionService.getInfo(userEntity.getPositionId());
        AppPositionVO positionVO = new AppPositionVO();
        if(position != null){
            positionVO.setId(position.getId());
            positionVO.setName(position.getFullName());
            usersVO.setPositionIds(ListUtil.toList(positionVO));
        }
        //直属主管
        if(StringUtils.isNotEmpty(userEntity.getManagerId())){
            UserEntity menager = userService.getInfo(userEntity.getManagerId());
            usersVO.setManager(menager != null ? menager.getRealName(): "");
        }
        //角色
        List<String> roles = roleService.getAllRoleIdsByUserIdAndOrgId(userInfo.getUserId(), usersVO.getOrganizeId());
        List<RoleEntity> roleList = roleService.getListByIds(roles);
        usersVO.setRoleName(String.join(",", roleList.stream().map(RoleEntity::getFullName).collect(Collectors.toList())));
        usersVO.setRoleId(String.join(".", roleList.stream().map(RoleEntity::getId).collect(Collectors.toList())));
        return usersVO;
    }

    @Override
    public AppUserInfoVO getInfo(String id) {
        AppUserInfoVO userInfoVO = new AppUserInfoVO();
        UserEntity entity = userService.getInfo(id);
        if (entity != null) {
            userInfoVO = JsonUtil.getJsonToBean(entity, AppUserInfoVO.class);
            List<String> positionIds = StringUtils.isNotEmpty(entity.getPositionId()) ? Arrays.asList(entity.getPositionId().split(",")) : new ArrayList<>();
            List<String> positionName = positionService.getPositionName(positionIds).stream().map(t -> t.getFullName()).collect(Collectors.toList());
            userInfoVO.setPositionName(String.join(",", positionName));
            OrganizeEntity info = organizeService.getInfo(entity.getOrganizeId());
            userInfoVO.setOrganizeName(info != null ? info.getFullName() : "");
//            userInfoVO.setHeadIcon(UploaderUtil.uploaderImg(userInfoVO.getHeadIcon()));
            userInfoVO.setHeadIcon(userInfoVO.getHeadIcon());
        }
        return userInfoVO;
    }
    /**
     * 赋值
     *
     * @param userInfo
     * @param userId
     * @param isAdmin
     */
    private void userInfo(UserInfo userInfo, String userId, boolean isAdmin,UserEntity userEntity) {
        List<UserRelationEntity> data = userRelationService.getListByUserId(userId);
        //获取一个字段的值
        List<String> positionList = data.stream().filter(m -> "Position".equals(m.getObjectType())).map(t -> t.getObjectId()).collect(Collectors.toList());
        Set<String> id = new LinkedHashSet<>();
        String[] position = StringUtils.isNotEmpty(userEntity.getPositionId()) ? userEntity.getPositionId().split(",") : new String[]{};
        List<String> positions = positionList.stream().filter(t->Arrays.asList(position).contains(t)).collect(Collectors.toList());
        id.addAll(positions);
        id.addAll(positionList);
        userInfo.setPositionIds(id.toArray(new String[id.size()]));
        if (!isAdmin) {
            data = data.stream().filter(m -> "Role".equals(m.getObjectType())).collect(Collectors.toList());
        }
        List<String> roleList = data.stream().map(t -> t.getObjectId()).collect(Collectors.toList());
        userInfo.setRoleIds(roleList);
    }

    private void data(AppUsersVO usersVO, UserEntity userEntity, UserInfo userInfo) {
        //组织
        usersVO.setOrganizeId(userEntity.getOrganizeId());
        usersVO.setOrganizeName(PermissionUtil.getLinkInfoByOrgId(userEntity.getOrganizeId(), organizeService, false));
        OrganizeEntity organizeEntity = organizeService.getInfo(userEntity.getOrganizeId());
        if (organizeEntity != null) {
            String[] organizeId = StringUtils.isNotEmpty(organizeEntity.getOrganizeIdTree()) ? organizeEntity.getOrganizeIdTree().split(",") : new String[]{};
            if (organizeId.length > 0) {
                userInfo.setOrganizeId(organizeId[0]);
                userInfo.setDepartmentId(organizeId[organizeId.length - 1]);
            }
        }
        userInfo.setManagerId(userInfo.getManagerId());
        boolean b = userInfo.getIsAdministrator();
        List<String> subordinateIdsList = userService.getListByManagerId(userInfo.getUserId(), null).stream().map(UserIdListVo::getId).collect(Collectors.toList());
        userInfo.setSubordinateIds(subordinateIdsList);
        this.userInfo(userInfo, userInfo.getUserId(), b,userEntity);
        userInfo.setSubOrganizeIds(new String[]{});
        cacheUtil.insert(SHORT_CACHE, userInfo.getId(), userInfo,
                DateUtil.getTime(userInfo.getOverdueTime()) - DateUtil.getTime(new Date()));
    }

    /**
     * 登录信息
     *
     * @param appUsersVO 返回对象
     * @param userInfo   回话信息
     * @return
     */
    private void userInfo(AppUsersVO appUsersVO, UserInfo userInfo) {
        appUsersVO.setUserId(userInfo.getUserId());
//        appUsersVO.setHeadIcon(UploaderUtil.uploaderImg(userInfo.getUserIcon()));
        appUsersVO.setHeadIcon(userInfo.getUserIcon());
        appUsersVO.setUserName(userInfo.getRealName());
        appUsersVO.setUserAccount(userInfo.getUserAccount());
    }


}
