package com.bringspring.app.controller;

import com.bringspring.app.model.AppMenuListVO;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Page;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.model.app.AppMenuModel;
import com.bringspring.common.model.login.UserMenuModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.treeutil.ListToTreeUtil;
import com.bringspring.common.util.treeutil.SumTree;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.model.module.ModuleModel;
import com.bringspring.system.base.service.ModuleService;
import com.bringspring.system.permission.model.authorize.AuthorizeVO;
import com.bringspring.system.permission.service.AuthorizeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * app应用
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-07-08
 */
@Api(tags = "app应用", value = "Menu")
@RestController
@RequestMapping("/api/app/Menu")
public class AppMenuController {

    @Autowired
    private ModuleService moduleService;
    @Autowired
    private AuthorizeService authorizeService;

    /**
     * app应用
     *
     * @return
     */
    @ApiOperation("获取菜单列表")
    @GetMapping
    public ActionResult<ListVO<AppMenuModel>> list(Page page) {
        AuthorizeVO authorizeModel = authorizeService.getAuthorize(true);
        //获取app的菜单以及系统级别菜单
        List<ModuleModel> buttonListAll = authorizeModel.getModuleList().stream().filter(t -> "App".equals(t.getCategory()) || t.getType()==0).collect(Collectors.toList());
        List<ModuleModel> buttonList = buttonListAll;
        if (StringUtils.isNotEmpty(page.getKeyword())) {
            buttonList = buttonListAll.stream().filter(t -> t.getFullName().contains(page.getKeyword())).collect(Collectors.toList());
        }
        List<UserMenuModel> list = JsonUtil.getJsonToList(ListToTreeUtil.treeWhere(buttonList, buttonListAll), UserMenuModel.class);
        List<SumTree<UserMenuModel>> menuAll = TreeDotUtils.convertListToTreeDot(list, "-1");
        List<AppMenuListVO> data = JsonUtil.getJsonToList(menuAll, AppMenuListVO.class);
        ListVO listVO = new ListVO();
        listVO.setList(data);
        return ActionResult.success(listVO);
    }

}
