package com.bringspring.app.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * app常用数据
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-07-08
 */
@Data
@TableName("BASE_APP_DATA")
public class AppDataEntity {
    /**
     * 单据主键
     */
    @TableId("ID")
    private String id;

    /**
     * 对象类型
     */
    @TableField("OBJECT_TYPE")
    private String objectType;

    /**
     * 对象主键
     */
    @TableField("OBJECT_ID")
    private String objectId;

    /**
     * 数据
     */
    @TableField("OBJECT_DATA")
    private String objectData;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;
}
