/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.app.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.app.entity.AppDataEntity;
import com.bringspring.app.mapper.AppDataMapper;
import com.bringspring.app.model.AppDataListAllVO;
import com.bringspring.app.model.AppFlowListAllVO;
import com.bringspring.app.service.AppDataService;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.model.login.UserMenuModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.ModuleService;
import com.bringspring.system.permission.model.authorize.AuthorizeVO;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.model.flowengine.FlowPagination;
import com.bringspring.workflow.engine.service.FlowEngineService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppDataServiceImpl
extends ServiceImpl<AppDataMapper, AppDataEntity>
implements AppDataService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private DictionaryDataService dictionaryDataService;

    @Override
    public List<AppDataEntity> getList(String type) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(AppDataEntity::getObjectType, (Object)type)).eq(AppDataEntity::getCreatorUserId, (Object)userInfo.getUserId());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<AppDataEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public AppDataEntity getInfo(String objectId) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(AppDataEntity::getObjectId, (Object)objectId)).eq(AppDataEntity::getCreatorUserId, (Object)userInfo.getUserId());
        return (AppDataEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean isExistByObjectId(String objectId) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(AppDataEntity::getObjectId, (Object)objectId)).eq(AppDataEntity::getCreatorUserId, (Object)userInfo.getUserId());
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public void create(AppDataEntity entity) {
        UserInfo userInfo = this.userProvider.get();
        entity.setId(RandomUtil.uuId());
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setCreatorTime(new Date());
        entity.setEnabledMark(1);
        this.save(entity);
    }

    @Override
    public void delete(AppDataEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    public void delete(String objectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AppDataEntity::getObjectId, (Object)objectId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public List<AppFlowListAllVO> getFlowList(FlowPagination pagination) {
        List<AppDataEntity> dataList = this.getList("1");
        List objectId = dataList.stream().map(AppDataEntity::getObjectId).collect(Collectors.toList());
        List pageList = this.flowEngineService.getPageList(pagination);
        ArrayList<AppFlowListAllVO> result = new ArrayList<AppFlowListAllVO>();
        for (FlowEngineEntity entity : pageList) {
            AppFlowListAllVO vo = (AppFlowListAllVO)JsonUtil.getJsonToBean((Object)entity, AppFlowListAllVO.class);
            vo.setIsData(objectId.contains(vo.getId()));
            result.add(vo);
        }
        return result;
    }

    @Override
    public List<AppDataListAllVO> getDataList(String type) {
        List<AppDataEntity> dataList = this.getList(type);
        AuthorizeVO authorizeModel = this.authorizeService.getAuthorize(true);
        List buttonList = authorizeModel.getModuleList();
        List menuList = this.moduleService.getList().stream().filter(t -> "App".equals(t.getCategory()) && t.getEnabledMark() == 1).collect(Collectors.toList());
        LinkedList<UserMenuModel> list = new LinkedList<UserMenuModel>();
        for (ModuleEntity module : menuList) {
            boolean count = buttonList.stream().filter(t -> t.getId().equals(module.getId())).count() > 0L;
            UserMenuModel userMenuModel = (UserMenuModel)JsonUtil.getJsonToBean((Object)module, UserMenuModel.class);
            if (!count) continue;
            boolean isData = dataList.stream().filter(t -> t.getObjectId().equals(module.getId())).count() > 0L;
            userMenuModel.setIsData(Boolean.valueOf(isData));
            list.add(userMenuModel);
        }
        List menuAll = TreeDotUtils.convertListToTreeDot(list);
        List menuListAll = JsonUtil.getJsonToList((Object)menuAll, AppDataListAllVO.class);
        LinkedList<AppDataListAllVO> data = new LinkedList<AppDataListAllVO>();
        for (AppDataListAllVO appMenu : menuListAll) {
            if (!"-1".equals(appMenu.getParentId())) continue;
            data.add(appMenu);
        }
        return data;
    }
}

