package com.bringspring.app.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.app.entity.AppDataEntity;
import com.bringspring.app.model.AppDataListAllVO;
import com.bringspring.app.model.AppFlowListAllVO;
import com.bringspring.workflow.engine.model.flowengine.FlowPagination;

import java.util.List;

/**
 * app常用数据
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-07-08
 */
public interface AppDataService extends IService<AppDataEntity> {

    /**
     * 列表
     *
     * @param type 类型
     * @return
     */
    List<AppDataEntity> getList(String type);

    /**
     * 列表
     *
     * @return
     */
    List<AppDataEntity> getList();

    /**
     * 信息
     *
     * @param objectId 对象主键
     * @return
     */
    AppDataEntity getInfo(String objectId);

    /**
     * 验证名称
     *
     * @param objectId 对象主键
     * @return
     */
    boolean isExistByObjectId(String objectId);

    /**
     * 创建
     *
     * @param entity 实体对象
     */
    void create(AppDataEntity entity);

    /**
     * 删除
     *
     * @param entity 实体对象
     */
    void delete(AppDataEntity entity);

    /**
     * 删除
     *
     * @param objectId 应用主键
     */
    void delete(String objectId);

    /**
     * 流程所有应用
     *
     * @param pagination
     * @return
     */
    List<AppFlowListAllVO> getFlowList(FlowPagination pagination);

    /**
     * 流程所有应用
     *
     * @param type 类型
     * @return
     */
    List<AppDataListAllVO> getDataList(String type ,String systemId);

}
