package com.bringspring.app.controller;

import com.bringspring.app.model.AppUserInfoVO;
import com.bringspring.app.model.AppUsersVO;
import com.bringspring.app.service.AppService;
import com.bringspring.common.base.ActionResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 用户信息
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-07-08
 */
@Api(tags = "app用户信息", value = "User")
@RestController
@RequestMapping("/api/app/User")
public class AppUserController {

    @Autowired
    private AppService appService;

    /**
     * 用户信息
     *
     * @return
     */
    @ApiOperation("用户信息")
    @GetMapping
    public ActionResult getInfo() {
        AppUsersVO userAllVO = appService.userInfo();
        return ActionResult.success(userAllVO);
    }

    /**
     * 通讯录详情
     *
     * @return
     */
    @ApiOperation("通讯录详情")
    @GetMapping("/{id}")
    public ActionResult userInfo(@PathVariable("id") String id) {
        AppUserInfoVO userInfoVO = appService.getInfo(id);
        return ActionResult.success(userInfoVO);
    }

}
