package com.bringspring.app.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.NoDataSourceBind;
import com.bringspring.system.base.service.SysConfigService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.commons.collections4.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * 获取AppVersion
 *
 * @author ：RKKJ开发平台组
 * @version: V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date ：2022/3/31 11:26
 */
@Tag(name = "获取APP版本号")
@RestController
@RequestMapping("/api/app")
public class AppVersionController {
    @Autowired
    private SysConfigService sysConfigService;

    /**
     * 判断是否需要验证码
     *
     * @return
     */
    @NoDataSourceBind()
    @Operation(summary = "判断是否需要验证码")
    @GetMapping("/Version")
    public ActionResult getAppVersion() {
        String sysVersion = sysConfigService.getSysInfo().getSysVersion();
        Map<String, String> map = new HashedMap<>();
        map.put("sysVersion", sysVersion);
        return ActionResult.success(map);
    }
}
