/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.app.service.impl;

import cn.hutool.core.collection.ListUtil;
import com.bringspring.app.model.AppPositionVO;
import com.bringspring.app.model.AppUserInfoVO;
import com.bringspring.app.model.AppUsersVO;
import com.bringspring.app.service.AppService;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.user.vo.UserBaseVO;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.PermissionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppServiceImpl
implements AppService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private UserRelationService userRelationService;

    @Override
    public AppUsersVO userInfo() {
        UserInfo userInfo = this.userProvider.get();
        UserEntity userEntity = this.userService.getInfo(userInfo.getUserId());
        AppUsersVO usersVO = new AppUsersVO();
        usersVO.setBirthday(userEntity.getBirthday() != null ? Long.valueOf(userEntity.getBirthday().getTime()) : null);
        usersVO.setEmail(userEntity.getEmail());
        usersVO.setGender(userEntity.getGender());
        usersVO.setMobilePhone(userEntity.getMobilePhone());
        this.data(usersVO, userEntity, userInfo);
        this.userInfo(usersVO, userInfo);
        PositionEntity position = this.positionService.getInfo(userEntity.getPositionId());
        AppPositionVO positionVO = new AppPositionVO();
        if (position != null) {
            positionVO.setId(position.getId());
            positionVO.setName(position.getFullName());
            usersVO.setPositionIds(ListUtil.toList((Object[])new AppPositionVO[]{positionVO}));
        }
        if (StringUtils.isNotEmpty((String)userEntity.getManagerId())) {
            UserEntity menager = this.userService.getInfo(userEntity.getManagerId());
            usersVO.setManager(menager != null ? menager.getRealName() : "");
        }
        List roles = this.roleService.getAllRoleIdsByUserIdAndOrgId(userInfo.getUserId(), usersVO.getOrganizeId());
        List roleList = this.roleService.getListByIds(roles);
        usersVO.setRoleName(String.join((CharSequence)",", roleList.stream().map(PermissionEntityBase::getFullName).collect(Collectors.toList())));
        usersVO.setRoleId(String.join((CharSequence)".", roleList.stream().map(PermissionEntityBase::getId).collect(Collectors.toList())));
        return usersVO;
    }

    @Override
    public AppUserInfoVO getInfo(String id) {
        AppUserInfoVO userInfoVO = new AppUserInfoVO();
        UserEntity entity = this.userService.getInfo(id);
        if (entity != null) {
            userInfoVO = (AppUserInfoVO)JsonUtil.getJsonToBean((Object)entity, AppUserInfoVO.class);
            ArrayList positionIds = StringUtils.isNotEmpty((String)entity.getPositionId()) ? Arrays.asList(entity.getPositionId().split(",")) : new ArrayList();
            List positionName = this.positionService.getPositionName(positionIds).stream().map(t -> t.getFullName()).collect(Collectors.toList());
            userInfoVO.setPositionName(String.join((CharSequence)",", positionName));
            OrganizeEntity info = this.organizeService.getInfo(entity.getOrganizeId());
            userInfoVO.setOrganizeName(info != null ? info.getFullName() : "");
            userInfoVO.setHeadIcon(userInfoVO.getHeadIcon());
        }
        return userInfoVO;
    }

    private void userInfo(UserInfo userInfo, String userId, boolean isAdmin, UserEntity userEntity) {
        List data = this.userRelationService.getListByUserId(userId);
        List positionList = data.stream().filter(m -> "Position".equals(m.getObjectType())).map(t -> t.getObjectId()).collect(Collectors.toList());
        LinkedHashSet id = new LinkedHashSet();
        String[] position = StringUtils.isNotEmpty((String)userEntity.getPositionId()) ? userEntity.getPositionId().split(",") : new String[]{};
        List positions = positionList.stream().filter(t -> Arrays.asList(position).contains(t)).collect(Collectors.toList());
        id.addAll(positions);
        id.addAll(positionList);
        userInfo.setPositionIds((List)ListUtil.toList(id));
        if (!isAdmin) {
            data = data.stream().filter(m -> "Role".equals(m.getObjectType())).collect(Collectors.toList());
        }
        List roleList = data.stream().map(t -> t.getObjectId()).collect(Collectors.toList());
        userInfo.setRoleIds(roleList);
    }

    private void data(AppUsersVO usersVO, UserEntity userEntity, UserInfo userInfo) {
        usersVO.setOrganizeId(userEntity.getOrganizeId());
        usersVO.setOrganizeName(PermissionUtil.getLinkInfoByOrgId((String)userEntity.getOrganizeId(), (OrganizeService)this.organizeService, (Boolean)false));
        OrganizeEntity organizeEntity = this.organizeService.getInfo(userEntity.getOrganizeId());
        if (organizeEntity != null) {
            String[] organizeId;
            String[] stringArray = organizeId = StringUtils.isNotEmpty((String)organizeEntity.getOrganizeIdTree()) ? organizeEntity.getOrganizeIdTree().split(",") : new String[]{};
            if (organizeId.length > 0) {
                userInfo.setOrganizeId(organizeId[0]);
                userInfo.setDepartmentId(organizeId[organizeId.length - 1]);
            }
        }
        userInfo.setManagerId(userInfo.getManagerId());
        boolean b = userInfo.getIsAdministrator();
        List subordinateIdsList = this.userService.getListByManagerId(userInfo.getUserId(), null).stream().map(UserBaseVO::getId).collect(Collectors.toList());
        userInfo.setSubordinateIds(subordinateIdsList);
        this.userInfo(userInfo, userInfo.getUserId(), b, userEntity);
        userInfo.setSubOrganizeIds(new ArrayList());
        this.cacheUtil.insert("shortCacheSpace", userInfo.getId(), (Object)userInfo, DateUtil.getTime((Date)userInfo.getOverdueTime()) - DateUtil.getTime((Date)new Date()));
    }

    private void userInfo(AppUsersVO appUsersVO, UserInfo userInfo) {
        appUsersVO.setUserId(userInfo.getUserId());
        appUsersVO.setHeadIcon(userInfo.getUserIcon());
        appUsersVO.setUserName(userInfo.getRealName());
        appUsersVO.setUserAccount(userInfo.getUserAccount());
    }
}

