package com.bringspring.app.model;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import jakarta.validation.constraints.NotBlank;

/**
 * app常用数据
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021-07-08
 */
@Data
public class AppDataCrForm {
    @NotBlank(message = "必填")
    @Schema(description = "应用类型")
    private String objectType;
    @NotBlank(message = "必填")
    @Schema(description = "应用主键")
    private String objectId;
    @Schema(description = "数据")
    private String objectData;
}
