/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.app.controller;

import com.bringspring.app.entity.AppDataEntity;
import com.bringspring.app.model.AppDataCrForm;
import com.bringspring.app.model.AppDataListAllVO;
import com.bringspring.app.model.AppDataListVO;
import com.bringspring.app.model.AppFlowListAllVO;
import com.bringspring.app.service.AppDataService;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.workflow.engine.model.flowengine.FlowPagination;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="APP\u5e38\u7528\u6570\u636e", description="\u79fb\u52a8\u7aef\u5e94\u7528\u6570\u636e\u7ba1\u7406\uff0c\u5305\u62ec\u5e38\u7528\u6570\u636e\u3001\u6d41\u7a0b\u3001\u5e94\u7528\u7b49")
@RestController
@RequestMapping(value={"/api/app/Data"})
public class AppDataController {
    @Autowired
    private AppDataService appDataService;

    @Operation(summary="\u83b7\u53d6\u5e38\u7528\u6570\u636e\u5217\u8868", description="\u6839\u636e\u7c7b\u578b\u83b7\u53d6APP\u5e38\u7528\u6570\u636e\u5217\u8868")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\u6210\u529f\u83b7\u53d6\u5e38\u7528\u6570\u636e\u5217\u8868"), @ApiResponse(responseCode="400", description="\u53c2\u6570\u9519\u8bef"), @ApiResponse(responseCode="500", description="\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef")})
    @GetMapping
    public ActionResult list(@Parameter(description="\u6570\u636e\u7c7b\u578b") String type) {
        List<AppDataEntity> list = this.appDataService.getList(type);
        List data = JsonUtil.getJsonToList(list, AppDataListVO.class);
        ListVO listVO = new ListVO();
        listVO.setList(data);
        return ActionResult.success((Object)listVO);
    }

    @Operation(summary="\u6dfb\u52a0\u5e38\u7528\u6570\u636e", description="\u6dfb\u52a0\u65b0\u7684APP\u5e38\u7528\u6570\u636e")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\u5e38\u7528\u6570\u636e\u6dfb\u52a0\u6210\u529f"), @ApiResponse(responseCode="400", description="\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25"), @ApiResponse(responseCode="409", description="\u5e38\u7528\u6570\u636e\u5df2\u5b58\u5728"), @ApiResponse(responseCode="500", description="\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef")})
    @PostMapping
    public ActionResult create(@Parameter(description="\u5e38\u7528\u6570\u636e\u8868\u5355", required=true) @RequestBody @Valid AppDataCrForm appDataCrForm) {
        AppDataEntity entity = (AppDataEntity)JsonUtil.getJsonToBean((Object)appDataCrForm, AppDataEntity.class);
        if (this.appDataService.isExistByObjectId(entity.getObjectId())) {
            return ActionResult.fail((String)"\u5e38\u7528\u6570\u636e\u5df2\u5b58\u5728");
        }
        this.appDataService.create(entity);
        return ActionResult.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @Operation(summary="\u5220\u9664\u5e38\u7528\u6570\u636e", description="\u6839\u636e\u5bf9\u8c61ID\u5220\u9664\u5e38\u7528\u6570\u636e")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="\u5e38\u7528\u6570\u636e\u5220\u9664\u6210\u529f"), @ApiResponse(responseCode="404", description="\u5e38\u7528\u6570\u636e\u4e0d\u5b58\u5728"), @ApiResponse(responseCode="500", description="\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef")})
    @DeleteMapping(value={"/{objectId}"})
    public ActionResult delete(@Parameter(description="\u5bf9\u8c61ID", required=true) @PathVariable(value="objectId") String objectId) {
        AppDataEntity entity = this.appDataService.getInfo(objectId);
        if (entity != null) {
            this.appDataService.delete(entity);
            return ActionResult.success((String)"\u79fb\u9664\u6210\u529f");
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @Operation(summary="\u6240\u6709\u6d41\u7a0b")
    @GetMapping(value={"/getFlowList"})
    public ActionResult getFlowList(FlowPagination pagination) {
        List<AppFlowListAllVO> list = this.appDataService.getFlowList(pagination);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page(list, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u6240\u6709\u5e94\u7528")
    @GetMapping(path={"/getDataList/{systemId}", "/getDataList"})
    public ActionResult getAllList(@PathVariable(value="systemId", required=false) String systemId) {
        if (StringUtils.isEmpty((String)systemId)) {
            systemId = "-1";
        }
        List<AppDataListAllVO> result = this.appDataService.getDataList("2", systemId);
        ListVO listVO = new ListVO();
        listVO.setList(result);
        return ActionResult.success((Object)listVO);
    }
}

