/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.assets.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.assets.entity.OfFixedAssetsLogsEntity;
import com.bringspring.assets.model.offixedassetslogs.OfFixedAssetsLogsCrForm;
import com.bringspring.assets.model.offixedassetslogs.OfFixedAssetsLogsInfoVO;
import com.bringspring.assets.model.offixedassetslogs.OfFixedAssetsLogsListVO;
import com.bringspring.assets.model.offixedassetslogs.OfFixedAssetsLogsPagination;
import com.bringspring.assets.model.offixedassetslogs.OfFixedAssetsLogsPaginationExportModel;
import com.bringspring.assets.model.offixedassetslogs.OfFixedAssetsLogsUpForm;
import com.bringspring.assets.service.OfFixedAssetsLogsService;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/assets/OfFixedAssetsLogs"})
public class OfFixedAssetsLogsController {
    private static final Logger log = LoggerFactory.getLogger(OfFixedAssetsLogsController.class);
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OfFixedAssetsLogsService ofFixedAssetsLogsService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OfFixedAssetsLogsPagination ofFixedAssetsLogsPagination) throws IOException {
        List<OfFixedAssetsLogsEntity> list = this.ofFixedAssetsLogsService.getList(ofFixedAssetsLogsPagination);
        List listVO = JsonUtil.getJsonToList(list, OfFixedAssetsLogsListVO.class);
        Iterator iterator = listVO.iterator();
        while (iterator.hasNext()) {
            OfFixedAssetsLogsListVO VO;
            VO.setCreatorTimeFormat(ObjectUtil.isNull((Object)(VO = (OfFixedAssetsLogsListVO)iterator.next()).getCreatorTime()) ? null : DateUtil.dateFormat((Date)VO.getCreatorTime()));
            VO.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(VO.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ofFixedAssetsLogsPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid OfFixedAssetsLogsCrForm ofFixedAssetsLogsCrForm) throws DataException {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        OfFixedAssetsLogsEntity entity = (OfFixedAssetsLogsEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsLogsCrForm, OfFixedAssetsLogsEntity.class);
        this.ofFixedAssetsLogsService.create(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OfFixedAssetsLogsPaginationExportModel ofFixedAssetsLogsPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)ofFixedAssetsLogsPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OfFixedAssetsLogsPagination ofFixedAssetsLogsPagination = (OfFixedAssetsLogsPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)ofFixedAssetsLogsPaginationExportModel), OfFixedAssetsLogsPagination.class));
        List<OfFixedAssetsLogsEntity> list = this.ofFixedAssetsLogsService.getTypeList(ofFixedAssetsLogsPagination, ofFixedAssetsLogsPaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, OfFixedAssetsLogsListVO.class);
        for (OfFixedAssetsLogsListVO ofFixedAssetsLogsListVO : listVO) {
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)ofFixedAssetsLogsPaginationExportModel.getSelectKey()) ? ofFixedAssetsLogsPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block28: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "fixedAssetsId": {
                        entitys.add(new ExcelExportEntity("\u56fa\u5b9a\u8d44\u4ea7", (Object)"fixedAssetsId"));
                        continue block28;
                    }
                    case "newValue": {
                        entitys.add(new ExcelExportEntity("\u65b0\u503c", (Object)"newValue"));
                        continue block28;
                    }
                    case "oldValue": {
                        entitys.add(new ExcelExportEntity("\u65e7\u503c", (Object)"oldValue"));
                        continue block28;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u63cf\u8ff0", (Object)"description"));
                        continue block28;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block28;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block28;
                    }
                    case "lastModifyUserId": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u7528\u6237", (Object)"lastModifyUserId"));
                        continue block28;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u65f6\u95f4", (Object)"lastModifyTime"));
                        continue block28;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OfFixedAssetsLogsInfoVO> info(@PathVariable(value="id") String id) {
        OfFixedAssetsLogsEntity entity = this.ofFixedAssetsLogsService.getInfo(id);
        OfFixedAssetsLogsInfoVO vo = (OfFixedAssetsLogsInfoVO)JsonUtil.getJsonToBean((Object)entity, OfFixedAssetsLogsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OfFixedAssetsLogsInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OfFixedAssetsLogsEntity entity = this.ofFixedAssetsLogsService.getInfo(id);
        OfFixedAssetsLogsInfoVO vo = (OfFixedAssetsLogsInfoVO)JsonUtil.getJsonToBean((Object)entity, OfFixedAssetsLogsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OfFixedAssetsLogsUpForm ofFixedAssetsLogsUpForm) throws DataException {
        OfFixedAssetsLogsEntity entity = this.ofFixedAssetsLogsService.getInfo(id);
        if (entity != null) {
            OfFixedAssetsLogsEntity subentity = (OfFixedAssetsLogsEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsLogsUpForm, OfFixedAssetsLogsEntity.class);
            this.ofFixedAssetsLogsService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        OfFixedAssetsLogsEntity entity = this.ofFixedAssetsLogsService.getInfo(id);
        if (entity != null) {
            this.ofFixedAssetsLogsService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/batchRemove/{ids}"})
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        if (StringUtils.isNotEmpty((String)ids)) {
            this.ofFixedAssetsLogsService.delete(ids);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

