/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.assets.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.assets.entity.OfFixedAssetsOrderEntity;
import com.bringspring.assets.model.fixedassets.OfFixedAssetsPagination;
import com.bringspring.assets.model.offixedassetsorder.OfFixedAssetsOrderCrForm;
import com.bringspring.assets.model.offixedassetsorder.OfFixedAssetsOrderInfoVO;
import com.bringspring.assets.model.offixedassetsorder.OfFixedAssetsOrderListVO;
import com.bringspring.assets.model.offixedassetsorder.OfFixedAssetsOrderPagination;
import com.bringspring.assets.model.offixedassetsorder.OfFixedAssetsOrderSelector;
import com.bringspring.assets.model.offixedassetsorder.OfFixedAssetsOrderUpForm;
import com.bringspring.assets.service.OfFixedAssetsOrderItemService;
import com.bringspring.assets.service.OfFixedAssetsOrderService;
import com.bringspring.assets.service.OfFixedAssetsService;
import com.bringspring.assets.service.OfFixedAssetsTypeService;
import com.bringspring.assets.util.Constants;
import com.bringspring.assets.util.FixedAssetsOrderItemStateEnum;
import com.bringspring.assets.util.FixedAssetsOrderStateEnum;
import com.bringspring.assets.util.InventoryWayEnum;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.logistics.service.BasSpaceService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d44\u4ea7\u76d8\u70b9\u8ba1\u5212\u8868"}, value="assets")
@RequestMapping(value={"/api/assets/OfFixedAssetsOrder"})
public class OfFixedAssetsOrderController {
    private static final Logger log = LoggerFactory.getLogger(OfFixedAssetsOrderController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OfFixedAssetsOrderService ofFixedAssetsOrderService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private OfFixedAssetsOrderItemService ofFixedAssetsOrderItemService;
    @Autowired
    private OfFixedAssetsTypeService ofFixedAssetsTypeService;
    @Autowired
    private OfFixedAssetsService ofFixedAssetsService;
    @Autowired
    private BasSpaceService basSpaceService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OfFixedAssetsOrderPagination ofFixedAssetsOrderPagination) throws IOException {
        List<OfFixedAssetsOrderEntity> list = this.ofFixedAssetsOrderService.getList(ofFixedAssetsOrderPagination);
        List listVO = JsonUtil.getJsonToList(list, OfFixedAssetsOrderListVO.class);
        listVO.stream().forEach(vo -> {
            OrganizeEntity companyInfo;
            vo.setBaseUserName(StrUtil.isNotBlank((CharSequence)vo.getBaseUserId()) ? this.baseDataUtil.userSelectValueNoAccount(vo.getBaseUserId()) : vo.getBaseUserId());
            if (StringUtils.isNotEmpty((String)vo.getFixedAssetsTypeId())) {
                String[] types = vo.getFixedAssetsTypeId().split(",");
                vo.setFixedAssetsTypeDesc(this.ofFixedAssetsTypeService.getNameByIds(types));
            }
            if (StringUtils.isNotEmpty((String)vo.getBasSpaceIds())) {
                String[] spaces = vo.getBasSpaceIds().split(",");
                vo.setBasSpaceDesc(this.basSpaceService.getSpaceNameByIds(spaces));
            }
            if (!ObjectUtil.isEmpty((Object)(companyInfo = this.organizeService.getInfo(vo.getCompanyId())))) {
                vo.setCompanyName(companyInfo.getFullName());
            }
        });
        PageListVO vo2 = new PageListVO();
        vo2.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ofFixedAssetsOrderPagination), PaginationVO.class);
        vo2.setPagination(page);
        return ActionResult.success((Object)vo2);
    }

    @GetMapping(value={"/getListAll"})
    public ActionResult getListAll() {
        List<OfFixedAssetsOrderEntity> list = this.ofFixedAssetsOrderService.getListAll();
        List listVO = JsonUtil.getJsonToList(list, OfFixedAssetsOrderListVO.class);
        listVO.stream().forEach(vo -> {
            vo.setBaseUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getBaseUserId()));
            if (StringUtils.isNotEmpty((String)vo.getFixedAssetsTypeId())) {
                String[] types = vo.getFixedAssetsTypeId().split(",");
                vo.setFixedAssetsTypeDesc(this.ofFixedAssetsTypeService.getNameByIds(types));
            }
            if (StringUtils.isNotEmpty((String)vo.getBasSpaceIds())) {
                String[] spaces = vo.getBasSpaceIds().split(",");
                vo.setBasSpaceDesc(this.basSpaceService.getSpaceNameByIds(spaces));
            }
            vo.setCreatorTimeFormat(ObjectUtil.isNull((Object)vo.getCreatorTime()) ? null : DateUtil.dateFormat((Date)vo.getCreatorTime()));
            vo.setLastModifyTimeFormat(ObjectUtil.isNull((Object)vo.getLastModifyTime()) ? null : DateUtil.dateFormat((Date)vo.getLastModifyTime()));
            vo.setCreatorUser(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
            vo.setLastModifyUser(this.baseDataUtil.userSelectValueNoAccount(vo.getLastModifyUserId()));
        });
        return ActionResult.success((Object)listVO);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid OfFixedAssetsOrderCrForm ofFixedAssetsOrderCrForm) throws DataException {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        ofFixedAssetsOrderCrForm.setCompanyId(this.userProvider.get().getOrganizeId());
        if (!this.ofFixedAssetsOrderService.checkUnderwayUnique(ofFixedAssetsOrderCrForm)) {
            return ActionResult.fail((String)"\u521b\u5efa\u5931\u8d25\uff0c\u5b58\u5728\u672a\u5b8c\u6210\u76d8\u70b9\u8ba1\u5212");
        }
        OfFixedAssetsPagination ofFixedAssetsPagination = new OfFixedAssetsPagination();
        ofFixedAssetsPagination.setMenuId(ofFixedAssetsOrderCrForm.getMenuId());
        ofFixedAssetsPagination.setInventoryWay(InventoryWayEnum.YES.getMark());
        if (StringUtils.isNotEmpty((String)ofFixedAssetsOrderCrForm.getFixedAssetsTypeId())) {
            String[] types = ofFixedAssetsOrderCrForm.getFixedAssetsTypeId().split(",");
            ofFixedAssetsPagination.setFixedAssetsTypeIds(types);
        }
        if (StringUtils.isNotEmpty((String)ofFixedAssetsOrderCrForm.getBasSpaceIds())) {
            String[] spaces = ofFixedAssetsOrderCrForm.getBasSpaceIds().split(",");
            ofFixedAssetsPagination.setBasSpaceIds(spaces);
        }
        if (StringUtils.isNotEmpty((String)ofFixedAssetsOrderCrForm.getAssetsNames())) {
            String[] assetsNameArr = ofFixedAssetsOrderCrForm.getAssetsNames().split(",");
            ofFixedAssetsPagination.setAssetsNames(assetsNameArr);
        }
        if (StringUtils.isNotEmpty((String)ofFixedAssetsOrderCrForm.getAssetsSorts())) {
            String[] assetsSortArr = ofFixedAssetsOrderCrForm.getAssetsSorts().split(",");
            ArrayList<String> values = new ArrayList<String>();
            for (String s : assetsSortArr) {
                values.add(s.split(":")[0]);
            }
            String[] ans2 = values.toArray(new String[values.size()]);
            ofFixedAssetsPagination.setAssetsSorts(ans2);
        }
        if (this.ofFixedAssetsService.selectAssetsCount(ofFixedAssetsPagination) <= 0L) {
            return ActionResult.fail((String)"\u521b\u5efa\u5931\u8d25\uff0c\u6240\u9009\u8d44\u4ea7\u7c7b\u578b\u4e0d\u5b58\u5728\u53ef\u76d8\u8d44\u4ea7");
        }
        OfFixedAssetsOrderEntity entity = (OfFixedAssetsOrderEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsOrderCrForm, OfFixedAssetsOrderEntity.class);
        entity.setOrderCode(this.baseDataUtil.getBillNumber(Constants.FIXED_ASSETS_ORDER_CODE, Boolean.valueOf(false)));
        this.ofFixedAssetsOrderService.create(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OfFixedAssetsOrderInfoVO> info(@PathVariable(value="id") String id) {
        OfFixedAssetsOrderEntity entity = this.ofFixedAssetsOrderService.getInfo(id);
        OfFixedAssetsOrderInfoVO vo = (OfFixedAssetsOrderInfoVO)JsonUtil.getJsonToBean((Object)entity, OfFixedAssetsOrderInfoVO.class);
        if (StringUtils.isNotEmpty((String)vo.getFixedAssetsTypeId())) {
            String[] types = vo.getFixedAssetsTypeId().split(",");
            vo.setFixedAssetsTypeDesc(this.ofFixedAssetsTypeService.getNameByIds(types));
        }
        if (StringUtils.isNotEmpty((String)vo.getBasSpaceIds())) {
            String[] spaces = vo.getBasSpaceIds().split(",");
            vo.setBasSpaceDesc(this.basSpaceService.getSpaceNameByIds(spaces));
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OfFixedAssetsOrderInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OfFixedAssetsOrderInfoVO vo;
        OfFixedAssetsOrderEntity entity = this.ofFixedAssetsOrderService.getInfo(id);
        vo.setBaseUserName(StrUtil.isNotBlank((CharSequence)(vo = (OfFixedAssetsOrderInfoVO)JsonUtil.getJsonToBean((Object)entity, OfFixedAssetsOrderInfoVO.class)).getBaseUserId()) ? this.baseDataUtil.userSelectValueNoAccount(vo.getBaseUserId()) : vo.getBaseUserId());
        if (StringUtils.isNotEmpty((String)vo.getFixedAssetsTypeId())) {
            String[] types = vo.getFixedAssetsTypeId().split(",");
            vo.setFixedAssetsTypeDesc(this.ofFixedAssetsTypeService.getNameByIds(types));
        }
        if (StringUtils.isNotEmpty((String)vo.getBasSpaceIds())) {
            String[] spaces = vo.getBasSpaceIds().split(",");
            vo.setBasSpaceDesc(this.basSpaceService.getSpaceNameByIds(spaces));
        }
        List<Map<String, Object>> list = this.ofFixedAssetsOrderItemService.countByState(id);
        vo.setItemList(list);
        Map<Integer, FixedAssetsOrderItemStateEnum> allToMap = FixedAssetsOrderItemStateEnum.getAllToMap();
        list.stream().forEach(map -> map.put("assetsState", ObjectUtil.isNotNull(map.get("assetsState")) ? ((FixedAssetsOrderItemStateEnum)((Object)((Object)allToMap.get(Integer.parseInt(map.get("assetsState").toString()))))).getDesc() : ""));
        BigDecimal sum = list.stream().map(x -> new BigDecimal(String.valueOf(x.get("stateNum")))).reduce(BigDecimal.ZERO, BigDecimal::add);
        vo.setAssetsCount(sum.intValue());
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OfFixedAssetsOrderUpForm ofFixedAssetsOrderUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        String companyId = userInfo.getOrganizeId();
        ofFixedAssetsOrderUpForm.setCompanyId(companyId);
        if (!this.ofFixedAssetsOrderService.checkUnderwayUnique(ofFixedAssetsOrderUpForm)) {
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u5b58\u5728\u672a\u5b8c\u6210\u76d8\u70b9\u8ba1\u5212");
        }
        OfFixedAssetsPagination ofFixedAssetsPagination = new OfFixedAssetsPagination();
        ofFixedAssetsPagination.setMenuId(ofFixedAssetsOrderUpForm.getMenuId());
        ofFixedAssetsPagination.setInventoryWay(InventoryWayEnum.YES.getMark());
        if (StringUtils.isNotEmpty((String)ofFixedAssetsOrderUpForm.getFixedAssetsTypeId())) {
            String[] types = ofFixedAssetsOrderUpForm.getFixedAssetsTypeId().split(",");
            ofFixedAssetsPagination.setFixedAssetsTypeIds(types);
        }
        if (StringUtils.isNotEmpty((String)ofFixedAssetsOrderUpForm.getBasSpaceIds())) {
            String[] spaces = ofFixedAssetsOrderUpForm.getBasSpaceIds().split(",");
            ofFixedAssetsPagination.setBasSpaceIds(spaces);
        }
        if (StringUtils.isNotEmpty((String)ofFixedAssetsOrderUpForm.getAssetsNames())) {
            String[] assetsNameArr = ofFixedAssetsOrderUpForm.getAssetsNames().split(",");
            ofFixedAssetsPagination.setAssetsNames(assetsNameArr);
        }
        if (StringUtils.isNotEmpty((String)ofFixedAssetsOrderUpForm.getAssetsSorts())) {
            String[] assetsSortArr = ofFixedAssetsOrderUpForm.getAssetsSorts().split(",");
            ArrayList<String> values = new ArrayList<String>();
            for (String s : assetsSortArr) {
                values.add(s.split(":")[0]);
            }
            String[] ans2 = values.toArray(new String[values.size()]);
            ofFixedAssetsPagination.setAssetsSorts(ans2);
        }
        if (this.ofFixedAssetsService.selectAssetsCount(ofFixedAssetsPagination) <= 0L) {
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6240\u9009\u8d44\u4ea7\u7c7b\u578b\u4e0d\u5b58\u5728\u53ef\u76d8\u8d44\u4ea7");
        }
        OfFixedAssetsOrderEntity entity = this.ofFixedAssetsOrderService.getInfo(id);
        if (entity != null) {
            OfFixedAssetsOrderEntity subentity = (OfFixedAssetsOrderEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsOrderUpForm, OfFixedAssetsOrderEntity.class);
            this.ofFixedAssetsOrderService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"updateEnd/{id}"})
    public ActionResult updateEnd(@PathVariable(value="id") String id) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        OfFixedAssetsOrderEntity entity = this.ofFixedAssetsOrderService.getInfo(id);
        if (entity != null) {
            this.ofFixedAssetsOrderService.updateByEnd(entity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        OfFixedAssetsOrderEntity entity = this.ofFixedAssetsOrderService.getInfo(id);
        if (entity != null) {
            this.ofFixedAssetsOrderService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u7edf\u8ba1\u76d8\u70b9\u8ba1\u5212\u603b\u6761\u6570")
    @GetMapping(value={"/countAssetsOrderNum/{menuId}/{companyId}/{isFixedAssets}"})
    public ActionResult countAssetsOrderNum(@PathVariable(value="menuId") String menuId, @PathVariable(value="companyId") String companyId, @PathVariable(value="isFixedAssets") String isFixedAssets) {
        ActionResult result = new ActionResult();
        OfFixedAssetsOrderPagination pagination = new OfFixedAssetsOrderPagination();
        pagination.setMenuId(menuId);
        pagination.setCompanyId(companyId);
        pagination.setAssetsSorts(isFixedAssets);
        Integer[] orderStates = new Integer[]{FixedAssetsOrderStateEnum.CHECK_NO_START.getState(), FixedAssetsOrderStateEnum.CHECK_ING.getState()};
        pagination.setOrderStates(orderStates);
        long assetsCount = this.ofFixedAssetsOrderService.selectAssetsOrderCount(pagination);
        result.setData((Object)assetsCount);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @ApiOperation(value="\u76d8\u70b9\u8ba1\u5212\u540d\u79f0\u5206\u9875\u9009\u62e9\u6846")
    @GetMapping(value={"/Selector"})
    public ActionResult<PageListVO<OfFixedAssetsOrderSelector>> selector(OfFixedAssetsOrderPagination pagination) {
        List<OfFixedAssetsOrderEntity> list = this.ofFixedAssetsOrderService.getList(pagination);
        List listSelector = JsonUtil.getJsonToList(list, OfFixedAssetsOrderSelector.class);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page((List)listSelector, (PaginationVO)paginationVO);
    }
}

