/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.assets.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.assets.entity.OfFixedAssetsEntity;
import com.bringspring.assets.entity.OfFixedAssetsLogsInventoryEntity;
import com.bringspring.assets.entity.OfFixedAssetsOrderEntity;
import com.bringspring.assets.entity.OfFixedAssetsOrderItemEntity;
import com.bringspring.assets.entity.OfFixedAssetsTypeEntity;
import com.bringspring.assets.model.ofFixedAssetsOrderItem.AssetsOrderItemData;
import com.bringspring.assets.model.ofFixedAssetsOrderItem.OfFixedAssetsOrderItemData;
import com.bringspring.assets.model.ofFixedAssetsOrderItem.OfFixedAssetsOrderItemInfoVO;
import com.bringspring.assets.model.ofFixedAssetsOrderItem.OfFixedAssetsOrderItemListVO;
import com.bringspring.assets.model.ofFixedAssetsOrderItem.OfFixedAssetsOrderItemPagination;
import com.bringspring.assets.model.ofFixedAssetsOrderItem.OfFixedAssetsOrderItemPaginationExportModel;
import com.bringspring.assets.model.ofFixedAssetsOrderItem.OfFixedAssetsOrderItemUpForm;
import com.bringspring.assets.service.OfFixedAssetsLogsInventoryService;
import com.bringspring.assets.service.OfFixedAssetsOrderItemService;
import com.bringspring.assets.service.OfFixedAssetsOrderService;
import com.bringspring.assets.service.OfFixedAssetsService;
import com.bringspring.assets.service.OfFixedAssetsTypeService;
import com.bringspring.assets.util.Constants;
import com.bringspring.assets.util.FixedAssetsOrderItemStateEnum;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.logistics.entity.BasSpaceEntity;
import com.bringspring.logistics.service.BasSpaceService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d44\u4ea7\u76d8\u70b9\u8ba1\u5212\u8bb0\u5f55\u8868"}, value="assets")
@RequestMapping(value={"/api/assets/OfFixedAssetsOrderItem"})
public class OfFixedAssetsOrderItemController {
    private static final Logger log = LoggerFactory.getLogger(OfFixedAssetsOrderItemController.class);
    @Autowired
    private OfFixedAssetsOrderItemService ofFixedAssetsOrderItemService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OfFixedAssetsLogsInventoryService ofFixedAssetsLogsInventoryService;
    @Autowired
    private OfFixedAssetsService ofFixedAssetsService;
    @Autowired
    private BasSpaceService basSpaceService;
    @Autowired
    private OfFixedAssetsOrderService ofFixedAssetsOrderService;
    @Autowired
    private OfFixedAssetsTypeService ofFixedAssetsTypeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;

    @PostMapping(value={"/getList"})
    public ActionResult getList(@RequestBody OfFixedAssetsOrderItemPagination ofFixedAssetsOrderItemPagination) {
        List<OfFixedAssetsOrderItemEntity> listPage = this.ofFixedAssetsOrderItemService.getListPage(ofFixedAssetsOrderItemPagination);
        List listVO = JsonUtil.getJsonToList(listPage, OfFixedAssetsOrderItemListVO.class);
        listVO.stream().forEach(vo -> {
            OrganizeEntity companyInfo;
            BasSpaceEntity spaceAct;
            BasSpaceEntity basSpace;
            String basSpaceId;
            UserEntity infoUser;
            OfFixedAssetsEntity assetsEntity;
            if (StringUtils.isNotBlank((CharSequence)vo.getFixedAssetsId()) && (assetsEntity = (OfFixedAssetsEntity)this.ofFixedAssetsService.getById((Serializable)((Object)vo.getFixedAssetsId()))) != null) {
                vo.setFixedAssetsName(assetsEntity.getName());
                vo.setEnableDate(assetsEntity.getEnableDate());
                vo.setModelNumber(assetsEntity.getModelNumber());
                vo.setQuantity(assetsEntity.getQuantity());
                vo.setUnit(assetsEntity.getUnit());
                vo.setLabelCase(assetsEntity.getLabelCase());
                vo.setIsCustomUser(assetsEntity.getIsCustomUser());
                vo.setIsFixedAssets(assetsEntity.getIsFixedAssets());
                vo.setInventoryWay(assetsEntity.getInventoryWay());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getFixedAssetsTypeId())) {
                vo.setFixedAssetsTypeDesc(((OfFixedAssetsTypeEntity)this.ofFixedAssetsTypeService.getById((Serializable)((Object)vo.getFixedAssetsTypeId()))).getName());
            }
            if (StringUtils.isNotEmpty((String)vo.getBaseUserId()) && ObjectUtil.isNotEmpty((Object)(infoUser = this.userService.getInfo(vo.getBaseUserId())))) {
                vo.setBaseUserName(infoUser.getRealName());
                if (StringUtils.isNotEmpty((String)infoUser.getOrganizeId())) {
                    vo.setBaseOrganizeName(this.baseDataUtil.comSelectValue(infoUser.getOrganizeId(), ""));
                }
            }
            if (StringUtils.isNotEmpty((String)(basSpaceId = vo.getBasSpaceId())) && ObjectUtil.isNotEmpty((Object)(basSpace = (BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)basSpaceId))))) {
                vo.setBasSpaceName(basSpace.getSpaceName());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getBasSpaceIdAct()) && ObjectUtil.isNotEmpty((Object)(spaceAct = (BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)vo.getBasSpaceIdAct()))))) {
                vo.setBasSpaceIdActName(spaceAct.getSpaceName());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getFixedAssetsOrderId())) {
                OfFixedAssetsOrderEntity assetsOrder = (OfFixedAssetsOrderEntity)this.ofFixedAssetsOrderService.getById((Serializable)((Object)vo.getFixedAssetsOrderId()));
                vo.setFixedAssetsOrderName(assetsOrder != null ? assetsOrder.getOrderName() : null);
                vo.setFixedAssetsOrderCode(assetsOrder != null ? assetsOrder.getOrderCode() : null);
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getCompanyId()) && !ObjectUtil.isEmpty((Object)(companyInfo = this.organizeService.getInfo(vo.getCompanyId())))) {
                vo.setCompanyName(companyInfo.getFullName());
            }
        });
        PageListVO vo2 = new PageListVO();
        vo2.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ofFixedAssetsOrderItemPagination), PaginationVO.class);
        vo2.setPagination(page);
        return ActionResult.success((Object)vo2);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OfFixedAssetsOrderItemInfoVO> detailInfo(@PathVariable(value="id") String id) {
        UserEntity infoUser;
        BasSpaceEntity basSpace;
        String basSpaceId;
        OfFixedAssetsOrderItemEntity entity = this.ofFixedAssetsOrderItemService.getInfo(id);
        OfFixedAssetsOrderItemInfoVO vo = (OfFixedAssetsOrderItemInfoVO)JsonUtil.getJsonToBean((Object)entity, OfFixedAssetsOrderItemInfoVO.class);
        vo.setFixedAssetsStateName(FixedAssetsOrderItemStateEnum.getDescByState(vo.getFixedAssetsState()));
        vo.setCreatorTimeFormat(ObjectUtil.isNull((Object)vo.getCreatorTime()) ? null : DateUtil.dateFormat((Date)vo.getCreatorTime()));
        vo.setCreatorUser(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        vo.setLastModifyTimeFormat(ObjectUtil.isNull((Object)vo.getLastModifyTime()) ? null : DateUtil.dateFormat((Date)vo.getLastModifyTime()));
        vo.setLastModifyUser(this.baseDataUtil.userSelectValueNoAccount(vo.getLastModifyUserId()));
        if (StrUtil.isNotBlank((CharSequence)vo.getFixedAssetsOrderId())) {
            OfFixedAssetsOrderEntity assetsOrder = (OfFixedAssetsOrderEntity)this.ofFixedAssetsOrderService.getById((Serializable)((Object)vo.getFixedAssetsOrderId()));
            vo.setFixedAssetsOrderName(assetsOrder != null ? assetsOrder.getOrderName() : null);
            vo.setFixedAssetsOrderCode(assetsOrder != null ? assetsOrder.getOrderCode() : null);
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getFixedAssetsId())) {
            vo.setFixedAssetsName(((OfFixedAssetsEntity)this.ofFixedAssetsService.getById((Serializable)((Object)vo.getFixedAssetsId()))).getName());
        }
        if (StringUtils.isNotEmpty((String)(basSpaceId = vo.getBasSpaceId())) && ObjectUtil.isNotEmpty((Object)(basSpace = (BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)basSpaceId))))) {
            vo.setBasSpaceName(basSpace.getSpaceName());
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getFixedAssetsTypeId())) {
            vo.setFixedAssetsTypeDesc(((OfFixedAssetsTypeEntity)this.ofFixedAssetsTypeService.getById((Serializable)((Object)vo.getFixedAssetsTypeId()))).getName());
        }
        if (StringUtils.isNotEmpty((String)vo.getBaseUserId()) && ObjectUtil.isNotEmpty((Object)(infoUser = this.userService.getInfo(vo.getBaseUserId())))) {
            vo.setBaseUserName(infoUser.getRealName());
            if (StringUtils.isNotEmpty((String)infoUser.getOrganizeId())) {
                vo.setBaseOrganizeName(this.baseDataUtil.comSelectValue(infoUser.getOrganizeId(), ""));
            }
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getBaseUserId())) {
            vo.setBaseUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getBaseUserId()));
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getReportId())) {
            vo.setReportName(this.baseDataUtil.userSelectValueNoAccount(vo.getReportId()));
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getBasSpaceIdAct())) {
            vo.setBasSpaceIdActName(((BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)vo.getBasSpaceIdAct()))).getSpaceName());
        }
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getListAll"})
    public ActionResult getListAll(@RequestBody OfFixedAssetsOrderItemPagination ofFixedAssetsOrderItemPagination) {
        List<OfFixedAssetsOrderItemEntity> listAll = this.ofFixedAssetsOrderItemService.getListAll(ofFixedAssetsOrderItemPagination);
        List listVO = JsonUtil.getJsonToList(listAll, OfFixedAssetsOrderItemListVO.class);
        listVO.stream().forEach(entity -> {
            BasSpaceEntity basSpace;
            if (StrUtil.isNotBlank((CharSequence)entity.getFixedAssetsId())) {
                entity.setFixedAssetsName(((OfFixedAssetsEntity)this.ofFixedAssetsService.getById((Serializable)((Object)entity.getFixedAssetsId()))).getName());
            }
            if (StrUtil.isNotBlank((CharSequence)entity.getFixedAssetsTypeId())) {
                entity.setFixedAssetsTypeDesc(((OfFixedAssetsTypeEntity)this.ofFixedAssetsTypeService.getById((Serializable)((Object)entity.getFixedAssetsTypeId()))).getName());
            }
            entity.setBaseUserName(StrUtil.isBlank((CharSequence)entity.getBaseUserId()) ? "" : this.baseDataUtil.userSelectValueNoAccount(entity.getBaseUserId()));
            String basSpaceId = entity.getBasSpaceId();
            if (StringUtils.isNotEmpty((String)basSpaceId) && ObjectUtil.isNotEmpty((Object)(basSpace = (BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)basSpaceId))))) {
                entity.setBasSpaceName(basSpace.getSpaceName());
            }
            entity.setBasSpaceIdActName(StrUtil.isBlank((CharSequence)entity.getBasSpaceIdAct()) ? "" : ((BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)entity.getBasSpaceIdAct()))).getSpaceName());
            OfFixedAssetsOrderEntity assetsOrder = (OfFixedAssetsOrderEntity)this.ofFixedAssetsOrderService.getById((Serializable)((Object)entity.getFixedAssetsOrderId()));
            entity.setFixedAssetsOrderName(assetsOrder != null ? assetsOrder.getOrderName() : null);
        });
        return ActionResult.success((Object)listVO);
    }

    @PostMapping(value={"/queryListAll"})
    public ActionResult queryListAll(@RequestBody OfFixedAssetsOrderItemPagination ofFixedAssetsOrderItemPagination) {
        List<OfFixedAssetsOrderItemEntity> listAll = this.ofFixedAssetsOrderItemService.queryListAll(ofFixedAssetsOrderItemPagination);
        List listVO = JsonUtil.getJsonToList(listAll, OfFixedAssetsOrderItemListVO.class);
        listVO.removeIf(r -> StringUtils.isEmpty((String)r.getRfidCode()));
        listVO.stream().forEach(vo -> {
            BasSpaceEntity basSpace;
            OfFixedAssetsOrderEntity assetsOrder = (OfFixedAssetsOrderEntity)this.ofFixedAssetsOrderService.getById((Serializable)((Object)vo.getFixedAssetsOrderId()));
            vo.setFixedAssetsOrderName(assetsOrder != null ? assetsOrder.getOrderName() : null);
            if (StrUtil.isNotBlank((CharSequence)vo.getFixedAssetsId())) {
                vo.setFixedAssetsName(((OfFixedAssetsEntity)this.ofFixedAssetsService.getById((Serializable)((Object)vo.getFixedAssetsId()))).getName());
            }
            if (StrUtil.isNotBlank((CharSequence)vo.getFixedAssetsTypeId())) {
                vo.setFixedAssetsTypeDesc(((OfFixedAssetsTypeEntity)this.ofFixedAssetsTypeService.getById((Serializable)((Object)vo.getFixedAssetsTypeId()))).getName());
            }
            vo.setFixedAssetsStateName(FixedAssetsOrderItemStateEnum.getDescByState(vo.getFixedAssetsState()));
            String basSpaceId = vo.getBasSpaceId();
            if (StringUtils.isNotEmpty((String)basSpaceId) && ObjectUtil.isNotEmpty((Object)(basSpace = (BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)basSpaceId))))) {
                vo.setBasSpaceName(basSpace.getSpaceName());
            }
            vo.setBasSpaceIdActName(StrUtil.isBlank((CharSequence)vo.getBasSpaceIdAct()) ? "" : ((BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)vo.getBasSpaceIdAct()))).getSpaceName());
        });
        return ActionResult.success((Object)listVO);
    }

    @PostMapping(value={"/uploadInventoryResult"})
    public ActionResult uploadInventoryResult(@RequestBody AssetsOrderItemData parameters) {
        if (ObjectUtil.isEmpty((Object)parameters)) {
            return ActionResult.fail((String)"\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)parameters.getOrderId())) {
            return ActionResult.fail((String)"\u76d8\u70b9\u8ba1\u5212id\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty(parameters.getList())) {
            return ActionResult.fail((String)"\u76d8\u70b9\u8d44\u4ea7\u660e\u7ec6\u5217\u8868\u4e0d\u53ef\u4e3a\u7a7a");
        }
        this.ofFixedAssetsOrderItemService.rfidResultUpload(parameters.getOrderId(), parameters.getList());
        return ActionResult.success((String)"\u79bb\u7ebf\u4e0a\u4f20\u6210\u529f");
    }

    @PostMapping(value={"/rfidMakeAnInventory"})
    public ActionResult rfidMakeAnInventory(@RequestBody OfFixedAssetsOrderItemPagination ofFixedAssetsOrderItemPagination) {
        String fixedAssetsOrderId = ofFixedAssetsOrderItemPagination.getFixedAssetsOrderId();
        String basSpaceId = ofFixedAssetsOrderItemPagination.getBasSpaceId();
        String[] rfidCodes = ofFixedAssetsOrderItemPagination.getRfidCodes();
        if (StringUtils.isEmpty((String)fixedAssetsOrderId)) {
            return ActionResult.fail((String)"\u76d8\u70b9\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)basSpaceId)) {
            return ActionResult.fail((String)"\u76d8\u70b9\u7a7a\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)rfidCodes) || rfidCodes.length < 0) {
            return ActionResult.fail((String)"RFID\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String s = this.ofFixedAssetsOrderItemService.updateMakeAnInventoryByRfid(fixedAssetsOrderId, basSpaceId, rfidCodes);
        if (StringUtils.isEmpty((String)s)) {
            return ActionResult.success((String)"\u76d8\u70b9\u6210\u529f");
        }
        return ActionResult.fail((String)s);
    }

    @PostMapping(value={"/makeAnInventory"})
    public ActionResult makeAnInventory(@RequestBody OfFixedAssetsOrderItemPagination ofFixedAssetsOrderItemPagination) {
        OfFixedAssetsOrderItemEntity entity;
        String fixedAssetsOrderId = ofFixedAssetsOrderItemPagination.getFixedAssetsOrderId();
        String code = ofFixedAssetsOrderItemPagination.getCode();
        String rfidCode = ofFixedAssetsOrderItemPagination.getRfidCode();
        String basSpaceId = ofFixedAssetsOrderItemPagination.getBasSpaceId();
        if (StringUtils.isEmpty((String)fixedAssetsOrderId)) {
            return ActionResult.fail((String)"\u76d8\u70b9\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)code) && StringUtils.isEmpty((String)rfidCode)) {
            return ActionResult.fail((String)"\u8d44\u4ea7\u7f16\u7801\u6216RFID\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)basSpaceId)) {
            return ActionResult.fail((String)"\u76d8\u70b9\u7a7a\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getFixedAssetsOrderId, (Object)fixedAssetsOrderId);
        if (StringUtils.isNotEmpty((String)code)) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getCode, (Object)code);
        }
        if (StringUtils.isNotEmpty((String)rfidCode)) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getRfidCode, (Object)rfidCode);
        }
        if (ObjectUtil.isEmpty((Object)(entity = (OfFixedAssetsOrderItemEntity)this.ofFixedAssetsOrderItemService.getOne((Wrapper)queryWrapper)))) {
            return ActionResult.fail((Integer)201, (String)"\u76d8\u70b9\u660e\u7ec6\u4e0d\u5b58\u5728\u8be5\u8d44\u4ea7");
        }
        Integer fixedAssetsState = entity.getFixedAssetsState();
        if (FixedAssetsOrderItemStateEnum.NOT_CHECK.getState().equals(fixedAssetsState) || FixedAssetsOrderItemStateEnum.CHECK_LOSS.getState().equals(fixedAssetsState)) {
            String spaceName = ((BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)basSpaceId))).getSpaceName();
            if (basSpaceId.equals(entity.getBasSpaceId())) {
                entity.setFixedAssetsState(FixedAssetsOrderItemStateEnum.CHECK_NORMAL.getState());
                boolean b = this.ofFixedAssetsOrderItemService.updateMakeAnInventory(entity, spaceName);
                if (b) {
                    return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f! \u76d8\u70b9\u7ed3\u679c\u4e3a'\u6b63\u5e38'", (Object)this.getForeigninfo(entity));
                }
                return ActionResult.fail((String)"\u64cd\u4f5c\u5931\u8d25,\u76d8\u70b9\u66f4\u65b0\u5931\u8d25");
            }
            entity.setFixedAssetsState(FixedAssetsOrderItemStateEnum.CHECK_CHANGE.getState());
            entity.setBasSpaceIdAct(basSpaceId);
            boolean b = this.ofFixedAssetsOrderItemService.updateMakeAnInventory(entity, spaceName);
            if (b) {
                return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f! \u76d8\u70b9\u7ed3\u679c\u4e3a'\u4f4d\u7f6e\u4e0d\u7b26'", (Object)this.getForeigninfo(entity));
            }
            return ActionResult.fail((String)"\u64cd\u4f5c\u5931\u8d25,\u76d8\u70b9\u66f4\u65b0\u5931\u8d25");
        }
        return ActionResult.success((String)"\u76d8\u70b9\u8fc7\u7684\u8d44\u4ea7", (Object)this.getForeigninfo(entity));
    }

    @PostMapping(value={"/completeInSpace"})
    public ActionResult makeAnInventoryCompleteInSpace(@RequestBody OfFixedAssetsOrderItemPagination ofFixedAssetsOrderItemPagination) {
        List<OfFixedAssetsOrderItemEntity> listAll;
        BasSpaceEntity basSpace;
        String fixedAssetsOrderId = ofFixedAssetsOrderItemPagination.getFixedAssetsOrderId();
        String basSpaceId = ofFixedAssetsOrderItemPagination.getBasSpaceId();
        if (StringUtils.isEmpty((String)fixedAssetsOrderId)) {
            return ActionResult.fail((String)"\u76d8\u70b9\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)basSpaceId)) {
            return ActionResult.fail((String)"\u76d8\u70b9\u7a7a\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer[] states = new Integer[]{FixedAssetsOrderItemStateEnum.NOT_CHECK.getState(), FixedAssetsOrderItemStateEnum.CHECK_ADD.getState()};
        ofFixedAssetsOrderItemPagination.setFixedAssetsStates(states);
        String spaceName = null;
        if (StringUtils.isNotEmpty((String)basSpaceId) && ObjectUtil.isNotEmpty((Object)(basSpace = (BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)basSpaceId))))) {
            spaceName = basSpace.getSpaceName();
            ofFixedAssetsOrderItemPagination.setBasSpaceName(spaceName);
        }
        if ((listAll = this.ofFixedAssetsOrderItemService.getEntityList(ofFixedAssetsOrderItemPagination)) != null && listAll.size() > 0) {
            this.ofFixedAssetsOrderItemService.updateInventoryLosses(listAll, ofFixedAssetsOrderItemPagination);
            return ActionResult.success((String)(spaceName + "\u76d8\u70b9\u7ed3\u675f.\u76d8\u4e8f\u8d44\u4ea7\u6570\u91cf" + listAll.size()));
        }
        return ActionResult.success((String)(spaceName + "\u76d8\u70b9\u7ed3\u675f."));
    }

    public OfFixedAssetsOrderItemListVO getForeigninfo(OfFixedAssetsOrderItemEntity entity) {
        BasSpaceEntity basSpace;
        OfFixedAssetsOrderItemListVO infoVO = (OfFixedAssetsOrderItemListVO)JsonUtil.getJsonToBean((Object)entity, OfFixedAssetsOrderItemListVO.class);
        if (StrUtil.isNotBlank((CharSequence)entity.getFixedAssetsId())) {
            infoVO.setFixedAssetsName(((OfFixedAssetsEntity)this.ofFixedAssetsService.getById((Serializable)((Object)entity.getFixedAssetsId()))).getName());
        }
        if (StrUtil.isNotBlank((CharSequence)entity.getFixedAssetsTypeId())) {
            infoVO.setFixedAssetsTypeDesc(((OfFixedAssetsTypeEntity)this.ofFixedAssetsTypeService.getById((Serializable)((Object)entity.getFixedAssetsTypeId()))).getName());
        }
        infoVO.setFixedAssetsId(((OfFixedAssetsEntity)this.ofFixedAssetsService.getById((Serializable)((Object)entity.getFixedAssetsId()))).getName());
        String basSpaceId = infoVO.getBasSpaceId();
        if (StringUtils.isNotEmpty((String)basSpaceId) && ObjectUtil.isNotEmpty((Object)(basSpace = (BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)basSpaceId))))) {
            infoVO.setBasSpaceName(basSpace.getSpaceName());
        }
        infoVO.setBasSpaceIdActName(StrUtil.isBlank((CharSequence)entity.getBasSpaceIdAct()) ? "" : ((BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)entity.getBasSpaceIdAct()))).getSpaceName());
        OfFixedAssetsOrderEntity assetsOrder = (OfFixedAssetsOrderEntity)this.ofFixedAssetsOrderService.getById((Serializable)((Object)entity.getFixedAssetsOrderId()));
        infoVO.setFixedAssetsOrderName(assetsOrder != null ? assetsOrder.getOrderName() : null);
        return infoVO;
    }

    @PutMapping(value={"/updateDispose/{way}/{id}"})
    public ActionResult updateDispose(@PathVariable(value="way") String way, @PathVariable(value="id") String id, @RequestBody @Valid OfFixedAssetsOrderItemUpForm ofFixedAssetsOrderItemUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u63d0\u4ea4\u5931\u8d25");
        }
        OfFixedAssetsOrderItemEntity entity = (OfFixedAssetsOrderItemEntity)this.ofFixedAssetsOrderItemService.getById((Serializable)((Object)id));
        if (entity != null) {
            OfFixedAssetsOrderItemEntity subentity = (OfFixedAssetsOrderItemEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsOrderItemUpForm, OfFixedAssetsOrderItemEntity.class);
            this.ofFixedAssetsOrderItemService.updateDispose(way, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/disposeBatch/{ids}"})
    public ActionResult disposeBatch(@PathVariable(value="ids") String[] ids, @RequestBody @Valid OfFixedAssetsOrderItemData data) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)ids)) {
            return ActionResult.fail((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e");
        }
        try {
            this.ofFixedAssetsOrderItemService.updateDisposeBatch(ids, data);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25");
        }
    }

    @PutMapping(value={"/inventoryBatch/{ids}"})
    public ActionResult inventoryBatch(@PathVariable(value="ids") String[] ids, @RequestBody @Valid OfFixedAssetsOrderItemData data) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)ids)) {
            return ActionResult.fail((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e");
        }
        try {
            this.ofFixedAssetsOrderItemService.updateInventoryBatch(ids, data);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25");
        }
    }

    @PutMapping(value={"/{id}/{state}"})
    public ActionResult updateState(@PathVariable(value="id") String id, @PathVariable(value="state") Integer state) {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u5165\u5e93\u5931\u8d25");
        }
        OfFixedAssetsOrderItemEntity entity = (OfFixedAssetsOrderItemEntity)this.ofFixedAssetsOrderItemService.getById((Serializable)((Object)id));
        if (entity != null) {
            entity.setFixedAssetsState(state);
            this.ofFixedAssetsOrderItemService.updateStateFromPC(id, entity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u5f85\u76d8\u8d44\u4ea7\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"/getListByAssetsId/{assetsId}"})
    public ActionResult getListByAssetsId(@PathVariable(value="assetsId") String assetsId) {
        List<OfFixedAssetsOrderItemListVO> listByAssetsId = this.ofFixedAssetsOrderItemService.getListByAssetsId(assetsId);
        return ActionResult.success(listByAssetsId);
    }

    @GetMapping(value={"/getSpacesByOrderId/{assetsId}"})
    public ActionResult getSpacesByOrderId(@PathVariable(value="assetsId") String assetsId) {
        List<Map<String, Object>> list = this.ofFixedAssetsOrderItemService.getSpacesByOrderId(assetsId);
        return ActionResult.success(list);
    }

    @GetMapping(value={"/countByState/{fixedAssetsOrderId}/{fixedAssetsState}"})
    public ActionResult countByState(@PathVariable(value="fixedAssetsOrderId") @Valid String fixedAssetsOrderId, @PathVariable(value="fixedAssetsState") @Valid Integer fixedAssetsState) throws IOException {
        long num = this.ofFixedAssetsOrderItemService.countByState(fixedAssetsOrderId, fixedAssetsState);
        return ActionResult.success((String)"\u76d8\u70b9\u72b6\u6001\u6570\u91cf\u83b7\u53d6\u6210\u529f", (Object)num);
    }

    @PutMapping(value={"/selfInventoryNotification/{ids}"})
    public ActionResult selfInventoryNotification(@PathVariable(value="ids") String[] ids) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u53d1\u9001\u5931\u8d25");
        }
        try {
            this.ofFixedAssetsOrderItemService.selfInventoryNotification(ids, userInfo);
            return ActionResult.success((String)"\u53d1\u9001\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = "\u53d1\u9001\u5931\u8d25\uff1a" + e.getMessage();
            log.error(message);
            return ActionResult.fail((String)message);
        }
    }

    @PutMapping(value={"/selfInventoryInfo/{id}"})
    public ActionResult saveSelfInventory(@PathVariable(value="id") String id, @RequestBody @Valid OfFixedAssetsOrderItemUpForm ofFixedAssetsOrderItemUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u63d0\u4ea4\u5931\u8d25");
        }
        if (ObjectUtil.isEmpty((Object)ofFixedAssetsOrderItemUpForm.getFixedAssetsState())) {
            return ActionResult.fail((String)"\u81ea\u76d8\u72b6\u6001\u4e0d\u53ef\u4e3a\u7a7a");
        }
        OfFixedAssetsOrderItemEntity entity = (OfFixedAssetsOrderItemEntity)this.ofFixedAssetsOrderItemService.getById((Serializable)((Object)id));
        if (entity != null) {
            this.ofFixedAssetsOrderItemService.saveSelfInventoryAffirmInfo(id, entity, ofFixedAssetsOrderItemUpForm);
            return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f");
        }
        return ActionResult.fail((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OfFixedAssetsOrderItemPaginationExportModel exportModel) throws IOException {
        if (StringUtils.isEmpty((String)exportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OfFixedAssetsOrderItemPagination pagination = (OfFixedAssetsOrderItemPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)exportModel), OfFixedAssetsOrderItemPagination.class));
        List<OfFixedAssetsOrderItemEntity> list = this.ofFixedAssetsOrderItemService.getTypeList(pagination, exportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, OfFixedAssetsOrderItemListVO.class);
        for (OfFixedAssetsOrderItemListVO vo : listVO) {
            OrganizeEntity companyInfo;
            BasSpaceEntity spaceAct;
            BasSpaceEntity basSpace;
            String basSpaceId;
            UserEntity infoUser;
            OfFixedAssetsEntity assetsEntity;
            QueryWrapper logsQueryWrapper = new QueryWrapper();
            logsQueryWrapper.lambda().eq(OfFixedAssetsLogsInventoryEntity::getItemId, (Object)vo.getId());
            logsQueryWrapper.lambda().orderByDesc(OfFixedAssetsLogsInventoryEntity::getInventoryTime);
            logsQueryWrapper.last("limit 1");
            OfFixedAssetsLogsInventoryEntity logs = (OfFixedAssetsLogsInventoryEntity)this.ofFixedAssetsLogsInventoryService.getOne((Wrapper)logsQueryWrapper);
            if (ObjectUtil.isNotEmpty((Object)logs) && StringUtils.isNotEmpty((String)logs.getWay())) {
                vo.setWay(this.baseDataUtil.getDictName(logs.getWay(), Constants.INVENTORY_WAY));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getFixedAssetsId()) && (assetsEntity = (OfFixedAssetsEntity)this.ofFixedAssetsService.getById((Serializable)((Object)vo.getFixedAssetsId()))) != null) {
                vo.setFixedAssetsName(assetsEntity.getName());
                if (ObjectUtil.isNotEmpty((Object)assetsEntity.getEnableDate())) {
                    vo.setEnableDateStr(DateUtil.daFormat((Date)assetsEntity.getEnableDate()));
                }
                vo.setModelNumber(assetsEntity.getModelNumber());
                vo.setUnitPrice(assetsEntity.getUnitPrice());
                if (StringUtils.isNotBlank((CharSequence)assetsEntity.getEnabledMark())) {
                    vo.setAssetsEnabledMark(this.baseDataUtil.getDictName(assetsEntity.getEnabledMark(), Constants.DICTIONARY_TYPE));
                }
                vo.setQuantity(assetsEntity.getQuantity());
                vo.setUnit(assetsEntity.getUnit());
                vo.setLabelCase(assetsEntity.getLabelCase());
                vo.setIsCustomUser(assetsEntity.getIsCustomUser());
                if (StringUtils.isNotBlank((CharSequence)assetsEntity.getIsFixedAssets())) {
                    vo.setIsFixedAssets(this.baseDataUtil.getDictName(assetsEntity.getIsFixedAssets(), Constants.DICTIONARY_SORT));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getFixedAssetsTypeId())) {
                vo.setFixedAssetsTypeDesc(((OfFixedAssetsTypeEntity)this.ofFixedAssetsTypeService.getById((Serializable)((Object)vo.getFixedAssetsTypeId()))).getName());
            }
            if (StringUtils.isNotEmpty((String)vo.getBaseUserId()) && ObjectUtil.isNotEmpty((Object)(infoUser = this.userService.getInfo(vo.getBaseUserId())))) {
                vo.setBaseUserName(infoUser.getRealName());
                if (StringUtils.isNotEmpty((String)infoUser.getOrganizeId())) {
                    vo.setBaseOrganizeName(this.baseDataUtil.comSelectValue(infoUser.getOrganizeId(), ""));
                }
            }
            if (StringUtils.isNotEmpty((String)(basSpaceId = vo.getBasSpaceId())) && ObjectUtil.isNotEmpty((Object)(basSpace = (BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)basSpaceId))))) {
                vo.setBasSpaceName(basSpace.getSpaceName());
            }
            vo.setFixedAssetsStateName(FixedAssetsOrderItemStateEnum.getDescByState(vo.getFixedAssetsState()));
            if (StringUtils.isNotBlank((CharSequence)vo.getBasSpaceIdAct()) && ObjectUtil.isNotEmpty((Object)(spaceAct = (BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)vo.getBasSpaceIdAct()))))) {
                vo.setBasSpaceIdActName(spaceAct.getSpaceName());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getFixedAssetsOrderId())) {
                OfFixedAssetsOrderEntity assetsOrder = (OfFixedAssetsOrderEntity)this.ofFixedAssetsOrderService.getById((Serializable)((Object)vo.getFixedAssetsOrderId()));
                vo.setFixedAssetsOrderName(assetsOrder != null ? assetsOrder.getOrderName() : null);
                vo.setFixedAssetsOrderCode(assetsOrder != null ? assetsOrder.getOrderCode() : null);
            }
            if (!StringUtils.isNotBlank((CharSequence)vo.getCompanyId()) || ObjectUtil.isEmpty((Object)(companyInfo = this.organizeService.getInfo(vo.getCompanyId())))) continue;
            vo.setCompanyName(companyInfo.getFullName());
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)exportModel.getSelectKey()) ? exportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block48: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "code": {
                        entitys.add(new ExcelExportEntity("\u8d44\u4ea7\u7f16\u7801", (Object)"code"));
                        continue block48;
                    }
                    case "fixedAssetsName": {
                        entitys.add(new ExcelExportEntity("\u8d44\u4ea7\u540d\u79f0", (Object)"fixedAssetsName"));
                        continue block48;
                    }
                    case "modelNumber": {
                        entitys.add(new ExcelExportEntity("\u54c1\u724c\u578b\u53f7", (Object)"modelNumber"));
                        continue block48;
                    }
                    case "enableDate": {
                        entitys.add(new ExcelExportEntity("\u542f\u7528\u65e5\u671f", (Object)"enableDateStr"));
                        continue block48;
                    }
                    case "fixedAssetsTypeDesc": {
                        entitys.add(new ExcelExportEntity("\u8d44\u4ea7\u5206\u7c7b", (Object)"fixedAssetsTypeDesc"));
                        continue block48;
                    }
                    case "isFixedAssets": {
                        entitys.add(new ExcelExportEntity("\u53f0\u8d26\u5206\u7c7b", (Object)"isFixedAssets"));
                        continue block48;
                    }
                    case "quantity": {
                        entitys.add(new ExcelExportEntity("\u6570\u91cf", (Object)"quantity"));
                        continue block48;
                    }
                    case "unit": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u91cf\u5355\u4f4d", (Object)"unit"));
                        continue block48;
                    }
                    case "baseUserName": {
                        entitys.add(new ExcelExportEntity("\u9886/\u501f\u7528\u4eba", (Object)"baseUserName"));
                        continue block48;
                    }
                    case "baseOrganizeName": {
                        entitys.add(new ExcelExportEntity("\u9886/\u501f\u7528\u4eba\u90e8\u95e8", (Object)"baseOrganizeName"));
                        continue block48;
                    }
                    case "unitPrice": {
                        entitys.add(new ExcelExportEntity("\u5355\u4ef7(\u5143)", (Object)"unitPrice"));
                        continue block48;
                    }
                    case "assetsEnabledMark": {
                        entitys.add(new ExcelExportEntity("\u8d44\u4ea7\u72b6\u6001", (Object)"assetsEnabledMark"));
                        continue block48;
                    }
                    case "rfidDecode": {
                        entitys.add(new ExcelExportEntity("RFID\u7f16\u7801", (Object)"rfidDecode"));
                        continue block48;
                    }
                    case "labelCase": {
                        entitys.add(new ExcelExportEntity("\u6807\u7b7e\u60c5\u51b5", (Object)"labelCase"));
                        continue block48;
                    }
                    case "fixedAssetsStateName": {
                        entitys.add(new ExcelExportEntity("\u76d8\u70b9\u72b6\u6001", (Object)"fixedAssetsStateName"));
                        continue block48;
                    }
                    case "basSpaceName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u7a7a\u95f4", (Object)"basSpaceName"));
                        continue block48;
                    }
                    case "basSpaceIdActName": {
                        entitys.add(new ExcelExportEntity("\u76d8\u70b9\u7a7a\u95f4", (Object)"basSpaceIdActName"));
                        continue block48;
                    }
                    case "way": {
                        entitys.add(new ExcelExportEntity("\u76d8\u70b9\u65b9\u5f0f", (Object)"way"));
                        continue block48;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u56fa\u5b9a\u8d44\u4ea7\u76d8\u70b9\u6e05\u5355\u8868");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u56fa\u5b9a\u8d44\u4ea7\u76d8\u70b9\u6e05\u5355\u8868" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

