/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.assets.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.assets.entity.OfFixedAssetsRepairEntity;
import com.bringspring.assets.model.offixedassetsrepair.OfFixedAssetsRepairCrForm;
import com.bringspring.assets.model.offixedassetsrepair.OfFixedAssetsRepairInfoVO;
import com.bringspring.assets.model.offixedassetsrepair.OfFixedAssetsRepairListVO;
import com.bringspring.assets.model.offixedassetsrepair.OfFixedAssetsRepairPagination;
import com.bringspring.assets.model.offixedassetsrepair.OfFixedAssetsRepairPaginationExportModel;
import com.bringspring.assets.model.offixedassetsrepair.OfFixedAssetsRepairUpForm;
import com.bringspring.assets.service.OfFixedAssetsRepairService;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u56fa\u5b9a\u8d44\u4ea7\u62a5\u4fee\u4e1a\u52a1"}, value="assets")
@RequestMapping(value={"/api/assets/OfFixedAssetsRepair"})
public class OfFixedAssetsRepairController {
    private static final Logger log = LoggerFactory.getLogger(OfFixedAssetsRepairController.class);
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OfFixedAssetsRepairService ofFixedAssetsRepairService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OfFixedAssetsRepairPagination ofFixedAssetsRepairPagination) throws IOException {
        List<OfFixedAssetsRepairEntity> list = this.ofFixedAssetsRepairService.getList(ofFixedAssetsRepairPagination);
        List listVO = JsonUtil.getJsonToList(list, OfFixedAssetsRepairListVO.class);
        for (OfFixedAssetsRepairListVO vo : listVO) {
            if (StrUtil.isNotBlank((CharSequence)vo.getReportUserId())) {
                vo.setReportUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getReportUserId()));
            }
            vo.setPictures(this.baseDataUtil.getFileNameInJson(vo.getPictures()));
            vo.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
            vo.setLastModifyUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getLastModifyUserId()));
            vo.setCompanyName(this.baseDataUtil.comSelectValue(vo.getCompanyId(), "last"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ofFixedAssetsRepairPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid OfFixedAssetsRepairCrForm ofFixedAssetsRepairCrForm) throws DataException {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u521b\u5efa\u5931\u8d25");
        }
        OfFixedAssetsRepairEntity entity = (OfFixedAssetsRepairEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsRepairCrForm, OfFixedAssetsRepairEntity.class);
        this.ofFixedAssetsRepairService.create(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OfFixedAssetsRepairPaginationExportModel paginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)paginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OfFixedAssetsRepairPagination pagination = (OfFixedAssetsRepairPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)paginationExportModel), OfFixedAssetsRepairPagination.class));
        List<OfFixedAssetsRepairEntity> list = this.ofFixedAssetsRepairService.getTypeList(pagination, paginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, OfFixedAssetsRepairListVO.class);
        for (OfFixedAssetsRepairListVO VO : listVO) {
            VO.setReportUserId(this.baseDataUtil.userSelectValues(VO.getReportUserId()));
            VO.setPictures(this.baseDataUtil.getFileNameInJson(VO.getPictures()));
            VO.setCreatorUserId(this.baseDataUtil.userSelectValue(VO.getCreatorUserId()));
            VO.setLastModifyUserId(this.baseDataUtil.userSelectValue(VO.getLastModifyUserId()));
            VO.setCompanyId(this.baseDataUtil.comSelectValue(VO.getCompanyId(), "last"));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)paginationExportModel.getSelectKey()) ? paginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block48: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "assetsId": {
                        entitys.add(new ExcelExportEntity("\u8d44\u4ea7\u53f0\u8d26", (Object)"assetsId"));
                        continue block48;
                    }
                    case "businessCode": {
                        entitys.add(new ExcelExportEntity("\u4e1a\u52a1\u7f16\u53f7", (Object)"businessCode"));
                        continue block48;
                    }
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u4e1a\u52a1\u540d\u79f0", (Object)"name"));
                        continue block48;
                    }
                    case "status": {
                        entitys.add(new ExcelExportEntity("\u529e\u7406\u72b6\u6001", (Object)"status"));
                        continue block48;
                    }
                    case "repairStatus": {
                        entitys.add(new ExcelExportEntity("\u7ef4\u4fee\u72b6\u6001", (Object)"repairStatus"));
                        continue block48;
                    }
                    case "type": {
                        entitys.add(new ExcelExportEntity("\u62a5\u4fee\u7c7b\u578b", (Object)"type"));
                        continue block48;
                    }
                    case "planFinishDate": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u5212\u5b8c\u6210\u65e5\u671f", (Object)"planFinishDate"));
                        continue block48;
                    }
                    case "actualFinishDate": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u9645\u5b8c\u6210\u65e5\u671f", (Object)"actualFinishDate"));
                        continue block48;
                    }
                    case "content": {
                        entitys.add(new ExcelExportEntity("\u62a5\u4fee\u5185\u5bb9", (Object)"content"));
                        continue block48;
                    }
                    case "reportUserId": {
                        entitys.add(new ExcelExportEntity("\u62a5\u4fee\u4eba", (Object)"reportUserId"));
                        continue block48;
                    }
                    case "pictures": {
                        entitys.add(new ExcelExportEntity("\u7269\u54c1\u56fe\u7247", (Object)"pictures"));
                        continue block48;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"description"));
                        continue block48;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block48;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block48;
                    }
                    case "lastModifyUserId": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u7528\u6237", (Object)"lastModifyUserId"));
                        continue block48;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u65f6\u95f4", (Object)"lastModifyTime"));
                        continue block48;
                    }
                    case "companyId": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyId"));
                        continue block48;
                    }
                    case "version": {
                        entitys.add(new ExcelExportEntity("\u7248\u672c\u53f7", (Object)"version"));
                        continue block48;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OfFixedAssetsRepairInfoVO> info(@PathVariable(value="id") String id) {
        OfFixedAssetsRepairEntity entity = this.ofFixedAssetsRepairService.getInfo(id);
        OfFixedAssetsRepairInfoVO vo = (OfFixedAssetsRepairInfoVO)JsonUtil.getJsonToBean((Object)entity, OfFixedAssetsRepairInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        vo.setCompanyId(this.baseDataUtil.comSelectValue(vo.getCompanyId(), "last"));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OfFixedAssetsRepairInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OfFixedAssetsRepairEntity entity = this.ofFixedAssetsRepairService.getInfo(id);
        OfFixedAssetsRepairInfoVO vo = (OfFixedAssetsRepairInfoVO)JsonUtil.getJsonToBean((Object)entity, OfFixedAssetsRepairInfoVO.class);
        vo.setReportUserId(this.baseDataUtil.userSelectValues(vo.getReportUserId()));
        vo.setPictures(this.baseDataUtil.getFileNameInJson(vo.getPictures()));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        vo.setCompanyId(this.baseDataUtil.comSelectValue(vo.getCompanyId(), "last"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OfFixedAssetsRepairUpForm ofFixedAssetsRepairUpForm) throws DataException {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u66f4\u65b0\u5931\u8d25");
        }
        OfFixedAssetsRepairEntity entity = this.ofFixedAssetsRepairService.getInfo(id);
        if (entity != null) {
            ofFixedAssetsRepairUpForm.setCompanyId(entity.getCompanyId());
            OfFixedAssetsRepairEntity subentity = (OfFixedAssetsRepairEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsRepairUpForm, OfFixedAssetsRepairEntity.class);
            this.ofFixedAssetsRepairService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        OfFixedAssetsRepairEntity entity = this.ofFixedAssetsRepairService.getInfo(id);
        if (entity != null) {
            this.ofFixedAssetsRepairService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/batchRemove/{ids}"})
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        if (StringUtils.isNotEmpty((String)ids)) {
            this.ofFixedAssetsRepairService.delete(ids);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

