/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.assets.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.assets.entity.OfFixedAssetsEntity;
import com.bringspring.assets.entity.OfFixedAssetsTypeEntity;
import com.bringspring.assets.model.offixedassetstype.OfFixedAssetsTypeCrForm;
import com.bringspring.assets.model.offixedassetstype.OfFixedAssetsTypeInfoVO;
import com.bringspring.assets.model.offixedassetstype.OfFixedAssetsTypeListQuery;
import com.bringspring.assets.model.offixedassetstype.OfFixedAssetsTypeListVO;
import com.bringspring.assets.model.offixedassetstype.OfFixedAssetsTypeModel;
import com.bringspring.assets.model.offixedassetstype.OfFixedAssetsTypePagination;
import com.bringspring.assets.model.offixedassetstype.OfFixedAssetsTypePaginationExportModel;
import com.bringspring.assets.model.offixedassetstype.OfFixedAssetsTypeSelector;
import com.bringspring.assets.model.offixedassetstype.OfFixedAssetsTypeUpForm;
import com.bringspring.assets.service.OfFixedAssetsService;
import com.bringspring.assets.service.OfFixedAssetsTypeService;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.EnabledMarkEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u56fa\u5b9a\u8d44\u4ea7\u7c7b\u578b"}, value="OfFixedAssetsType")
@RequestMapping(value={"/api/assets/OfFixedAssetsType"})
public class OfFixedAssetsTypeController {
    private static final Logger log = LoggerFactory.getLogger(OfFixedAssetsTypeController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OfFixedAssetsTypeService ofFixedAssetsTypeService;
    @Autowired
    private OfFixedAssetsService ofFixedAssetsService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OfFixedAssetsTypePagination ofFixedAssetsTypePagination) throws IOException {
        List<OfFixedAssetsTypeEntity> list = this.ofFixedAssetsTypeService.getList(ofFixedAssetsTypePagination);
        List listVO = JsonUtil.getJsonToList(list, OfFixedAssetsTypeListVO.class);
        for (OfFixedAssetsTypeListVO vo : listVO) {
            vo.setOrganizeTdsTree(this.baseDataUtil.comSelectValues(vo.getOrganizeTdsTree()));
            vo.setCompanyId(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
            if (StringUtils.isNotEmpty((String)vo.getParentId()) && ObjectUtil.isNotEmpty((Object)this.ofFixedAssetsTypeService.getInfo(vo.getParentId()))) {
                vo.setParentId(this.ofFixedAssetsTypeService.getInfo(vo.getParentId()).getName());
            }
            vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
            vo.setDeleteUserId(this.baseDataUtil.userSelectValue(vo.getDeleteUserId()));
            vo.setDeleteMark(this.baseDataUtil.switchSelectValue(vo.getDeleteMark(), "\u6b63\u5e38", "\u5220\u9664"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ofFixedAssetsTypePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OfFixedAssetsTypeCrForm ofFixedAssetsTypeCrForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OfFixedAssetsTypeEntity entity = (OfFixedAssetsTypeEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsTypeCrForm, OfFixedAssetsTypeEntity.class);
        this.ofFixedAssetsTypeService.create(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OfFixedAssetsTypePaginationExportModel ofFixedAssetsTypePaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)ofFixedAssetsTypePaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OfFixedAssetsTypePagination ofFixedAssetsTypePagination = (OfFixedAssetsTypePagination)((Object)JsonUtil.getJsonToBean((Object)((Object)ofFixedAssetsTypePaginationExportModel), OfFixedAssetsTypePagination.class));
        List<OfFixedAssetsTypeEntity> list = this.ofFixedAssetsTypeService.getTypeList(ofFixedAssetsTypePagination, ofFixedAssetsTypePaginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, OfFixedAssetsTypeListVO.class);
        for (OfFixedAssetsTypeListVO vo : listVO) {
            if (StringUtils.isNotEmpty((String)vo.getParentId()) && ObjectUtil.isNotEmpty((Object)this.ofFixedAssetsTypeService.getInfo(vo.getParentId()))) {
                vo.setParentId(this.ofFixedAssetsTypeService.getInfo(vo.getParentId()).getName());
            }
            vo.setGlobalMark(StringUtils.isNotEmpty((String)vo.getGlobalMark()) && "2".equals(vo.getGlobalMark()) ? "\u7ec4\u7ec7" : "\u5168\u5c40");
            vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), "\u542f\u7528", "\u7981\u7528"));
            vo.setOrganizeTdsTree(this.baseDataUtil.comSelectValues(vo.getOrganizeTdsTree()));
            vo.setCompanyId(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
            vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
            vo.setDeleteUserId(this.baseDataUtil.userSelectValue(vo.getDeleteUserId()));
            vo.setDeleteMark(this.baseDataUtil.switchSelectValue(vo.getDeleteMark(), "\u6b63\u5e38", "\u5220\u9664"));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)ofFixedAssetsTypePaginationExportModel.getSelectKey()) ? ofFixedAssetsTypePaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block40: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "code": {
                        entitys.add(new ExcelExportEntity("\u5206\u7c7b\u7f16\u7801", (Object)"code"));
                        continue block40;
                    }
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u5206\u7c7b\u540d\u79f0", (Object)"name"));
                        continue block40;
                    }
                    case "parentId": {
                        entitys.add(new ExcelExportEntity("\u4e0a\u7ea7", (Object)"parentId"));
                        continue block40;
                    }
                    case "sortCode": {
                        entitys.add(new ExcelExportEntity("\u6392\u5e8f", (Object)"sortCode"));
                        continue block40;
                    }
                    case "treeNames": {
                        entitys.add(new ExcelExportEntity("\u4e0a\u7ea7", (Object)"treeNames"));
                        continue block40;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u63cf\u8ff0", (Object)"description"));
                        continue block40;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u6709\u6548\u6807\u5fd7", (Object)"enabledMark"));
                        continue block40;
                    }
                    case "globalMark": {
                        entitys.add(new ExcelExportEntity("\u5168\u5c40\u6807\u8bc6", (Object)"globalMark"));
                        continue block40;
                    }
                    case "organizeTdsTree": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u7ec4\u7ec7", (Object)"organizeTdsTree"));
                        continue block40;
                    }
                    case "companyId": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyId"));
                        continue block40;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block40;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block40;
                    }
                    case "lastModifyUserId": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u7528\u6237", (Object)"lastModifyUserId"));
                        continue block40;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u65f6\u95f4", (Object)"lastModifyTime"));
                        continue block40;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8d44\u4ea7\u5206\u7c7b\u7ba1\u7406\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8d44\u4ea7\u5206\u7c7b\u7ba1\u7406\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OfFixedAssetsTypeInfoVO> info(@PathVariable(value="id") String id) {
        OfFixedAssetsTypeEntity entity = this.ofFixedAssetsTypeService.getInfo(id);
        OfFixedAssetsTypeInfoVO vo = (OfFixedAssetsTypeInfoVO)JsonUtil.getJsonToBean((Object)entity, OfFixedAssetsTypeInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OfFixedAssetsTypeInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OfFixedAssetsTypeEntity entity = this.ofFixedAssetsTypeService.getInfo(id);
        OfFixedAssetsTypeInfoVO vo = (OfFixedAssetsTypeInfoVO)JsonUtil.getJsonToBean((Object)entity, OfFixedAssetsTypeInfoVO.class);
        vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), "\u542f\u7528", "\u7981\u7528"));
        vo.setOrganizeTdsTree(this.baseDataUtil.comSelectValues(vo.getOrganizeTdsTree()));
        vo.setCompanyId(this.baseDataUtil.comSelectValues(vo.getCompanyId()));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        vo.setDeleteUserId(this.baseDataUtil.userSelectValue(vo.getDeleteUserId()));
        vo.setDeleteMark(this.baseDataUtil.switchSelectValue(vo.getDeleteMark(), "\u6b63\u5e38", "\u5220\u9664"));
        if (StringUtils.isNotEmpty((String)vo.getParentId()) && ObjectUtil.isNotEmpty((Object)this.ofFixedAssetsTypeService.getInfo(vo.getParentId()))) {
            vo.setParentId(this.ofFixedAssetsTypeService.getInfo(vo.getParentId()).getName());
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OfFixedAssetsTypeUpForm ofFixedAssetsTypeUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        OfFixedAssetsTypeEntity entity = this.ofFixedAssetsTypeService.getInfo(id);
        if (entity != null) {
            OfFixedAssetsTypeEntity subentity = (OfFixedAssetsTypeEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsTypeUpForm, OfFixedAssetsTypeEntity.class);
            this.ofFixedAssetsTypeService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OfFixedAssetsTypeEntity entity = this.ofFixedAssetsTypeService.getInfo(id);
        ArrayList<String> needDelIdList = new ArrayList<String>();
        if (entity != null) {
            List<OfFixedAssetsEntity> byAssetsTypeId = this.ofFixedAssetsService.getByAssetsTypeId(id);
            if (!byAssetsTypeId.isEmpty()) {
                return ActionResult.fail((String)"\u8be5\u5206\u7c7b\u4e0b\u9762\u6709\u8d44\u4ea7\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            needDelIdList.add(id);
            List<OfFixedAssetsTypeEntity> listByParentId = this.ofFixedAssetsTypeService.getListByParentId(id);
            if (!listByParentId.isEmpty()) {
                List<String> collect = listByParentId.stream().map(OfFixedAssetsTypeEntity::getId).collect(Collectors.toList());
                List<OfFixedAssetsEntity> byAssetsTypeIdIn = this.ofFixedAssetsService.getByAssetsTypeIdIn(collect);
                if (!byAssetsTypeIdIn.isEmpty()) {
                    return ActionResult.fail((String)"\u5b50\u5206\u7c7b\u5173\u8054\u6709\u8d44\u4ea7\uff0c\u4e0d\u80fd\u5220\u9664");
                }
                needDelIdList.addAll(collect);
            }
            this.ofFixedAssetsTypeService.removeBatchByIds(needDelIdList);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/getListTree"})
    public ActionResult getListTree(@RequestParam String parentId, @RequestParam String menuId) {
        if (StringUtils.isEmpty((String)menuId)) {
            return ActionResult.success(new ArrayList());
        }
        List<OfFixedAssetsTypeInfoVO> listVO = this.ofFixedAssetsTypeService.getListTree(parentId, menuId);
        return ActionResult.success(listVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u8d44\u4ea7\u5206\u7c7b\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/Selector"})
    public ActionResult<ListVO<OfFixedAssetsTypeSelector>> getSelector(OfFixedAssetsTypeListQuery query) {
        List<OfFixedAssetsTypeEntity> allList = this.ofFixedAssetsTypeService.getListAll(query);
        List data = allList.stream().filter(t -> EnabledMarkEnum.ENABLE.getCode() == t.getEnabledMark()).collect(Collectors.toList());
        String keyword = query.getKeyword();
        if (!StringUtils.isEmpty((String)keyword)) {
            data = data.stream().filter(t -> t.getName().contains(keyword) || t.getCode().contains(keyword)).collect(Collectors.toList());
        }
        List models = JsonUtil.getJsonToList(data, OfFixedAssetsTypeModel.class);
        List trees = TreeDotUtils.convertListToTreeDotFilter((List)models);
        List listVO = JsonUtil.getJsonToList((Object)trees, OfFixedAssetsTypeSelector.class);
        ListVO vo = new ListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }
}

