/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.assets.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.assets.entity.OfFixedAssetsEntity;
import com.bringspring.assets.entity.OfFixedAssetsLogsInventoryEntity;
import com.bringspring.assets.entity.OfFixedAssetsOrderEntity;
import com.bringspring.assets.entity.OfFixedAssetsOrderItemEntity;
import com.bringspring.assets.mapper.OfFixedAssetsOrderItemMapper;
import com.bringspring.assets.model.ofFixedAssetsOrderItem.OfFixedAssetsOrderItemData;
import com.bringspring.assets.model.ofFixedAssetsOrderItem.OfFixedAssetsOrderItemListVO;
import com.bringspring.assets.model.ofFixedAssetsOrderItem.OfFixedAssetsOrderItemPagination;
import com.bringspring.assets.model.ofFixedAssetsOrderItem.OfFixedAssetsOrderItemUpForm;
import com.bringspring.assets.service.OfFixedAssetsLogsInventoryService;
import com.bringspring.assets.service.OfFixedAssetsOrderItemService;
import com.bringspring.assets.service.OfFixedAssetsOrderService;
import com.bringspring.assets.service.OfFixedAssetsService;
import com.bringspring.assets.service.OfFixedAssetsTypeService;
import com.bringspring.assets.util.DeleteMarkEnum;
import com.bringspring.assets.util.EnabledMarkEnum;
import com.bringspring.assets.util.FixedAssetsOrderItemActionEnum;
import com.bringspring.assets.util.FixedAssetsOrderItemStateEnum;
import com.bringspring.assets.util.FixedAssetsOrderStateEnum;
import com.bringspring.assets.util.InventoryWayEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.logistics.entity.BasSpaceEntity;
import com.bringspring.logistics.service.BasSpaceService;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.msgcenter.model.BusinessKeys;
import com.bringspring.system.msgcenter.model.CustomKeysLink;
import com.bringspring.system.msgcenter.model.LinkMsgKeys;
import com.bringspring.system.msgcenter.model.TaskMsg;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OfFixedAssetsOrderItemServiceImpl
extends ServiceImpl<OfFixedAssetsOrderItemMapper, OfFixedAssetsOrderItemEntity>
implements OfFixedAssetsOrderItemService {
    @Autowired
    private OfFixedAssetsService ofFixedAssetsService;
    @Autowired
    private BasSpaceService basSpaceService;
    @Autowired
    private OfFixedAssetsOrderService ofFixedAssetsOrderService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private OfFixedAssetsLogsInventoryService ofFixedAssetsLogsInventoryService;
    @Autowired
    private OfFixedAssetsTypeService ofFixedAssetsTypeService;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    @DSTransactional
    public List<OfFixedAssetsOrderItemEntity> getListPage(OfFixedAssetsOrderItemPagination itemPagination) {
        ArrayList<String> listTreeId;
        Object ofFixedAssetsOrderItemObj;
        ArrayList AllIdList = new ArrayList();
        boolean total = false;
        int ofFixedAssetsOrderItemNum = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsOrderItemObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, itemPagination.getMenuId(), "of_fixed_assets_order_item"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsOrderItemObj)) {
                return new ArrayList<OfFixedAssetsOrderItemEntity>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsOrderItemObj;
            ++ofFixedAssetsOrderItemNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsOrderItemObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, itemPagination.getMenuId(), "of_fixed_assets_order_item"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsOrderItemObj)) {
                return new ArrayList<OfFixedAssetsOrderItemEntity>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsOrderItemObj;
            ++ofFixedAssetsOrderItemNum;
        }
        if (StrUtil.isNotBlank((CharSequence)itemPagination.getFixedAssetsOrderId())) {
            OfFixedAssetsOrderEntity byId = (OfFixedAssetsOrderEntity)this.ofFixedAssetsOrderService.getById((Serializable)((Object)itemPagination.getFixedAssetsOrderId()));
            if (byId.getOrderState() == FixedAssetsOrderStateEnum.CHECK_NO_START.getState()) {
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.ne(OfFixedAssetsEntity::getEnabledMark, (Object)EnabledMarkEnum.BF.getMark());
                lambdaQueryWrapper.eq(OfFixedAssetsEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
                lambdaQueryWrapper.eq(OfFixedAssetsEntity::getInventoryWay, (Object)InventoryWayEnum.YES.getMark());
                if (StringUtils.isNotEmpty((String)byId.getCompanyId()) && !"1".equals(byId.getCompanyId())) {
                    lambdaQueryWrapper.eq(OfFixedAssetsEntity::getCompanyId, (Object)byId.getCompanyId());
                }
                if (StringUtils.isNotEmpty((String)byId.getFixedAssetsTypeId())) {
                    Object[] types = byId.getFixedAssetsTypeId().split(",");
                    lambdaQueryWrapper.in(OfFixedAssetsEntity::getFixedAssetsTypeId, types);
                }
                if (StringUtils.isNotEmpty((String)byId.getBasSpaceIds())) {
                    Object[] spaces = byId.getBasSpaceIds().split(",");
                    lambdaQueryWrapper.in(OfFixedAssetsEntity::getBasSpaceId, spaces);
                }
                if (StringUtils.isNotEmpty((String)byId.getAssetsNames())) {
                    Object[] assetsNameArr = byId.getAssetsNames().split(",");
                    lambdaQueryWrapper.in(OfFixedAssetsEntity::getName, assetsNameArr);
                }
                if (StringUtils.isNotEmpty((String)byId.getAssetsSorts())) {
                    String[] assetsSortArr = byId.getAssetsSorts().split(",");
                    ArrayList<String> values = new ArrayList<String>();
                    for (String s : assetsSortArr) {
                        values.add(s.split(":")[0]);
                    }
                    lambdaQueryWrapper.in(OfFixedAssetsEntity::getIsFixedAssets, values);
                }
                LambdaQueryWrapper spaceQueryWrapper = new LambdaQueryWrapper();
                List list = this.ofFixedAssetsService.list((Wrapper)lambdaQueryWrapper);
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    List collect = list.stream().map(entity -> {
                        Integer state = FixedAssetsOrderItemStateEnum.NOT_CHECK.getState();
                        spaceQueryWrapper.clear();
                        spaceQueryWrapper.eq(BasSpaceEntity::getDeleteMark, (Object)com.bringspring.common.base.DeleteMarkEnum.NOT_DELETE.getCode());
                        spaceQueryWrapper.eq(BasSpaceEntity::getId, (Object)entity.getBasSpaceId());
                        BasSpaceEntity spaceEntity = (BasSpaceEntity)this.basSpaceService.getOne((Wrapper)spaceQueryWrapper);
                        if (ObjectUtil.isEmpty((Object)spaceEntity)) {
                            state = FixedAssetsOrderItemStateEnum.CHECK_CHANGE.getState();
                        }
                        OfFixedAssetsOrderItemEntity itemEntity = new OfFixedAssetsOrderItemEntity(RandomUtil.uuId(), itemPagination.getFixedAssetsOrderId(), entity.getId(), state, entity.getCode(), entity.getRfidCode(), entity.getRfidDecode(), entity.getFixedAssetsTypeId(), entity.getBaseUserId(), entity.getBasSpaceId(), entity.getCompanyId(), entity.getBaseUserName(), entity.getIsCustomUser(), entity.getBaseOrganizeName(), entity.getDescription());
                        return itemEntity;
                    }).collect(Collectors.toList());
                    this.saveBatch(collect);
                    UserInfo userInfo = this.userProvider.get();
                    byId.setOrderSdateAct(new Date());
                    byId.setBaseUserId(userInfo.getUserId());
                    byId.setOrderState(FixedAssetsOrderStateEnum.CHECK_ING.getState());
                    this.ofFixedAssetsOrderService.saveOrUpdate(byId);
                }
            }
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getFixedAssetsOrderId, (Object)itemPagination.getFixedAssetsOrderId());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getCompanyId()) && !"1".equals(itemPagination.getCompanyId())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getCompanyId, (Object)itemPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getAssetName())) {
            String inSql = "SELECT id FROM of_fixed_assets WHERE name LIKE '%" + itemPagination.getAssetName() + "%'";
            queryWrapper.lambda().inSql(OfFixedAssetsOrderItemEntity::getFixedAssetsId, inSql);
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getKeyword())) {
            queryWrapper.lambda().and(wq -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wq.like(OfFixedAssetsOrderItemEntity::getCode, (Object)itemPagination.getKeyword())).or()).like(OfFixedAssetsOrderItemEntity::getRfidDecode, (Object)itemPagination.getKeyword()));
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getCode())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getCode, (Object)itemPagination.getCode());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getBaseUserId())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getBaseUserId, (Object)itemPagination.getBaseUserId());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getBaseUserName())) {
            queryWrapper.lambda().like(OfFixedAssetsOrderItemEntity::getBaseUserName, (Object)itemPagination.getBaseUserName());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getFixedAssetsTypeId())) {
            listTreeId = new ArrayList<String>();
            listTreeId.add(itemPagination.getFixedAssetsTypeId());
            listTreeId.addAll(this.ofFixedAssetsTypeService.getListTreeId(itemPagination.getFixedAssetsTypeId()));
            queryWrapper.lambda().in(OfFixedAssetsOrderItemEntity::getFixedAssetsTypeId, listTreeId);
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getBasSpaceId())) {
            listTreeId = new ArrayList();
            listTreeId.add(itemPagination.getBasSpaceId());
            listTreeId.addAll(this.basSpaceService.getChildIdByParentId(itemPagination.getBasSpaceId()));
            queryWrapper.lambda().in(OfFixedAssetsOrderItemEntity::getBasSpaceId, listTreeId);
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getBasSpaceIdAct())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getBasSpaceIdAct, (Object)itemPagination.getBasSpaceIdAct());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getRfidCode())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getRfidCode, (Object)itemPagination.getRfidCode());
        }
        if (itemPagination.getMenuType() == 1) {
            if (itemPagination.getFixedAssetsState() != null) {
                queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getFixedAssetsState, (Object)itemPagination.getFixedAssetsState());
            } else {
                List list = ListUtil.list((boolean)false);
                list.add(FixedAssetsOrderItemStateEnum.CHECK_CHANGE.getState());
                list.add(FixedAssetsOrderItemStateEnum.CHECK_ADD.getState());
                list.add(FixedAssetsOrderItemStateEnum.CHECK_LOSS.getState());
                queryWrapper.lambda().in(OfFixedAssetsOrderItemEntity::getFixedAssetsState, (Collection)list);
            }
            if (itemPagination.getIsAct() != null && itemPagination.getIsAct() == 1) {
                queryWrapper.lambda().isNotNull(OfFixedAssetsOrderItemEntity::getActionType);
            } else if (itemPagination.getIsAct() != null && itemPagination.getIsAct() == 0) {
                queryWrapper.lambda().isNull(OfFixedAssetsOrderItemEntity::getActionType);
            }
        } else if (itemPagination.getFixedAssetsState() != null && itemPagination.getFixedAssetsState() != -2) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getFixedAssetsState, (Object)itemPagination.getFixedAssetsState());
        }
        if (StringUtils.isEmpty((String)itemPagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(OfFixedAssetsOrderItemEntity::getLastModifyTime);
        } else {
            try {
                String sidx = itemPagination.getSidx();
                OfFixedAssetsOrderItemEntity ofFixedAssetsOrderItemEntity = new OfFixedAssetsOrderItemEntity();
                Field declaredField = ofFixedAssetsOrderItemEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(itemPagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        Page page = new Page(itemPagination.getCurrentPage(), itemPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
        List records = userIPage.getRecords();
        return itemPagination.setData(records, userIPage.getTotal());
    }

    @Override
    public List<OfFixedAssetsOrderItemEntity> getTypeList(OfFixedAssetsOrderItemPagination pagination, String dataType) {
        ArrayList<String> listTreeId;
        Object obj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ofFixedAssetsOrderItemNum = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            obj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "of_fixed_assets_order_item"));
            if (ObjectUtil.isEmpty((Object)obj)) {
                return new ArrayList<OfFixedAssetsOrderItemEntity>();
            }
            queryWrapper = (QueryWrapper)obj;
            ++ofFixedAssetsOrderItemNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            obj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "of_fixed_assets_order_item"));
            if (ObjectUtil.isEmpty((Object)obj)) {
                return new ArrayList<OfFixedAssetsOrderItemEntity>();
            }
            queryWrapper = (QueryWrapper)obj;
            ++ofFixedAssetsOrderItemNum;
        }
        if (StringUtils.isNotEmpty((String)pagination.getFixedAssetsOrderId())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getFixedAssetsOrderId, (Object)pagination.getFixedAssetsOrderId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCompanyId()) && !"1".equals(pagination.getCompanyId())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getCompanyId, (Object)pagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            queryWrapper.lambda().and(wq -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wq.like(OfFixedAssetsOrderItemEntity::getCode, (Object)pagination.getKeyword())).or()).like(OfFixedAssetsOrderItemEntity::getRfidDecode, (Object)pagination.getKeyword()));
        }
        if (StringUtils.isNotEmpty((String)pagination.getCode())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getCode, (Object)pagination.getCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getBaseUserId())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getBaseUserId, (Object)pagination.getBaseUserId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getBaseUserName())) {
            queryWrapper.lambda().like(OfFixedAssetsOrderItemEntity::getBaseUserName, (Object)pagination.getBaseUserName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getFixedAssetsTypeId())) {
            listTreeId = new ArrayList<String>();
            listTreeId.add(pagination.getFixedAssetsTypeId());
            listTreeId.addAll(this.ofFixedAssetsTypeService.getListTreeId(pagination.getFixedAssetsTypeId()));
            queryWrapper.lambda().in(OfFixedAssetsOrderItemEntity::getFixedAssetsTypeId, listTreeId);
        }
        if (StringUtils.isNotEmpty((String)pagination.getBasSpaceId())) {
            listTreeId = new ArrayList();
            listTreeId.add(pagination.getBasSpaceId());
            listTreeId.addAll(this.basSpaceService.getChildIdByParentId(pagination.getBasSpaceId()));
            queryWrapper.lambda().in(OfFixedAssetsOrderItemEntity::getBasSpaceId, listTreeId);
        }
        if (StringUtils.isNotEmpty((String)pagination.getBasSpaceIdAct())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getBasSpaceIdAct, (Object)pagination.getBasSpaceIdAct());
        }
        if (StringUtils.isNotEmpty((String)pagination.getRfidCode())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getRfidCode, (Object)pagination.getRfidCode());
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(OfFixedAssetsOrderItemEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(OfFixedAssetsOrderItemEntity::getLastModifyTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                OfFixedAssetsOrderItemEntity ofFixedAssetsOrderItemEntity = new OfFixedAssetsOrderItemEntity();
                Field declaredField = ofFixedAssetsOrderItemEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return pagination.setData(list, list.size());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public OfFixedAssetsOrderItemEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getId, (Object)id);
        return (OfFixedAssetsOrderItemEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public List<OfFixedAssetsOrderItemEntity> getListAll(OfFixedAssetsOrderItemPagination itemPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getFixedAssetsOrderId, (Object)itemPagination.getFixedAssetsOrderId());
        if (itemPagination.getFixedAssetsState() != null && itemPagination.getFixedAssetsState() != -2) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getFixedAssetsState, (Object)itemPagination.getFixedAssetsState());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getCode())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getCode, (Object)itemPagination.getCode());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getBasSpaceId())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getBasSpaceId, (Object)itemPagination.getBasSpaceId());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getBasSpaceIdAct())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getBasSpaceIdAct, (Object)itemPagination.getBasSpaceIdAct());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getInventorySpace())) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getBasSpaceId, (Object)itemPagination.getInventorySpace())).or()).eq(OfFixedAssetsOrderItemEntity::getBasSpaceIdAct, (Object)itemPagination.getInventorySpace());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getRfidCode())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getRfidCode, (Object)itemPagination.getRfidCode());
        }
        if (StringUtils.isEmpty((String)itemPagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(OfFixedAssetsOrderItemEntity::getLastModifyTime);
        } else {
            try {
                String sidx = itemPagination.getSidx();
                OfFixedAssetsOrderItemEntity ofFixedAssetsOrderItemEntity = new OfFixedAssetsOrderItemEntity();
                Field declaredField = ofFixedAssetsOrderItemEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(itemPagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        List orderItems = this.list((Wrapper)queryWrapper);
        return orderItems;
    }

    @Override
    @DSTransactional
    public List<OfFixedAssetsOrderItemEntity> queryListAll(OfFixedAssetsOrderItemPagination itemPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        String fixedAssetsOrderId = itemPagination.getFixedAssetsOrderId();
        if (!StringUtils.isEmpty((String)fixedAssetsOrderId)) {
            this.createFixedAssetsOrderItem(itemPagination.getFixedAssetsOrderId());
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getFixedAssetsOrderId, (Object)fixedAssetsOrderId);
        }
        if (itemPagination.getFixedAssetsState() != null && itemPagination.getFixedAssetsState() != -2) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getFixedAssetsState, (Object)itemPagination.getFixedAssetsState());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getCode())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getCode, (Object)itemPagination.getCode());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getBasSpaceId())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getBasSpaceId, (Object)itemPagination.getBasSpaceId());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getBasSpaceIdAct())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getBasSpaceIdAct, (Object)itemPagination.getBasSpaceIdAct());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getInventorySpace())) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getBasSpaceId, (Object)itemPagination.getInventorySpace())).or()).eq(OfFixedAssetsOrderItemEntity::getBasSpaceIdAct, (Object)itemPagination.getInventorySpace());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getRfidCode())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getRfidCode, (Object)itemPagination.getRfidCode());
        }
        if (StringUtils.isEmpty((String)itemPagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(OfFixedAssetsOrderItemEntity::getLastModifyTime);
        } else {
            try {
                String sidx = itemPagination.getSidx();
                OfFixedAssetsOrderItemEntity ofFixedAssetsOrderItemEntity = new OfFixedAssetsOrderItemEntity();
                Field declaredField = ofFixedAssetsOrderItemEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(itemPagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        List orderItems = this.list((Wrapper)queryWrapper);
        return orderItems;
    }

    @Override
    public List<OfFixedAssetsOrderItemEntity> getEntityList(OfFixedAssetsOrderItemPagination itemPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getFixedAssetsOrderId, (Object)itemPagination.getFixedAssetsOrderId());
        if (itemPagination.getFixedAssetsState() != null && itemPagination.getFixedAssetsState() != -2) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getFixedAssetsState, (Object)itemPagination.getFixedAssetsState());
        }
        if (ObjectUtil.isNotEmpty((Object)itemPagination.getFixedAssetsStates())) {
            queryWrapper.lambda().in(OfFixedAssetsOrderItemEntity::getFixedAssetsState, (Object[])itemPagination.getFixedAssetsStates());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getCode())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getCode, (Object)itemPagination.getCode());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getBasSpaceId())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getBasSpaceId, (Object)itemPagination.getBasSpaceId());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getBasSpaceIdAct())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getBasSpaceIdAct, (Object)itemPagination.getBasSpaceIdAct());
        }
        if (StringUtils.isNotEmpty((String)itemPagination.getRfidCode())) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getRfidCode, (Object)itemPagination.getRfidCode());
        }
        List orderItems = this.list((Wrapper)queryWrapper);
        return orderItems;
    }

    @Override
    @DSTransactional
    public String updateMakeAnInventoryByRfid(String fixedAssetsOrderId, String basSpaceId, String[] rfidCodes) {
        if (ObjectUtil.isNotEmpty((Object)rfidCodes) && rfidCodes.length > 0) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(OfFixedAssetsOrderItemEntity::getFixedAssetsOrderId, (Object)fixedAssetsOrderId);
            queryWrapper.in(OfFixedAssetsOrderItemEntity::getRfidCode, (Object[])rfidCodes);
            Object[] states = new Integer[]{FixedAssetsOrderItemStateEnum.NOT_CHECK.getState(), FixedAssetsOrderItemStateEnum.CHECK_LOSS.getState(), FixedAssetsOrderItemStateEnum.CHECK_ADD.getState()};
            queryWrapper.in(OfFixedAssetsOrderItemEntity::getFixedAssetsState, states);
            List list = this.list((Wrapper)queryWrapper);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                String spaceName = ((BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)basSpaceId))).getSpaceName();
                for (OfFixedAssetsOrderItemEntity entity : list) {
                    boolean bl;
                    Integer fixedAssetsState = entity.getFixedAssetsState();
                    if (FixedAssetsOrderItemStateEnum.NOT_CHECK.getState().equals(fixedAssetsState)) {
                        if (basSpaceId.equals(entity.getBasSpaceId())) {
                            entity.setFixedAssetsState(FixedAssetsOrderItemStateEnum.CHECK_NORMAL.getState());
                            bl = this.updateMakeAnInventory(entity, spaceName);
                            continue;
                        }
                        entity.setBasSpaceIdAct(basSpaceId);
                        entity.setFixedAssetsState(FixedAssetsOrderItemStateEnum.CHECK_ADD.getState());
                        bl = this.updateMakeAnInventory(entity, spaceName);
                        continue;
                    }
                    if (FixedAssetsOrderItemStateEnum.CHECK_ADD.getState().equals(fixedAssetsState)) {
                        if (basSpaceId.equals(entity.getBasSpaceId())) {
                            entity.setBasSpaceIdAct("");
                            entity.setFixedAssetsState(FixedAssetsOrderItemStateEnum.CHECK_NORMAL.getState());
                            bl = this.updateMakeAnInventory(entity, spaceName);
                            continue;
                        }
                        entity.setBasSpaceIdAct(basSpaceId);
                        entity.setFixedAssetsState(FixedAssetsOrderItemStateEnum.CHECK_ADD.getState());
                        bl = this.updateMakeAnInventory(entity, spaceName);
                        continue;
                    }
                    if (!FixedAssetsOrderItemStateEnum.CHECK_LOSS.getState().equals(fixedAssetsState)) continue;
                    if (basSpaceId.equals(entity.getBasSpaceId())) {
                        entity.setFixedAssetsState(FixedAssetsOrderItemStateEnum.CHECK_NORMAL.getState());
                        bl = this.updateMakeAnInventory(entity, spaceName);
                        continue;
                    }
                    entity.setBasSpaceIdAct(basSpaceId);
                    entity.setFixedAssetsState(FixedAssetsOrderItemStateEnum.CHECK_CHANGE.getState());
                    bl = this.updateMakeAnInventory(entity, spaceName);
                }
            } else {
                return "\u65e0\u5f85\u76d8\u70b9\u8d44\u4ea7";
            }
        }
        return "";
    }

    @Override
    @DSTransactional
    public boolean updateMakeAnInventory(OfFixedAssetsOrderItemEntity entity, String spaceName) {
        boolean flag = false;
        OfFixedAssetsOrderEntity orderEntity = (OfFixedAssetsOrderEntity)this.ofFixedAssetsOrderService.getById((Serializable)((Object)entity.getFixedAssetsOrderId()));
        if (ObjectUtil.isNotEmpty((Object)orderEntity)) {
            String orderName = orderEntity.getOrderName();
            UserInfo userInfo = this.userProvider.get();
            String companyId = userInfo.getOrganizeId();
            Integer state = entity.getFixedAssetsState();
            flag = this.updateById(entity);
            if (flag) {
                String stateDesc = "";
                if (FixedAssetsOrderItemStateEnum.CHECK_NORMAL.getState().equals(state)) {
                    stateDesc = FixedAssetsOrderItemStateEnum.CHECK_NORMAL.getDesc();
                }
                if (FixedAssetsOrderItemStateEnum.CHECK_CHANGE.getState().equals(state)) {
                    stateDesc = FixedAssetsOrderItemStateEnum.CHECK_CHANGE.getDesc();
                }
                if (FixedAssetsOrderItemStateEnum.CHECK_ADD.getState().equals(state)) {
                    stateDesc = FixedAssetsOrderItemStateEnum.CHECK_ADD.getDesc();
                }
                if (FixedAssetsOrderItemStateEnum.CHECK_LOSS.getState().equals(state)) {
                    stateDesc = FixedAssetsOrderItemStateEnum.CHECK_LOSS.getDesc();
                }
                String description = "\u76d8\u70b9:" + orderName + "_" + stateDesc + "_" + spaceName;
                this.insertLogsInventory(entity.getFixedAssetsOrderId(), entity.getId(), "W02", userInfo, description, companyId);
                ArrayList<Integer> stateList = new ArrayList<Integer>();
                stateList.add(FixedAssetsOrderItemStateEnum.NOT_CHECK.getState());
                stateList.add(FixedAssetsOrderItemStateEnum.CHECK_ADD.getState());
                QueryWrapper queryWrapper = new QueryWrapper();
                ((LambdaQueryWrapper)queryWrapper.lambda().in(OfFixedAssetsOrderItemEntity::getFixedAssetsState, stateList)).eq(OfFixedAssetsOrderItemEntity::getFixedAssetsOrderId, (Object)entity.getFixedAssetsOrderId());
                long count = this.count((Wrapper)queryWrapper);
                if (count == 0L) {
                    orderEntity.setOrderState(FixedAssetsOrderStateEnum.CHECK_END.getState());
                    orderEntity.setOrderEdateAct(new Date());
                    this.ofFixedAssetsOrderService.saveOrUpdate(orderEntity);
                }
            }
        }
        return flag;
    }

    @Override
    @DSTransactional
    public boolean updateInventoryLosses(List<OfFixedAssetsOrderItemEntity> items, OfFixedAssetsOrderItemPagination pagination) {
        String fixedAssetsOrderId;
        OfFixedAssetsOrderEntity orderEntity;
        boolean flag = false;
        if (!CollectionUtils.isEmpty(items) && ObjectUtil.isNotEmpty((Object)(orderEntity = (OfFixedAssetsOrderEntity)this.ofFixedAssetsOrderService.getById((Serializable)((Object)(fixedAssetsOrderId = pagination.getFixedAssetsOrderId())))))) {
            String orderName = orderEntity.getOrderName();
            UserInfo userInfo = this.userProvider.get();
            String companyId = userInfo.getOrganizeId();
            Integer state = FixedAssetsOrderItemStateEnum.CHECK_LOSS.getState();
            String stateDesc = FixedAssetsOrderItemStateEnum.CHECK_LOSS.getDesc();
            for (int i = 0; i < items.size(); ++i) {
                OfFixedAssetsOrderItemEntity entity = items.get(i);
                if (!FixedAssetsOrderItemStateEnum.NOT_CHECK.getState().equals(entity.getFixedAssetsState()) && FixedAssetsOrderItemStateEnum.CHECK_ADD.getState().equals(entity.getFixedAssetsState())) {
                    state = FixedAssetsOrderItemStateEnum.CHECK_CHANGE.getState();
                    stateDesc = FixedAssetsOrderItemStateEnum.CHECK_CHANGE.getDesc();
                }
                entity.setFixedAssetsState(state);
                flag = this.updateById(entity);
                if (!flag) continue;
                String description = "\u76d8\u70b9:" + orderName + "_" + stateDesc + "_" + pagination.getBasSpaceName();
                this.insertLogsInventory(entity.getFixedAssetsOrderId(), entity.getId(), "W02", userInfo, description, companyId);
            }
            ArrayList<Integer> stateList = new ArrayList<Integer>();
            stateList.add(FixedAssetsOrderItemStateEnum.NOT_CHECK.getState());
            stateList.add(FixedAssetsOrderItemStateEnum.CHECK_ADD.getState());
            QueryWrapper queryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.lambda().in(OfFixedAssetsOrderItemEntity::getFixedAssetsState, stateList)).eq(OfFixedAssetsOrderItemEntity::getFixedAssetsOrderId, (Object)fixedAssetsOrderId);
            long count = this.count((Wrapper)queryWrapper);
            if (count == 0L) {
                orderEntity.setOrderState(FixedAssetsOrderStateEnum.CHECK_END.getState());
                orderEntity.setOrderEdateAct(new Date());
                this.ofFixedAssetsOrderService.saveOrUpdate(orderEntity);
            }
        }
        return flag;
    }

    @Override
    @DSTransactional
    public boolean updateDispose(String way, OfFixedAssetsOrderItemEntity entity) {
        BasSpaceEntity space;
        boolean b = this.updateById(entity);
        UserInfo userInfo = this.userProvider.get();
        Integer fixedAssetsState = entity.getFixedAssetsState();
        String stateDesc = FixedAssetsOrderItemStateEnum.getDescByState(fixedAssetsState);
        String description = "\u76d8\u70b9\u5f02\u5e38\u5904\u7f6e\uff1a\u786e\u8ba4\u7ed3\u679c\u4e3a" + stateDesc;
        if (fixedAssetsState.intValue() == FixedAssetsOrderItemStateEnum.CHECK_CHANGE.getState().intValue() && ObjectUtil.isNotEmpty((Object)(space = (BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)entity.getBasSpaceIdAct()))))) {
            description = description + " \u53d8\u66f4\u6240\u5c5e\u7a7a\u95f4\u4e3a" + space.getSpaceName();
        }
        String companyId = userInfo.getOrganizeId();
        this.insertLogsInventory(entity.getFixedAssetsOrderId(), entity.getId(), way, userInfo, description, companyId);
        return b;
    }

    @Override
    @DSTransactional
    public void updateStateFromPC(String id, OfFixedAssetsOrderItemEntity entity) {
        UserInfo userInfo = this.userProvider.get();
        entity.setId(id);
        if (this.updateById(entity)) {
            String companyId = userInfo.getOrganizeId();
            OfFixedAssetsOrderEntity orderEntity = (OfFixedAssetsOrderEntity)this.ofFixedAssetsOrderService.getById((Serializable)((Object)entity.getFixedAssetsOrderId()));
            String orderName = orderEntity.getOrderName();
            BasSpaceEntity spaceEntity = (BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)entity.getBasSpaceId()));
            String spaceName = ObjectUtil.isNotEmpty((Object)spaceEntity) ? spaceEntity.getSpaceName() : "";
            String stateDesc = "";
            int state = entity.getFixedAssetsState();
            if (FixedAssetsOrderItemStateEnum.CHECK_NORMAL.getState() == state) {
                stateDesc = FixedAssetsOrderItemStateEnum.CHECK_NORMAL.getDesc();
            }
            if (FixedAssetsOrderItemStateEnum.CHECK_CHANGE.getState() == state) {
                stateDesc = FixedAssetsOrderItemStateEnum.CHECK_CHANGE.getDesc();
            }
            if (FixedAssetsOrderItemStateEnum.CHECK_ADD.getState() == state) {
                stateDesc = FixedAssetsOrderItemStateEnum.CHECK_ADD.getDesc();
            }
            if (FixedAssetsOrderItemStateEnum.CHECK_LOSS.getState() == state) {
                stateDesc = FixedAssetsOrderItemStateEnum.CHECK_LOSS.getDesc();
            }
            String description = "\u76d8\u70b9:" + orderName + "_" + stateDesc + "_" + spaceName;
            this.insertLogsInventory(orderEntity.getId(), entity.getId(), "W01", userInfo, description, companyId);
            this.judgeOrderEnd(orderEntity.getId());
        }
    }

    @Override
    @DSTransactional
    public void rfidResultUpload(String orderId, List<OfFixedAssetsOrderItemUpForm> list) {
        List<String> idList;
        List<OfFixedAssetsOrderItemEntity> itemList;
        UserInfo userInfo = this.userProvider.get();
        if (CollectionUtil.isNotEmpty(list) && CollectionUtil.isNotEmpty(itemList = this.getNonInventory(orderId, idList = list.stream().map(OfFixedAssetsOrderItemUpForm::getId).collect(Collectors.toList())))) {
            ArrayList updateList = new ArrayList();
            ArrayList logList = new ArrayList();
            itemList.stream().forEach(entity -> {
                if (ObjectUtil.isNotEmpty((Object)entity)) {
                    Integer localState = entity.getFixedAssetsState();
                    OfFixedAssetsOrderItemUpForm itemUp = list.stream().filter(t -> entity.getId().equals(t.getId())).findFirst().orElse(null);
                    Integer offlineState = itemUp.getFixedAssetsState();
                    if (!ObjectUtil.isEmpty((Object)localState) && !ObjectUtil.isEmpty((Object)offlineState) && localState.intValue() != offlineState.intValue()) {
                        entity.setFixedAssetsState(offlineState);
                        entity.setBasSpaceIdAct("null".equals(itemUp.getBasSpaceIdAct()) ? "" : itemUp.getBasSpaceIdAct());
                        updateList.add(entity);
                        if (CollectionUtil.isNotEmpty(itemUp.getLogsInventorylist())) {
                            itemUp.getLogsInventorylist().stream().forEach(log -> {
                                log.setWay("W03");
                                log.setInventoryById(userInfo.getUserId());
                                log.setInventoryBy(userInfo.getUserName());
                                OfFixedAssetsLogsInventoryEntity logEntity = (OfFixedAssetsLogsInventoryEntity)JsonUtil.getJsonToBean((Object)log, OfFixedAssetsLogsInventoryEntity.class);
                                logList.add(logEntity);
                            });
                        }
                    }
                }
            });
            if (CollectionUtil.isNotEmpty(updateList) && this.updateBatchById(updateList)) {
                this.ofFixedAssetsLogsInventoryService.saveBatch(logList);
                this.judgeOrderEnd(orderId);
            }
        }
    }

    public List<OfFixedAssetsOrderItemEntity> getNonInventory(String orderId, List<String> idList) {
        ArrayList<Integer> stateList = new ArrayList<Integer>();
        stateList.add(FixedAssetsOrderItemStateEnum.NOT_CHECK.getState());
        stateList.add(FixedAssetsOrderItemStateEnum.CHECK_ADD.getState());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(OfFixedAssetsOrderItemEntity::getFixedAssetsState, stateList);
        if (StringUtils.isNotEmpty((String)orderId)) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getFixedAssetsOrderId, (Object)orderId);
        }
        if (CollectionUtil.isNotEmpty(idList)) {
            queryWrapper.lambda().in(OfFixedAssetsOrderItemEntity::getId, idList);
        }
        return this.list((Wrapper)queryWrapper);
    }

    public void judgeOrderEnd(String orderId) {
        OfFixedAssetsOrderEntity orderEntity;
        List<OfFixedAssetsOrderItemEntity> itemList = this.getNonInventory(orderId, null);
        if ((CollectionUtil.isEmpty(itemList) || itemList.size() == 0) && ObjectUtil.isNotEmpty((Object)(orderEntity = (OfFixedAssetsOrderEntity)this.ofFixedAssetsOrderService.getById((Serializable)((Object)orderId))))) {
            orderEntity.setOrderState(FixedAssetsOrderStateEnum.CHECK_END.getState());
            orderEntity.setOrderEdateAct(new Date());
            this.ofFixedAssetsOrderService.saveOrUpdate(orderEntity);
        }
    }

    @Override
    public List<OfFixedAssetsOrderItemListVO> getListByAssetsId(String assetsId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getFixedAssetsId, (Object)assetsId)).ne(OfFixedAssetsOrderItemEntity::getFixedAssetsState, (Object)FixedAssetsOrderItemStateEnum.NOT_CHECK.getState())).orderByDesc(OfFixedAssetsOrderItemEntity::getCreatorTime);
        List list = this.list((Wrapper)queryWrapper);
        List listVO = JsonUtil.getJsonToList((Object)list, OfFixedAssetsOrderItemListVO.class);
        Map<Integer, FixedAssetsOrderItemStateEnum> allToMap = FixedAssetsOrderItemStateEnum.getAllToMap();
        Map<String, FixedAssetsOrderItemActionEnum> allToMap1 = FixedAssetsOrderItemActionEnum.getAllToMap();
        listVO.stream().forEach(entity -> {
            entity.setCreatorTimeFormat(ObjectUtil.isNull((Object)entity.getCreatorTime()) ? null : DateUtil.dateFormat((Date)entity.getCreatorTime()));
            entity.setLastModifyTimeFormat(ObjectUtil.isNull((Object)entity.getLastModifyTime()) ? null : DateUtil.dateFormat((Date)entity.getLastModifyTime()));
            entity.setFixedAssetsStateName(ObjectUtil.isNull((Object)entity.getFixedAssetsState()) ? "" : ((FixedAssetsOrderItemStateEnum)((Object)((Object)allToMap.get(entity.getFixedAssetsState())))).getDesc());
            entity.setCreatorUserId(this.baseDataUtil.userSelectValueNoAccount(entity.getCreatorUserId()));
            entity.setLastModifyUserId(this.baseDataUtil.userSelectValueNoAccount(entity.getLastModifyUserId()));
            String actionTypeName = "";
            if (entity.getFixedAssetsState() == FixedAssetsOrderItemStateEnum.CHECK_NORMAL.getState()) {
                actionTypeName = "\u65e0\u9700\u5904\u7f6e";
                entity.setLastModifyTimeFormat("");
                entity.setLastModifyUserId("");
            } else {
                actionTypeName = StrUtil.isBlank((CharSequence)entity.getActionType()) ? "\u8fd8\u672a\u5904\u7f6e" : ((FixedAssetsOrderItemActionEnum)((Object)((Object)allToMap1.get(entity.getActionType())))).getDesc();
            }
            entity.setActionTypeName(actionTypeName);
        });
        return listVO;
    }

    @Override
    public List<Map<String, Object>> countByState(String assetsOrderId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{" FIXED_ASSETS_STATE as assetsState,count(*) AS stateNum "});
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getFixedAssetsOrderId, (Object)assetsOrderId)).groupBy(OfFixedAssetsOrderItemEntity::getFixedAssetsState);
        List maps = this.listMaps((Wrapper)queryWrapper);
        return maps;
    }

    @Override
    public List<Map<String, Object>> getSpacesByOrderId(String assetsOrderId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{" bas_space_id AS spaceId, fixed_assets_state AS state"});
        queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getFixedAssetsOrderId, (Object)assetsOrderId);
        queryWrapper.lambda().groupBy(OfFixedAssetsOrderItemEntity::getBasSpaceId);
        queryWrapper.lambda().groupBy(OfFixedAssetsOrderItemEntity::getFixedAssetsState);
        queryWrapper.lambda().orderByAsc(OfFixedAssetsOrderItemEntity::getBasSpaceId);
        queryWrapper.lambda().orderByAsc(OfFixedAssetsOrderItemEntity::getFixedAssetsState);
        List maps = this.listMaps((Wrapper)queryWrapper);
        return maps;
    }

    @Override
    public long selectOrderItemBySpaceIdCount(String spaceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getBasSpaceId, (Object)spaceId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public long countByState(String fixedAssetsOrderId, Integer fixedAssetsState) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getFixedAssetsOrderId, (Object)fixedAssetsOrderId);
        if (fixedAssetsState != null && fixedAssetsState != -2) {
            queryWrapper.lambda().eq(OfFixedAssetsOrderItemEntity::getFixedAssetsState, (Object)fixedAssetsState);
        }
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void selfInventoryNotification(String[] ids, UserInfo userInfo) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(OfFixedAssetsOrderItemEntity::getId, (Object[])ids);
        List list = this.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list) && list.size() != 0) {
            this.sendMessage(list, userInfo.getUserName());
        }
    }

    private void sendMessage(List<OfFixedAssetsOrderItemEntity> list, String currentUser) throws Exception {
        for (OfFixedAssetsOrderItemEntity entity : list) {
            if (this.redisUtil.exists(entity.getId())) continue;
            String itemId = entity.getId();
            String fixedAssetsId = entity.getFixedAssetsId();
            ArrayList<String> userIds = new ArrayList<String>();
            userIds.add(entity.getBaseUserId());
            TaskMsg taskMsg = new TaskMsg();
            taskMsg.setTaskCode("\u8d44\u4ea7\u7ba1\u7406");
            taskMsg.setSendCode("self_inventory_notification");
            Map<String, String> parameterMap = this.getParameterMap(entity);
            LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
            linkMsgKeys.setLinkUrl("");
            linkMsgKeys.setKeys(parameterMap);
            taskMsg.setBusinessKey((BusinessKeys)linkMsgKeys);
            CustomKeysLink customKeysLink = new CustomKeysLink();
            customKeysLink.setTermType(TermTypeEnum.TERM_APP.getCode());
            customKeysLink.setTermTypeDesc("\u8bf7\u7528\u624b\u673a\u6253\u5f00\u94fe\u63a5\uff0c\u8fdb\u884c\u626b\u7801\u81ea\u76d8\u4fe1\u606f\u786e\u8ba4");
            customKeysLink.setAppUrl("/#/pages/assets/assets-self-inventory/index?itemId=" + itemId + "&assetsId=" + fixedAssetsId);
            taskMsg.setCustomKey(customKeysLink);
            taskMsg.setToUserIds(String.join((CharSequence)",", userIds));
            this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
            entity.setReportState("RS02");
            this.saveOrUpdate(entity);
            this.redisUtil.insert(entity.getId(), null, 7200L);
        }
    }

    private Map<String, String> getParameterMap(OfFixedAssetsOrderItemEntity entity) {
        OfFixedAssetsOrderEntity assetsOrder;
        String title = "\u8d44\u4ea7\u81ea\u76d8\u901a\u77e5";
        String content = "\u6709\u65b0\u7684\u8d44\u4ea7\u76d8\u70b9\u8ba1\u5212\uff01";
        String remark = "\u8bf7\u70b9\u51fb\u8be6\u60c5\u4e0a\u62a5\u8d44\u4ea7\u60c5\u51b5\uff0c\u5982\u9700\u534f\u52a9\u8bf7\u8054\u7cfb\u901a\u77e5\u4eba\u3002";
        HashMap<String, String> map = new HashMap<String, String>();
        String itemId = entity.getId();
        String fixedAssetsOrderId = entity.getFixedAssetsOrderId();
        String fixedAssetsId = entity.getFixedAssetsId();
        String assetsName = "";
        String orderName = "";
        String baseUserId = entity.getBaseUserId();
        String baseUserName = "";
        String code = entity.getCode();
        if (!StrUtil.isBlank((CharSequence)fixedAssetsId)) {
            assetsName = ((OfFixedAssetsEntity)this.ofFixedAssetsService.getById((Serializable)((Object)entity.getFixedAssetsId()))).getName();
        }
        if (!StrUtil.isBlank((CharSequence)baseUserId)) {
            baseUserName = this.baseDataUtil.userSelectValueNoAccount(baseUserId);
        }
        if ((assetsOrder = (OfFixedAssetsOrderEntity)this.ofFixedAssetsOrderService.getById((Serializable)((Object)fixedAssetsOrderId))) != null) {
            orderName = assetsOrder.getOrderName();
        }
        map.put("title", title);
        map.put("desc", "\u534f\u52a9\u8d44\u4ea7\u76d8\u70b9\u901a\u77e5");
        map.put("content", content);
        map.put("id", itemId);
        map.put("assetsName", assetsName);
        map.put("assetsCode", DesensitizedUtil.idCardNum((String)code, (int)2, (int)2));
        map.put("useName", baseUserName);
        map.put("orderName", orderName);
        map.put("informUser", this.userProvider.get().getUserName());
        String messageTime = DateUtil.dateFormat((Date)new Date());
        map.put("messageTime", messageTime);
        map.put("remark", remark);
        return map;
    }

    @Override
    @DSTransactional
    public void saveSelfInventoryAffirmInfo(String id, OfFixedAssetsOrderItemEntity entity, OfFixedAssetsOrderItemUpForm upForm) {
        UserInfo userInfo = this.userProvider.get();
        String companyId = userInfo.getOrganizeId();
        Integer fixedAssetsState = upForm.getFixedAssetsState();
        entity.setFixedAssetsState(fixedAssetsState);
        entity.setBasSpaceIdAct(upForm.getBasSpaceIdAct());
        entity.setReportJson(upForm.getReportJson());
        entity.setDescription(upForm.getDescription());
        entity.setFiles(upForm.getFiles());
        entity.setReportState("RS03");
        entity.setReportId(userInfo.getUserId());
        entity.setReportTime(new Date());
        if (this.updateById(entity)) {
            String stateDesc = FixedAssetsOrderItemStateEnum.getDescByState(fixedAssetsState);
            String desc = StringUtils.isEmpty((String)entity.getDescription()) ? "" : entity.getDescription();
            String description = "\u81ea\u76d8:" + stateDesc + " " + desc;
            this.insertLogsInventory(entity.getFixedAssetsOrderId(), entity.getId(), "W04", userInfo, description, companyId);
        }
    }

    public void createFixedAssetsOrderItem(String orderId) {
        OfFixedAssetsOrderEntity byId = (OfFixedAssetsOrderEntity)this.ofFixedAssetsOrderService.getById((Serializable)((Object)orderId));
        if (byId.getOrderState() == FixedAssetsOrderStateEnum.CHECK_NO_START.getState()) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.ne(OfFixedAssetsEntity::getEnabledMark, (Object)EnabledMarkEnum.BF.getMark());
            queryWrapper.eq(OfFixedAssetsEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
            queryWrapper.eq(OfFixedAssetsEntity::getInventoryWay, (Object)InventoryWayEnum.YES.getMark());
            queryWrapper.eq(OfFixedAssetsEntity::getCompanyId, (Object)byId.getCompanyId());
            if (StringUtils.isNotEmpty((String)byId.getFixedAssetsTypeId())) {
                Object[] types = byId.getFixedAssetsTypeId().split(",");
                queryWrapper.in(OfFixedAssetsEntity::getFixedAssetsTypeId, types);
            }
            if (StringUtils.isNotEmpty((String)byId.getBasSpaceIds())) {
                Object[] spaces = byId.getBasSpaceIds().split(",");
                queryWrapper.in(OfFixedAssetsEntity::getBasSpaceId, spaces);
            }
            if (StringUtils.isNotEmpty((String)byId.getAssetsNames())) {
                Object[] assetsNameArr = byId.getAssetsNames().split(",");
                queryWrapper.in(OfFixedAssetsEntity::getName, assetsNameArr);
            }
            if (StringUtils.isNotEmpty((String)byId.getAssetsSorts())) {
                String[] assetsSortArr = byId.getAssetsSorts().split(",");
                ArrayList<String> values = new ArrayList<String>();
                for (String s : assetsSortArr) {
                    values.add(s.split(":")[0]);
                }
                queryWrapper.in(OfFixedAssetsEntity::getName, values);
            }
            LambdaQueryWrapper spaceQueryWrapper = new LambdaQueryWrapper();
            List list = this.ofFixedAssetsService.list((Wrapper)queryWrapper);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                List collect = list.stream().map(entity -> {
                    Integer state = FixedAssetsOrderItemStateEnum.NOT_CHECK.getState();
                    spaceQueryWrapper.clear();
                    spaceQueryWrapper.eq(BasSpaceEntity::getDeleteMark, (Object)com.bringspring.common.base.DeleteMarkEnum.NOT_DELETE.getCode());
                    spaceQueryWrapper.eq(BasSpaceEntity::getId, (Object)entity.getBasSpaceId());
                    BasSpaceEntity spaceEntity = (BasSpaceEntity)this.basSpaceService.getOne((Wrapper)spaceQueryWrapper);
                    if (ObjectUtil.isEmpty((Object)spaceEntity)) {
                        state = FixedAssetsOrderItemStateEnum.CHECK_CHANGE.getState();
                    }
                    OfFixedAssetsOrderItemEntity itemEntity = new OfFixedAssetsOrderItemEntity(RandomUtil.uuId(), orderId, entity.getId(), state, entity.getCode(), entity.getRfidCode(), entity.getRfidDecode(), entity.getFixedAssetsTypeId(), entity.getBaseUserId(), entity.getBasSpaceId(), entity.getCompanyId(), entity.getBaseUserName(), entity.getIsCustomUser(), entity.getBaseOrganizeName(), entity.getDescription());
                    return itemEntity;
                }).collect(Collectors.toList());
                this.saveBatch(collect);
                UserInfo userInfo = this.userProvider.get();
                byId.setOrderSdateAct(new Date());
                byId.setBaseUserId(userInfo.getUserId());
                byId.setOrderState(FixedAssetsOrderStateEnum.CHECK_ING.getState());
                this.ofFixedAssetsOrderService.saveOrUpdate(byId);
            }
        }
    }

    @Override
    public void insertLogsInventory(String orderId, String itemId, String way, UserInfo userInfo, String description, String companyId) {
        OfFixedAssetsLogsInventoryEntity logsInventoryEntity = new OfFixedAssetsLogsInventoryEntity(null, orderId, itemId, way, userInfo.getUserId(), userInfo.getUserName(), DateUtil.getNowDate(), description, companyId);
        this.ofFixedAssetsLogsInventoryService.create(logsInventoryEntity);
    }

    @Override
    @DSTransactional
    public void updateInventoryBatch(String[] ids, OfFixedAssetsOrderItemData data) {
        if (ObjectUtil.isNotEmpty((Object)ids)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(OfFixedAssetsOrderItemEntity::getId, (Object[])ids);
            List list = this.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                UserInfo userInfo = this.userProvider.get();
                String orderId = data.getFixedAssetsOrderId();
                Integer fixedAssetsState = data.getFixedAssetsState();
                String companyId = userInfo.getOrganizeId();
                String stateDesc = FixedAssetsOrderItemStateEnum.getDescByState(fixedAssetsState);
                String desc = StringUtils.isEmpty((String)data.getDescription()) ? "" : data.getDescription();
                String description = "\u6279\u91cf\u76d8\u70b9:" + stateDesc + " " + desc;
                ArrayList logs = new ArrayList();
                list.stream().forEach(item -> {
                    item.setFixedAssetsState(fixedAssetsState);
                    OfFixedAssetsLogsInventoryEntity logsInventoryEntity = new OfFixedAssetsLogsInventoryEntity(RandomUtil.uuId(), item.getFixedAssetsOrderId(), item.getId(), "W01", userInfo.getUserId(), userInfo.getUserName(), DateUtil.getNowDate(), description, companyId);
                    logs.add(logsInventoryEntity);
                });
                this.updateBatchById(list);
                this.ofFixedAssetsLogsInventoryService.saveBatch(logs);
                OfFixedAssetsOrderEntity orderEntity = (OfFixedAssetsOrderEntity)this.ofFixedAssetsOrderService.getById((Serializable)((Object)orderId));
                if (ObjectUtil.isNotEmpty((Object)orderEntity)) {
                    ArrayList<Integer> stateList = new ArrayList<Integer>();
                    stateList.add(FixedAssetsOrderItemStateEnum.NOT_CHECK.getState());
                    stateList.add(FixedAssetsOrderItemStateEnum.CHECK_ADD.getState());
                    queryWrapper.clear();
                    ((LambdaQueryWrapper)queryWrapper.lambda().in(OfFixedAssetsOrderItemEntity::getFixedAssetsState, stateList)).eq(OfFixedAssetsOrderItemEntity::getFixedAssetsOrderId, (Object)orderId);
                    long count = this.count((Wrapper)queryWrapper);
                    if (count == 0L) {
                        orderEntity.setOrderState(FixedAssetsOrderStateEnum.CHECK_END.getState());
                        orderEntity.setOrderEdateAct(new Date());
                        this.ofFixedAssetsOrderService.saveOrUpdate(orderEntity);
                    }
                }
            }
        }
    }

    @Override
    @DSTransactional
    public void updateDisposeBatch(String[] ids, OfFixedAssetsOrderItemData data) {
        if (ObjectUtil.isNotEmpty((Object)ids)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(OfFixedAssetsOrderItemEntity::getId, (Object[])ids);
            List list = this.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                UserInfo userInfo = this.userProvider.get();
                Integer fixedAssetsState = data.getFixedAssetsState();
                String basSpaceIdAct = data.getBasSpaceIdAct();
                String actionType = data.getActionType();
                String companyId = userInfo.getOrganizeId();
                String stateDesc = FixedAssetsOrderItemStateEnum.getDescByState(fixedAssetsState);
                String description = "\u6279\u91cf\u5f02\u5e38\u5904\u7f6e\uff1a\u786e\u8ba4\u7ed3\u679c\u4e3a" + stateDesc;
                if (fixedAssetsState == FixedAssetsOrderItemStateEnum.CHECK_CHANGE.getState()) {
                    BasSpaceEntity space = (BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)basSpaceIdAct));
                    String basSpaceName = "";
                    if (ObjectUtil.isNotEmpty((Object)space)) {
                        basSpaceName = space.getSpaceName();
                    }
                    description = description + " \u53d8\u66f4\u6240\u5c5e\u7a7a\u95f4\u4e3a" + basSpaceName;
                }
                ArrayList<OfFixedAssetsLogsInventoryEntity> logs = new ArrayList<OfFixedAssetsLogsInventoryEntity>();
                for (OfFixedAssetsOrderItemEntity item : list) {
                    item.setFixedAssetsState(fixedAssetsState);
                    item.setBasSpaceIdAct(basSpaceIdAct);
                    item.setActionType(actionType);
                    OfFixedAssetsLogsInventoryEntity logsInventoryEntity = new OfFixedAssetsLogsInventoryEntity(RandomUtil.uuId(), item.getFixedAssetsOrderId(), item.getId(), "W01", userInfo.getUserId(), userInfo.getUserName(), DateUtil.getNowDate(), description, companyId);
                    logs.add(logsInventoryEntity);
                }
                this.updateBatchById(list);
                this.ofFixedAssetsLogsInventoryService.saveBatch(logs);
            }
        }
    }
}

