/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.assets.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.assets.entity.OfFixedAssetsEntity;
import com.bringspring.assets.entity.OfFixedAssetsLogsEntity;
import com.bringspring.assets.exception.ExcelValidationException;
import com.bringspring.assets.exception.ValidationException;
import com.bringspring.assets.mapper.OfFixedAssetsMapper;
import com.bringspring.assets.model.fixedassets.OfFixedAssetsBatchForm;
import com.bringspring.assets.model.fixedassets.OfFixedAssetsImportModel;
import com.bringspring.assets.model.fixedassets.OfFixedAssetsImportVO;
import com.bringspring.assets.model.fixedassets.OfFixedAssetsListQuery;
import com.bringspring.assets.model.fixedassets.OfFixedAssetsPagination;
import com.bringspring.assets.model.fixedassets.OfFixedAssetsUpForm;
import com.bringspring.assets.service.OfFixedAssetsLogsService;
import com.bringspring.assets.service.OfFixedAssetsService;
import com.bringspring.assets.service.OfFixedAssetsTypeService;
import com.bringspring.assets.util.Constants;
import com.bringspring.assets.util.DataStateEnum;
import com.bringspring.assets.util.DeleteMarkEnum;
import com.bringspring.assets.util.EnabledMarkEnum;
import com.bringspring.assets.util.InventoryWayEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.logistics.entity.BasSpaceEntity;
import com.bringspring.logistics.service.BasSpaceService;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.model.organize.OrganizeDepartSelectorListVO;
import com.bringspring.system.permission.model.organize.OrganizeModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OfFixedAssetsServiceImpl
extends ServiceImpl<OfFixedAssetsMapper, OfFixedAssetsEntity>
implements OfFixedAssetsService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private BasSpaceService basSpaceService;
    @Autowired
    private OfFixedAssetsTypeService ofFixedAssetsTypeService;
    @Autowired
    private OfFixedAssetsLogsService ofFixedAssetsLogsService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private UserService userService;
    @Autowired
    private OfFixedAssetsMapper ofFixedAssetsMapper;

    @Override
    public List<OfFixedAssetsEntity> getList(OfFixedAssetsPagination pagination) {
        ArrayList<String> listTreeId;
        Object ofFixedAssetsObj;
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ofFixedAssetsNum = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<OfFixedAssetsEntity>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
            ++ofFixedAssetsNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<OfFixedAssetsEntity>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
            ++ofFixedAssetsNum;
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getIds()) && pagination.getIds().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getId, (Object[])pagination.getIds());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCompanyId()) && !"1".equals(pagination.getCompanyId())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getCompanyId, (Object)pagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getBaseOrganizeId())) {
            List underOrganizations = this.organizeService.getUnderOrganizations(pagination.getBaseOrganizeId());
            List userByOrgIds = this.userService.getUserByOrgIds(underOrganizations);
            List<String> userIds = userByOrgIds.stream().map(UserEntity::getId).collect(Collectors.toList());
            pagination.setBaseUserIds(userIds.toArray(new String[userIds.size()]));
        }
        if (StringUtils.isNotEmpty((String)pagination.getBaseUserName())) {
            queryWrapper.lambda().like(OfFixedAssetsEntity::getBaseUserName, (Object)pagination.getBaseUserName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getBaseUserId())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getBaseUserId, (Object)pagination.getBaseUserId());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getBaseUserIds()) && pagination.getBaseUserIds().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getBaseUserId, (Object[])pagination.getBaseUserIds());
        }
        if (StringUtils.isNotEmpty((String)pagination.getBasSpaceId())) {
            listTreeId = new ArrayList<String>();
            listTreeId.add(pagination.getBasSpaceId());
            listTreeId.addAll(this.basSpaceService.getChildIdByParentId(pagination.getBasSpaceId()));
            queryWrapper.lambda().in(OfFixedAssetsEntity::getBasSpaceId, listTreeId);
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getBasSpaceIds()) && pagination.getBasSpaceIds().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getBasSpaceId, (Object[])pagination.getBasSpaceIds());
        }
        if (StringUtils.isNotEmpty((String)pagination.getName())) {
            queryWrapper.lambda().like(OfFixedAssetsEntity::getName, (Object)pagination.getName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCode())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getCode, (Object)pagination.getCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getAccess())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getAccess, (Object)pagination.getAccess());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getAssetsCodes()) && pagination.getAssetsCodes().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getCode, (Object[])pagination.getAssetsCodes());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getRfidDecodes()) && pagination.getRfidDecodes().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getRfidDecode, (Object[])pagination.getRfidDecodes());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getAssetsNames()) && pagination.getAssetsNames().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getName, (Object[])pagination.getAssetsNames());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getAssetsSorts()) && pagination.getAssetsSorts().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getIsFixedAssets, (Object[])pagination.getAssetsSorts());
        }
        if (StringUtils.isNotEmpty((String)pagination.getKeyWord())) {
            if (pagination.getMenuType() == 1) {
                queryWrapper.lambda().and(wq -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.like(OfFixedAssetsEntity::getCode, (Object)pagination.getKeyWord())).or()).like(OfFixedAssetsEntity::getName, (Object)pagination.getKeyWord())).or()).like(OfFixedAssetsEntity::getRfidDecode, (Object)pagination.getKeyWord())).or()).like(OfFixedAssetsEntity::getModelNumber, (Object)pagination.getKeyWord()));
            } else {
                queryWrapper.lambda().and(wq -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.like(OfFixedAssetsEntity::getCode, (Object)pagination.getKeyWord())).or()).like(OfFixedAssetsEntity::getName, (Object)pagination.getKeyWord())).or()).like(OfFixedAssetsEntity::getModelNumber, (Object)pagination.getKeyWord()));
            }
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getKeyWordArr()) && pagination.getKeyWordArr().length > 0) {
            String[] keyWordArr = pagination.getKeyWordArr();
            queryWrapper.lambda().and(wq -> {
                for (int i = 0; i < keyWordArr.length; ++i) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.or()).like(OfFixedAssetsEntity::getCode, (Object)keyWordArr[i])).or()).like(OfFixedAssetsEntity::getName, (Object)keyWordArr[i])).or()).like(OfFixedAssetsEntity::getModelNumber, (Object)keyWordArr[i]);
                }
            });
        }
        if (CollectionUtil.isNotEmpty(pagination.getEnableDate())) {
            List<String> enableDateList = pagination.getEnableDate();
            Long fir = Long.valueOf(enableDateList.get(0));
            Long sec = Long.valueOf(enableDateList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(OfFixedAssetsEntity::getEnableDate, (Object)new Date(fir))).le(OfFixedAssetsEntity::getEnableDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnabledMark())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getEnabledMark, (Object)pagination.getEnabledMark());
        }
        if (pagination.getMenuType() != null && pagination.getMenuType() == 1) {
            queryWrapper.lambda().ne(OfFixedAssetsEntity::getEnabledMark, (Object)EnabledMarkEnum.BF.getMark());
        }
        if (StringUtils.isNotEmpty((String)pagination.getIsFixedAssets())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getIsFixedAssets, (Object)pagination.getIsFixedAssets());
        }
        if (StringUtils.isNotEmpty((String)pagination.getInventoryWay())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getInventoryWay, (Object)pagination.getInventoryWay());
        }
        if (StringUtils.isNotEmpty((String)pagination.getLabelCase())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getLabelCase, (Object)pagination.getLabelCase());
        }
        if (StringUtils.isNotEmpty((String)pagination.getProjectName())) {
            String projectName = pagination.getProjectName();
            if ("\u65e0".equals(projectName)) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().isNull(OfFixedAssetsEntity::getProjectName)).or()).eq(OfFixedAssetsEntity::getProjectName, (Object)"");
            } else {
                queryWrapper.lambda().like(OfFixedAssetsEntity::getProjectName, (Object)projectName);
            }
        }
        if (StringUtils.isNotEmpty((String)pagination.getRemark())) {
            queryWrapper.lambda().like(OfFixedAssetsEntity::getRemark, (Object)pagination.getRemark());
        }
        if (StringUtils.isNotEmpty((String)pagination.getFixedAssetsTypeId())) {
            listTreeId = new ArrayList();
            listTreeId.add(pagination.getFixedAssetsTypeId());
            listTreeId.addAll(this.ofFixedAssetsTypeService.getListTreeId(pagination.getFixedAssetsTypeId()));
            queryWrapper.lambda().in(OfFixedAssetsEntity::getFixedAssetsTypeId, listTreeId);
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getFixedAssetsTypeIds()) && pagination.getFixedAssetsTypeIds().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getFixedAssetsTypeId, (Object[])pagination.getFixedAssetsTypeIds());
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getId, AllIdList);
        }
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(OfFixedAssetsEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                OfFixedAssetsEntity ofFixedAssetsEntity = new OfFixedAssetsEntity();
                Field declaredField = ofFixedAssetsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return pagination.setData(list, list.size());
    }

    @Override
    public List<OfFixedAssetsEntity> getPreviewList(OfFixedAssetsPagination pagination) {
        ArrayList<String> listTreeId;
        Object ofFixedAssetsObj;
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ofFixedAssetsNum = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<OfFixedAssetsEntity>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
            ++ofFixedAssetsNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<OfFixedAssetsEntity>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
            ++ofFixedAssetsNum;
        }
        queryWrapper.lambda().ne(OfFixedAssetsEntity::getEnabledMark, (Object)EnabledMarkEnum.BF.getMark());
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        if (StringUtils.isNotEmpty((String)pagination.getCompanyId()) && !"1".equals(pagination.getCompanyId())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getCompanyId, (Object)pagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getBasSpaceId())) {
            listTreeId = new ArrayList<String>();
            listTreeId.add(pagination.getBasSpaceId());
            listTreeId.addAll(this.basSpaceService.getChildIdByParentId(pagination.getBasSpaceId()));
            queryWrapper.lambda().in(OfFixedAssetsEntity::getBasSpaceId, listTreeId);
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getBasSpaceIds()) && pagination.getBasSpaceIds().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getBasSpaceId, (Object[])pagination.getBasSpaceIds());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getAssetsNames()) && pagination.getAssetsNames().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getName, (Object[])pagination.getAssetsNames());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getAssetsSorts()) && pagination.getAssetsSorts().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getIsFixedAssets, (Object[])pagination.getAssetsSorts());
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnabledMark())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getEnabledMark, (Object)pagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty((String)pagination.getIsFixedAssets())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getIsFixedAssets, (Object)pagination.getIsFixedAssets());
        }
        if (StringUtils.isNotEmpty((String)pagination.getInventoryWay())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getInventoryWay, (Object)pagination.getInventoryWay());
        }
        if (StringUtils.isNotEmpty((String)pagination.getLabelCase())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getLabelCase, (Object)pagination.getLabelCase());
        }
        if (StringUtils.isNotEmpty((String)pagination.getFixedAssetsTypeId())) {
            listTreeId = new ArrayList();
            listTreeId.add(pagination.getFixedAssetsTypeId());
            listTreeId.addAll(this.ofFixedAssetsTypeService.getListTreeId(pagination.getFixedAssetsTypeId()));
            queryWrapper.lambda().in(OfFixedAssetsEntity::getFixedAssetsTypeId, listTreeId);
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getFixedAssetsTypeIds()) && pagination.getFixedAssetsTypeIds().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getFixedAssetsTypeId, (Object[])pagination.getFixedAssetsTypeIds());
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(OfFixedAssetsEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                OfFixedAssetsEntity ofFixedAssetsEntity = new OfFixedAssetsEntity();
                Field declaredField = ofFixedAssetsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return pagination.setData(list, list.size());
    }

    @Override
    public List<OfFixedAssetsEntity> getTypeList(OfFixedAssetsPagination pagination, String dataType) {
        Object ofFixedAssetsObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ofFixedAssetsNum = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<OfFixedAssetsEntity>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
            ++ofFixedAssetsNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<OfFixedAssetsEntity>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
            ++ofFixedAssetsNum;
        }
        if (StringUtils.isNotEmpty((String)pagination.getBaseOrganizeId())) {
            ++ofFixedAssetsNum;
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getBaseOrganizeId, (Object)pagination.getBaseOrganizeId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCompanyId()) && !"1".equals(pagination.getCompanyId())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getCompanyId, (Object)pagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getBaseUserName())) {
            queryWrapper.lambda().like(OfFixedAssetsEntity::getBaseUserName, (Object)pagination.getBaseUserName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getBaseUserId())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getBaseUserId, (Object)pagination.getBaseUserId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getBasSpaceId())) {
            ++ofFixedAssetsNum;
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getBasSpaceId, (Object)pagination.getBasSpaceId());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getBasSpaceIds()) && pagination.getBasSpaceIds().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getBasSpaceId, (Object[])pagination.getBasSpaceIds());
        }
        if (StringUtils.isNotEmpty((String)pagination.getName())) {
            ++ofFixedAssetsNum;
            queryWrapper.lambda().like(OfFixedAssetsEntity::getName, (Object)pagination.getName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCode())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getCode, (Object)pagination.getCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getAccess())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getAccess, (Object)pagination.getAccess());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getAssetsCodes()) && pagination.getAssetsCodes().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getCode, (Object[])pagination.getAssetsCodes());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getRfidDecodes()) && pagination.getRfidDecodes().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getRfidDecode, (Object[])pagination.getRfidDecodes());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getAssetsNames()) && pagination.getAssetsNames().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getName, (Object[])pagination.getAssetsNames());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getAssetsSorts()) && pagination.getAssetsSorts().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getIsFixedAssets, (Object[])pagination.getAssetsSorts());
        }
        if (StringUtils.isNotEmpty((String)pagination.getKeyWord())) {
            if (pagination.getMenuType() == 1) {
                queryWrapper.lambda().and(wq -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.like(OfFixedAssetsEntity::getCode, (Object)pagination.getKeyWord())).or()).like(OfFixedAssetsEntity::getName, (Object)pagination.getKeyWord())).or()).like(OfFixedAssetsEntity::getRfidDecode, (Object)pagination.getKeyWord()));
            } else {
                queryWrapper.lambda().and(wq -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wq.like(OfFixedAssetsEntity::getCode, (Object)pagination.getKeyWord())).or()).like(OfFixedAssetsEntity::getName, (Object)pagination.getKeyWord()));
            }
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getKeyWordArr()) && pagination.getKeyWordArr().length > 0) {
            if (pagination.getMenuType() == 1) {
                queryWrapper.lambda().and(wq -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wq.in(OfFixedAssetsEntity::getCode, (Object[])pagination.getKeyWordArr())).or()).in(OfFixedAssetsEntity::getName, (Object[])pagination.getKeyWordArr())).or()).in(OfFixedAssetsEntity::getRfidDecode, (Object[])pagination.getKeyWordArr()));
            } else {
                queryWrapper.lambda().and(wq -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wq.in(OfFixedAssetsEntity::getCode, (Object[])pagination.getKeyWordArr())).or()).in(OfFixedAssetsEntity::getName, (Object[])pagination.getKeyWordArr()));
            }
        }
        if (CollectionUtil.isNotEmpty(pagination.getEnableDate())) {
            List<String> enableDateList = pagination.getEnableDate();
            Long fir = Long.valueOf(enableDateList.get(0));
            Long sec = Long.valueOf(enableDateList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(OfFixedAssetsEntity::getEnableDate, (Object)new Date(fir))).le(OfFixedAssetsEntity::getEnableDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnabledMark())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getEnabledMark, (Object)pagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty((String)pagination.getIsFixedAssets())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getIsFixedAssets, (Object)pagination.getIsFixedAssets());
        }
        if (StringUtils.isNotEmpty((String)pagination.getInventoryWay())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getInventoryWay, (Object)pagination.getInventoryWay());
        }
        if (StringUtils.isNotEmpty((String)pagination.getLabelCase())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getLabelCase, (Object)pagination.getLabelCase());
        }
        if (StringUtils.isNotEmpty((String)pagination.getProjectName())) {
            queryWrapper.lambda().like(OfFixedAssetsEntity::getProjectName, (Object)pagination.getProjectName());
        }
        if (StringUtils.isNotEmpty((String)pagination.getRemark())) {
            queryWrapper.lambda().like(OfFixedAssetsEntity::getRemark, (Object)pagination.getRemark());
        }
        if (StringUtils.isNotEmpty((String)pagination.getFixedAssetsTypeId())) {
            ArrayList<String> listTreeId = new ArrayList<String>();
            listTreeId.add(pagination.getFixedAssetsTypeId());
            listTreeId.addAll(this.ofFixedAssetsTypeService.getListTreeId(pagination.getFixedAssetsTypeId()));
            queryWrapper.lambda().in(OfFixedAssetsEntity::getFixedAssetsTypeId, listTreeId);
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getFixedAssetsTypeIds()) && pagination.getFixedAssetsTypeIds().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getFixedAssetsTypeId, (Object[])pagination.getFixedAssetsTypeIds());
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getId, AllIdList);
        }
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(OfFixedAssetsEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                OfFixedAssetsEntity ofFixedAssetsEntity = new OfFixedAssetsEntity();
                Field declaredField = ofFixedAssetsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return pagination.setData(list, list.size());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public OfFixedAssetsEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getId, (Object)id);
        return (OfFixedAssetsEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public OfFixedAssetsEntity getInfoByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getCode, (Object)code);
        return (OfFixedAssetsEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<OfFixedAssetsEntity> getByAssetsTypeId(String assetsTypeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getFixedAssetsTypeId, (Object)assetsTypeId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OfFixedAssetsEntity> getByAssetsTypeIdIn(List<String> assetsTypeIdList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(OfFixedAssetsEntity::getFixedAssetsTypeId, assetsTypeIdList);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OfFixedAssetsEntity> getSelectOptionsProjectName(OfFixedAssetsListQuery listQuery) {
        ArrayList<String> listTreeId;
        Object ofFixedAssetsObj;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().select(new SFunction[]{OfFixedAssetsEntity::getProjectName});
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, listQuery.getMenuId(), "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<OfFixedAssetsEntity>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, listQuery.getMenuId(), "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<OfFixedAssetsEntity>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        if (StringUtils.isNotEmpty((String)listQuery.getIsFixedAssets())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getIsFixedAssets, (Object)listQuery.getIsFixedAssets());
        }
        if (ObjectUtil.isNotEmpty((Object)listQuery.getAssetsSorts()) && listQuery.getAssetsSorts().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getIsFixedAssets, (Object[])listQuery.getAssetsSorts());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getInventoryWay())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getInventoryWay, (Object)listQuery.getInventoryWay());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getBasSpaceId())) {
            listTreeId = new ArrayList<String>();
            listTreeId.add(listQuery.getBasSpaceId());
            listTreeId.addAll(this.basSpaceService.getChildIdByParentId(listQuery.getBasSpaceId()));
            queryWrapper.lambda().in(OfFixedAssetsEntity::getBasSpaceId, listTreeId);
        }
        if (ObjectUtil.isNotEmpty((Object)listQuery.getBasSpaceIds()) && listQuery.getBasSpaceIds().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getBasSpaceId, (Object[])listQuery.getBasSpaceIds());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getFixedAssetsTypeId())) {
            listTreeId = new ArrayList();
            listTreeId.add(listQuery.getFixedAssetsTypeId());
            listTreeId.addAll(this.ofFixedAssetsTypeService.getListTreeId(listQuery.getFixedAssetsTypeId()));
            queryWrapper.lambda().in(OfFixedAssetsEntity::getFixedAssetsTypeId, listTreeId);
        }
        if (ObjectUtil.isNotEmpty((Object)listQuery.getFixedAssetsTypeIds()) && listQuery.getFixedAssetsTypeIds().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getFixedAssetsTypeId, (Object[])listQuery.getFixedAssetsTypeIds());
        }
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        queryWrapper.lambda().isNotNull(OfFixedAssetsEntity::getProjectName);
        queryWrapper.lambda().ne(OfFixedAssetsEntity::getProjectName, (Object)"");
        queryWrapper.lambda().groupBy(OfFixedAssetsEntity::getProjectName);
        queryWrapper.lambda().orderByAsc(OfFixedAssetsEntity::getProjectName);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OfFixedAssetsEntity> getSelectOptionsRfid(OfFixedAssetsListQuery listQuery) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)listQuery.getIsFixedAssets())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getIsFixedAssets, (Object)listQuery.getIsFixedAssets());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getInventoryWay())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getInventoryWay, (Object)listQuery.getInventoryWay());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getBasSpaceId())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getBasSpaceId, (Object)listQuery.getBasSpaceId());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getFixedAssetsTypeId())) {
            ArrayList<String> listTreeId = new ArrayList<String>();
            listTreeId.add(listQuery.getFixedAssetsTypeId());
            listTreeId.addAll(this.ofFixedAssetsTypeService.getListTreeId(listQuery.getFixedAssetsTypeId()));
            queryWrapper.lambda().in(OfFixedAssetsEntity::getFixedAssetsTypeId, listTreeId);
        }
        if (ObjectUtil.isNotEmpty((Object)listQuery.getFixedAssetsTypeIds()) && listQuery.getFixedAssetsTypeIds().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getFixedAssetsTypeId, (Object[])listQuery.getFixedAssetsTypeIds());
        }
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        queryWrapper.lambda().isNotNull(OfFixedAssetsEntity::getRfidDecode);
        queryWrapper.lambda().ne(OfFixedAssetsEntity::getRfidDecode, (Object)"");
        queryWrapper.lambda().orderByDesc(OfFixedAssetsEntity::getRfidDecode);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OfFixedAssetsEntity> getSelectOptionsName(OfFixedAssetsListQuery listQuery) {
        ArrayList<String> listTreeId;
        Object ofFixedAssetsObj;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().select(new SFunction[]{OfFixedAssetsEntity::getName});
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, listQuery.getMenuId(), "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<OfFixedAssetsEntity>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, listQuery.getMenuId(), "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<OfFixedAssetsEntity>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        if (StringUtils.isNotEmpty((String)listQuery.getIsFixedAssets())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getIsFixedAssets, (Object)listQuery.getIsFixedAssets());
        }
        if (ObjectUtil.isNotEmpty((Object)listQuery.getAssetsSorts()) && listQuery.getAssetsSorts().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getIsFixedAssets, (Object[])listQuery.getAssetsSorts());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getInventoryWay())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getInventoryWay, (Object)listQuery.getInventoryWay());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getBasSpaceId())) {
            listTreeId = new ArrayList<String>();
            listTreeId.add(listQuery.getBasSpaceId());
            listTreeId.addAll(this.basSpaceService.getChildIdByParentId(listQuery.getBasSpaceId()));
            queryWrapper.lambda().in(OfFixedAssetsEntity::getBasSpaceId, listTreeId);
        }
        if (ObjectUtil.isNotEmpty((Object)listQuery.getBasSpaceIds()) && listQuery.getBasSpaceIds().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getBasSpaceId, (Object[])listQuery.getBasSpaceIds());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getFixedAssetsTypeId())) {
            listTreeId = new ArrayList();
            listTreeId.add(listQuery.getFixedAssetsTypeId());
            listTreeId.addAll(this.ofFixedAssetsTypeService.getListTreeId(listQuery.getFixedAssetsTypeId()));
            queryWrapper.lambda().in(OfFixedAssetsEntity::getFixedAssetsTypeId, listTreeId);
        }
        if (ObjectUtil.isNotEmpty((Object)listQuery.getFixedAssetsTypeIds()) && listQuery.getFixedAssetsTypeIds().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getFixedAssetsTypeId, (Object[])listQuery.getFixedAssetsTypeIds());
        }
        if (StringUtils.isNotEmpty((String)listQuery.getInventoryWay())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getInventoryWay, (Object)listQuery.getInventoryWay());
        }
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        queryWrapper.lambda().isNotNull(OfFixedAssetsEntity::getName);
        queryWrapper.lambda().groupBy(OfFixedAssetsEntity::getName);
        queryWrapper.lambda().orderByAsc(OfFixedAssetsEntity::getName);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(OfFixedAssetsEntity entity) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        String mainId = RandomUtil.uuId();
        entity.setId(mainId);
        entity.setDataState(DataStateEnum.ZC.getState());
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getDelete());
        entity.setEnabledMark(EnabledMarkEnum.KC.getMark());
        entity.setCode(StringUtils.trim((String)entity.getCode()));
        if (StringUtils.isEmpty((String)entity.getCode())) {
            String code = this.baseDataUtil.getBillNumber(Constants.FIXED_ASSETS_CODE, Boolean.valueOf(false));
            entity.setCode(code);
        }
        Calendar calendar = Calendar.getInstance();
        if (null != entity.getInDate()) {
            calendar.setTime(entity.getInDate());
            entity.setInYear(calendar.get(1));
        }
        String companyId = userInfo.getOrganizeId();
        entity.setCompanyId(companyId);
        this.save(entity);
        String newValue = JsonUtil.getObjectToString((Object)entity);
        String description = userInfo.getUserName() + "\u5165\u5e93\u4e86" + entity.getName();
        this.ofFixedAssetsLogsService.create(mainId, newValue, null, description, userInfo.getUserId(), new Date());
    }

    @Override
    @DSTransactional
    public String updateBatchOut(String[] ids, OfFixedAssetsBatchForm ofFixedAssetsBatchForm) {
        UserInfo userInfo = this.userProvider.get();
        String operationDesc = "\u6279\u91cf\u64cd\u4f5c#{operation}\u4e86#{num}\u6761\u8d44\u4ea7";
        if (EnabledMarkEnum.ZY.getMark().equals(ofFixedAssetsBatchForm.getEnabledMark())) {
            operationDesc = operationDesc.replace("#{operation}", "\u9886\u7528");
        } else if (EnabledMarkEnum.JYZ.getMark().equals(ofFixedAssetsBatchForm.getEnabledMark())) {
            operationDesc = operationDesc.replace("#{operation}", "\u501f\u7528");
        } else if (EnabledMarkEnum.BF.getMark().equals(ofFixedAssetsBatchForm.getEnabledMark())) {
            operationDesc = operationDesc.replace("#{operation}", "\u62a5\u5e9f");
        }
        List<String> idList = Arrays.asList(ids);
        List ofFixedAssetsEntities = this.listByIds(idList);
        if (CollectionUtil.isNotEmpty((Collection)ofFixedAssetsEntities)) {
            OfFixedAssetsEntity subentity = (OfFixedAssetsEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsBatchForm, OfFixedAssetsEntity.class);
            this.dealIsCustomUser(subentity);
            String baseUserName = this.getUserName(subentity);
            ArrayList assetsEntities = new ArrayList();
            ArrayList logsEntities = new ArrayList();
            ofFixedAssetsEntities.stream().forEach(item -> {
                if (!ObjectUtil.isEmpty((Object)item)) {
                    String oldValue = JsonUtil.getObjectToString((Object)item);
                    OfFixedAssetsEntity newEntity = new OfFixedAssetsEntity();
                    BeanUtils.copyProperties((Object)item, (Object)newEntity);
                    newEntity.setEnabledMark(subentity.getEnabledMark());
                    newEntity.setBasSpaceId(subentity.getBasSpaceId());
                    newEntity.setBaseOrganizeId(subentity.getBaseOrganizeId());
                    newEntity.setBaseOrganizeName(subentity.getBaseOrganizeName());
                    newEntity.setBaseUserId(subentity.getBaseUserId());
                    newEntity.setBaseUserName(subentity.getBaseUserName());
                    newEntity.setIsCustomUser(subentity.getIsCustomUser());
                    newEntity.setBorrowCase(subentity.getBorrowCase());
                    newEntity.setBorrowDate(subentity.getBorrowDate());
                    newEntity.setReturnDate(subentity.getReturnDate());
                    if (EnabledMarkEnum.KC.getMark().equals(item.getEnabledMark())) {
                        assetsEntities.add(newEntity);
                        String description = userInfo.getUserName() + "\u66f4\u65b0\u4e86" + item.getName();
                        if (EnabledMarkEnum.ZY.getMark().equals(subentity.getEnabledMark())) {
                            description = baseUserName + "\u9886\u7528\u4e86" + item.getName();
                        } else if (EnabledMarkEnum.JYZ.getMark().equals(subentity.getEnabledMark())) {
                            description = baseUserName + "\u501f\u7528\u4e86" + item.getName();
                        } else if (EnabledMarkEnum.BF.getMark().equals(subentity.getEnabledMark())) {
                            description = userInfo.getUserName() + "\u8bbe\u7f6e\u8d44\u4ea7\u72b6\u6001\u4e3a\u62a5\u5e9f: " + ofFixedAssetsBatchForm.getBfremark();
                        }
                        String newValue = JsonUtil.getObjectToString((Object)newEntity);
                        OfFixedAssetsLogsEntity entity = this.ofFixedAssetsLogsService.getEntity(newEntity.getId(), newValue, oldValue, description, userInfo.getUserId(), new Date());
                        logsEntities.add(entity);
                    }
                }
            });
            if (this.updateBatchById(assetsEntities)) {
                this.ofFixedAssetsLogsService.saveBatch(logsEntities);
                operationDesc = operationDesc.replace("#{num}", String.valueOf(assetsEntities.size()));
            }
        } else {
            operationDesc = operationDesc.replace("#{num}", "0");
        }
        return operationDesc;
    }

    @Override
    @DSTransactional
    public void update(String id, OfFixedAssetsEntity entity, OfFixedAssetsUpForm ofFixedAssetsUpForm) {
        UserInfo userInfo = this.userProvider.get();
        OfFixedAssetsEntity subentity = (OfFixedAssetsEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsUpForm, OfFixedAssetsEntity.class);
        String description = userInfo.getUserName() + "\u66f4\u65b0\u4e86" + entity.getName();
        this.dealIsCustomUser(subentity);
        String baseUserName = this.getUserName(subentity);
        if (DataStateEnum.ZC.getState().equals(entity.getDataState()) || StringUtils.isEmpty((String)entity.getDataState())) {
            subentity.setDataState(DataStateEnum.QR.getState());
            description = userInfo.getUserName() + "\u786e\u8ba4\u4e86\u8d44\u4ea7\u4fe1\u606f";
        } else {
            if (EnabledMarkEnum.ZY.getMark().equals(subentity.getEnabledMark())) {
                description = baseUserName + "\u9886\u7528\u4e86" + entity.getName();
            }
            if (EnabledMarkEnum.BF.getMark().equals(subentity.getEnabledMark())) {
                description = userInfo.getUserName() + "\u8bbe\u7f6e\u8d44\u4ea7\u72b6\u6001\u4e3a\u62a5\u5e9f: " + ofFixedAssetsUpForm.getBfremark();
            }
        }
        subentity.setId(id);
        Calendar calendar = Calendar.getInstance();
        if (null != subentity.getInDate()) {
            calendar.setTime(subentity.getInDate());
            subentity.setInYear(calendar.get(1));
        }
        if (this.updateById(subentity)) {
            String oldValue = JsonUtil.getObjectToString((Object)entity);
            BeanUtils.copyProperties((Object)subentity, (Object)entity);
            String newValue = JsonUtil.getObjectToString((Object)entity);
            this.ofFixedAssetsLogsService.create(id, newValue, oldValue, description, userInfo.getUserId(), new Date());
        }
    }

    @Override
    @DSTransactional
    public void updateByGiveBack(String id, OfFixedAssetsEntity entity, OfFixedAssetsUpForm ofFixedAssetsUpForm) {
        UserInfo userInfo = this.userProvider.get();
        String baseUserName = this.getUserName(entity);
        String enabledMark = entity.getEnabledMark();
        OfFixedAssetsEntity subentity = (OfFixedAssetsEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsUpForm, OfFixedAssetsEntity.class);
        subentity.setBaseUserId("");
        subentity.setBaseUserName("");
        subentity.setBaseOrganizeName("");
        subentity.setIsCustomUser("");
        subentity.setBorrowDate(null);
        subentity.setReturnDate(null);
        subentity.setBorrowCase("");
        if (this.updateById(subentity)) {
            String basSpaceName = StrUtil.isBlank((CharSequence)subentity.getBasSpaceId()) ? "" : ((BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)subentity.getBasSpaceId()))).getTreeNames();
            String description = baseUserName + "\u9000\u8fd8\u4e86" + entity.getName() + "\uff0c\u5b58\u653e\u4e8e" + basSpaceName;
            if (EnabledMarkEnum.JYZ.getMark().equals(enabledMark)) {
                description = description.replace("\u9000\u8fd8", "\u5f52\u8fd8");
            }
            String oldValue = JsonUtil.getObjectToString((Object)entity);
            BeanUtils.copyProperties((Object)subentity, (Object)entity);
            String newValue = JsonUtil.getObjectToString((Object)entity);
            this.ofFixedAssetsLogsService.create(id, newValue, oldValue, description, userInfo.getUserId(), new Date());
        }
    }

    @Override
    @DSTransactional
    public void updateUser(String id, OfFixedAssetsEntity entity, OfFixedAssetsUpForm ofFixedAssetsUpForm) {
        UserInfo userInfo = this.userProvider.get();
        OfFixedAssetsEntity subentity = (OfFixedAssetsEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsUpForm, OfFixedAssetsEntity.class);
        this.dealIsCustomUser(subentity);
        String baseUserName = this.getUserName(subentity);
        if (this.updateById(subentity)) {
            String description = userInfo.getUserName() + "\u53d8\u66f4\u4e86\u9886\u7528\u4fe1\u606f\uff0c\u9886\u7528\u4eba\u4e3a" + baseUserName;
            if (EnabledMarkEnum.JYZ.getMark().equals(subentity.getEnabledMark())) {
                description = description.replace("\u9886\u7528", "\u501f\u7528");
            }
            String oldValue = JsonUtil.getObjectToString((Object)entity);
            BeanUtils.copyProperties((Object)subentity, (Object)entity);
            String newValue = JsonUtil.getObjectToString((Object)entity);
            this.ofFixedAssetsLogsService.create(id, newValue, oldValue, description, userInfo.getUserId(), new Date());
        }
    }

    @Override
    @DSTransactional
    public void updateBorrow(String id, OfFixedAssetsEntity entity, OfFixedAssetsUpForm ofFixedAssetsUpForm) {
        UserInfo userInfo = this.userProvider.get();
        String description = "";
        OfFixedAssetsEntity subentity = (OfFixedAssetsEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsUpForm, OfFixedAssetsEntity.class);
        this.dealIsCustomUser(subentity);
        String baseUserName = this.getUserName(subentity);
        if (EnabledMarkEnum.JYZ.getMark().equals(subentity.getEnabledMark())) {
            description = baseUserName + "\u501f\u7528\u4e86" + entity.getName();
        }
        if (this.updateById(subentity)) {
            String oldValue = JsonUtil.getObjectToString((Object)entity);
            BeanUtils.copyProperties((Object)subentity, (Object)entity);
            String newValue = JsonUtil.getObjectToString((Object)entity);
            this.ofFixedAssetsLogsService.create(id, newValue, oldValue, description, userInfo.getUserId(), new Date());
        }
    }

    @Override
    @DSTransactional
    public void updateByBinding(String id, OfFixedAssetsEntity entity, OfFixedAssetsUpForm ofFixedAssetsUpForm) {
        String rfidCode;
        UserInfo userInfo = this.userProvider.get();
        OfFixedAssetsEntity subentity = (OfFixedAssetsEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsUpForm, OfFixedAssetsEntity.class);
        String rfidDecode = subentity.getRfidDecode();
        rfidDecode = rfidDecode.replaceAll(" ", "");
        String[] rfidArr = rfidDecode.split(",");
        rfidDecode = rfidCode = "";
        if (rfidArr != null && rfidArr.length > 0) {
            for (int i = 0; i < rfidArr.length; ++i) {
                String s = rfidArr[i];
                if (i >= 4) continue;
                if (StringUtils.isNotEmpty((String)s)) {
                    rfidDecode = rfidDecode + s;
                    rfidCode = rfidCode + HexUtil.encodeHexStr((String)s, (Charset)CharsetUtil.CHARSET_UTF_8).toUpperCase();
                }
                if (i == rfidArr.length - 1 || i >= 3) continue;
                rfidDecode = rfidDecode + ",";
                rfidCode = rfidCode + ",";
            }
        }
        subentity.setRfidCode(rfidCode);
        subentity.setRfidDecode(rfidDecode);
        subentity.setId(id);
        if (!this.checkRfidCodeUnique(subentity)) {
            throw new ValidationException(rfidDecode + "\u7ed1\u5b9a\u5931\u8d25\uff0c\u5df2\u5b58\u5728");
        }
        if (this.updateById(subentity)) {
            String description = userInfo.getUserName() + "\u7ed1\u5b9a\u4e86\u7535\u5b50\u6807\u7b7e";
            String oldValue = JsonUtil.getObjectToString((Object)entity);
            BeanUtils.copyProperties((Object)subentity, (Object)entity);
            String newValue = JsonUtil.getObjectToString((Object)entity);
            this.ofFixedAssetsLogsService.create(id, newValue, oldValue, description, userInfo.getUserId(), new Date());
        }
    }

    @Override
    @DSTransactional
    public void updateByResetRfid(String id, OfFixedAssetsEntity entity) {
        UserInfo userInfo = this.userProvider.get();
        String rfidDecode = entity.getRfidDecode();
        OfFixedAssetsEntity subentity = (OfFixedAssetsEntity)JsonUtil.getJsonToBean((Object)entity, OfFixedAssetsEntity.class);
        subentity.setRfidCode("");
        subentity.setRfidDecode("");
        if (this.updateById(subentity)) {
            String description = userInfo.getUserName() + "\u89e3\u7ed1\u4e86rfid\u7535\u5b50\u6807\u7b7e" + rfidDecode;
            String oldValue = JsonUtil.getObjectToString((Object)entity);
            BeanUtils.copyProperties((Object)subentity, (Object)entity);
            String newValue = JsonUtil.getObjectToString((Object)entity);
            this.ofFixedAssetsLogsService.create(id, newValue, oldValue, description, userInfo.getUserId(), new Date());
        }
    }

    @Override
    @DSTransactional
    public void updateByUploadPhotos(String id, OfFixedAssetsEntity entity, OfFixedAssetsUpForm ofFixedAssetsUpForm) {
        UserInfo userInfo = this.userProvider.get();
        OfFixedAssetsEntity subentity = (OfFixedAssetsEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsUpForm, OfFixedAssetsEntity.class);
        if (this.updateById(subentity)) {
            String description = userInfo.getUserName() + "\u4e0a\u4f20\u4e86\u7269\u54c1\u56fe\u7247";
            String oldValue = JsonUtil.getObjectToString((Object)entity);
            BeanUtils.copyProperties((Object)subentity, (Object)entity);
            String newValue = JsonUtil.getObjectToString((Object)entity);
            this.ofFixedAssetsLogsService.create(id, newValue, oldValue, description, userInfo.getUserId(), new Date());
        }
    }

    @Override
    @DSTransactional
    public void updateByBatchAffirm(List<OfFixedAssetsEntity> list) {
        UserInfo userInfo = this.userProvider.get();
        if (CollectionUtil.isNotEmpty(list)) {
            ArrayList<OfFixedAssetsEntity> assetsList = new ArrayList<OfFixedAssetsEntity>();
            ArrayList<OfFixedAssetsLogsEntity> assetsLogList = new ArrayList<OfFixedAssetsLogsEntity>();
            for (OfFixedAssetsEntity item : list) {
                if (!ObjectUtil.isNotEmpty((Object)item)) continue;
                OfFixedAssetsEntity subentity = (OfFixedAssetsEntity)JsonUtil.getJsonToBean((Object)item, OfFixedAssetsEntity.class);
                if (!DataStateEnum.ZC.getState().equals(subentity.getDataState()) && !StringUtils.isEmpty((String)subentity.getDataState())) continue;
                subentity.setDataState(DataStateEnum.QR.getState());
                assetsList.add(subentity);
                String oldValue = JsonUtil.getObjectToString((Object)item);
                BeanUtils.copyProperties((Object)subentity, (Object)item);
                String newValue = JsonUtil.getObjectToString((Object)item);
                String description = userInfo.getUserName() + "\u786e\u8ba4\u4e86\u8d44\u4ea7\u4fe1\u606f";
                OfFixedAssetsLogsEntity entity = this.ofFixedAssetsLogsService.getEntity(subentity.getId(), newValue, oldValue, description, userInfo.getUserId(), new Date());
                assetsLogList.add(entity);
            }
            if (this.updateBatchById(assetsList)) {
                this.ofFixedAssetsLogsService.saveBatch(assetsLogList);
            }
        }
    }

    @Override
    @DSTransactional
    public void delete(OfFixedAssetsEntity entity) {
        UserInfo userInfo = this.userProvider.get();
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public boolean checkCodeUnique(String code, String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(OfFixedAssetsEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        queryWrapper.eq(OfFixedAssetsEntity::getCode, (Object)code);
        queryWrapper.last("limit 1");
        OfFixedAssetsEntity entity = (OfFixedAssetsEntity)this.getOne((Wrapper)queryWrapper);
        return !ObjectUtil.isNotNull((Object)entity) || !StringUtils.isEmpty((String)id) && entity.getId().equals(id);
    }

    @Override
    public boolean checkRfidCodeUnique(OfFixedAssetsEntity subentity) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(OfFixedAssetsEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        queryWrapper.like(OfFixedAssetsEntity::getRfidCode, (Object)subentity.getRfidCode());
        queryWrapper.last("limit 1");
        OfFixedAssetsEntity entity = (OfFixedAssetsEntity)this.getOne((Wrapper)queryWrapper);
        return !ObjectUtil.isNotNull((Object)entity) || entity.getId().equals(subentity.getId());
    }

    @Override
    public long selectAssetsBySpaceIdCount(String spaceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getBasSpaceId, (Object)spaceId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public long selectAssetsCount(OfFixedAssetsPagination pagination) {
        Object ofFixedAssetsObj;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return 0L;
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return 0L;
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        queryWrapper.lambda().ne(OfFixedAssetsEntity::getEnabledMark, (Object)EnabledMarkEnum.BF.getMark());
        if (StringUtils.isNotEmpty((String)pagination.getInventoryWay())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getInventoryWay, (Object)pagination.getInventoryWay());
        }
        if (StringUtils.isNotEmpty((String)pagination.getFixedAssetsTypeId()) && StringUtils.isNotEmpty((String)pagination.getFixedAssetsTypeId())) {
            ArrayList<String> listTreeId = new ArrayList<String>();
            listTreeId.add(pagination.getFixedAssetsTypeId());
            listTreeId.addAll(this.ofFixedAssetsTypeService.getListTreeId(pagination.getFixedAssetsTypeId()));
            queryWrapper.lambda().in(OfFixedAssetsEntity::getFixedAssetsTypeId, listTreeId);
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getFixedAssetsTypeIds()) && pagination.getFixedAssetsTypeIds().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getFixedAssetsTypeId, (Object[])pagination.getFixedAssetsTypeIds());
        }
        if (StringUtils.isNotEmpty((Object[])pagination.getBasSpaceIds())) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getBasSpaceId, (Object[])pagination.getBasSpaceIds());
        }
        if (StringUtils.isNotEmpty((String)pagination.getBasSpaceId())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getBasSpaceId, (Object)pagination.getBasSpaceId());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getAssetsNames()) && pagination.getAssetsNames().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getName, (Object[])pagination.getAssetsNames());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCompanyId()) && !"1".equals(pagination.getCompanyId())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getCompanyId, (Object)pagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getIsFixedAssets())) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getIsFixedAssets, (Object)pagination.getIsFixedAssets());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getAssetsSorts()) && pagination.getAssetsSorts().length > 0) {
            queryWrapper.lambda().in(OfFixedAssetsEntity::getIsFixedAssets, (Object[])pagination.getAssetsSorts());
        }
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public long selectAssetsBindingRfidCount(String menuId, String companyId, String isFixedAssets) {
        Object ofFixedAssetsObj;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return 0L;
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return 0L;
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        if (StringUtils.isNotEmpty((String)companyId) && !"1".equals(companyId)) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getCompanyId, (Object)companyId);
        }
        if (StringUtils.isNotEmpty((String)isFixedAssets)) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getIsFixedAssets, (Object)isFixedAssets);
        }
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        queryWrapper.lambda().ne(OfFixedAssetsEntity::getEnabledMark, (Object)EnabledMarkEnum.BF.getMark());
        queryWrapper.lambda().isNotNull(OfFixedAssetsEntity::getRfidCode);
        queryWrapper.lambda().ne(OfFixedAssetsEntity::getRfidCode, (Object)"");
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public List<OfFixedAssetsEntity> selectAssetsBorrowExpire(String menuId, String companyId, String isFixedAssets, boolean isTask) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!isTask) {
            Object ofFixedAssetsObj;
            boolean pcPermission = true;
            boolean appPermission = true;
            boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
            if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
                ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "of_fixed_assets"));
                if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                    return new ArrayList<OfFixedAssetsEntity>();
                }
                queryWrapper = (QueryWrapper)ofFixedAssetsObj;
            }
            if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
                ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "of_fixed_assets"));
                if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                    return new ArrayList<OfFixedAssetsEntity>();
                }
                queryWrapper = (QueryWrapper)ofFixedAssetsObj;
            }
        }
        if (StringUtils.isNotEmpty((String)companyId) && !"1".equals(companyId)) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getCompanyId, (Object)companyId);
        }
        if (StringUtils.isNotEmpty((String)isFixedAssets)) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getIsFixedAssets, (Object)isFixedAssets);
        }
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getEnabledMark, (Object)EnabledMarkEnum.JYZ.getMark());
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        queryWrapper.lambda().isNotNull(OfFixedAssetsEntity::getReturnDate);
        queryWrapper.lambda().ne(OfFixedAssetsEntity::getReturnDate, (Object)"");
        queryWrapper.lambda().le(OfFixedAssetsEntity::getReturnDate, (Object)DateUtil.dateAddDays(null, (int)3));
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public double selectAssetsPriceSum(String menuId, String companyId, String isFixedAssets) {
        Object ofFixedAssetsObj;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{" IFNULL(sum(unit_price),0) as sumPrice"});
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return 0.0;
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return 0.0;
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        if (StringUtils.isNotEmpty((String)companyId) && !"1".equals(companyId)) {
            queryWrapper.eq((Object)"company_id", (Object)companyId);
        }
        if (StringUtils.isNotEmpty((String)isFixedAssets)) {
            queryWrapper.eq((Object)"is_fixed_assets", (Object)isFixedAssets);
        }
        queryWrapper.eq((Object)"delete_mark", (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        queryWrapper.ne((Object)"enabled_mark", (Object)EnabledMarkEnum.BF.getMark());
        Map map = this.getMap((Wrapper)queryWrapper);
        return (Double)map.get("sumPrice");
    }

    @Override
    public int selectAssetsQuantitySum(String menuId, String companyId, String isFixedAssets) {
        Object ofFixedAssetsObj;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{" IFNULL(sum(quantity),0) as squantity"});
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return 0;
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return 0;
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        if (StringUtils.isNotEmpty((String)companyId) && !"1".equals(companyId)) {
            queryWrapper.eq((Object)"company_id", (Object)companyId);
        }
        if (StringUtils.isNotEmpty((String)isFixedAssets)) {
            queryWrapper.eq((Object)"is_fixed_assets", (Object)isFixedAssets);
        }
        queryWrapper.eq((Object)"delete_mark", (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        queryWrapper.ne((Object)"enabled_mark", (Object)EnabledMarkEnum.BF.getMark());
        Map map = this.getMap((Wrapper)queryWrapper);
        return Integer.parseInt(String.valueOf(map.get("squantity")));
    }

    @Override
    public List<Map<String, Object>> selectPriceSumGroupBySpace(String menuId, String companyId, String isFixedAssets) {
        Object ofFixedAssetsObj;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<Map<String, Object>>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<Map<String, Object>>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        queryWrapper.lambda().ne(OfFixedAssetsEntity::getEnabledMark, (Object)EnabledMarkEnum.BF.getMark());
        if (StringUtils.isNotEmpty((String)companyId) && !"1".equals(companyId)) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getCompanyId, (Object)companyId);
        }
        if (StringUtils.isNotEmpty((String)isFixedAssets)) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getIsFixedAssets, (Object)isFixedAssets);
        }
        return this.ofFixedAssetsMapper.selectPriceSumGroupBySpace((Wrapper)queryWrapper);
    }

    @Override
    public List<Map<String, Object>> selectEmployeeAssets(String currUserId, String menuId) {
        Object ofFixedAssetsObj;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<Map<String, Object>>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<Map<String, Object>>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getBaseUserId, (Object)currUserId);
        return this.ofFixedAssetsMapper.selectEmployeeAssets((Wrapper)queryWrapper);
    }

    @Override
    public List<Map<String, Object>> selectNumGroupBySpace(String menuId, String companyId, String isFixedAssets) {
        Object ofFixedAssetsObj;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<Map<String, Object>>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<Map<String, Object>>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        if (StringUtils.isNotEmpty((String)companyId) && !"1".equals(companyId)) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getCompanyId, (Object)companyId);
        }
        if (StringUtils.isNotEmpty((String)isFixedAssets)) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getIsFixedAssets, (Object)isFixedAssets);
        }
        queryWrapper.setParamAlias("a");
        return this.ofFixedAssetsMapper.selectNumGroupBySpace((Wrapper)queryWrapper);
    }

    @Override
    public List<Map<String, Object>> selectGroupByEnabledMark(String menuId, String companyId, String isFixedAssets) {
        Object ofFixedAssetsObj;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<Map<String, Object>>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, menuId, "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsObj)) {
                return new ArrayList<Map<String, Object>>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsObj;
        }
        if (StringUtils.isNotEmpty((String)companyId) && !"1".equals(companyId)) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getCompanyId, (Object)companyId);
        }
        if (StringUtils.isNotEmpty((String)isFixedAssets)) {
            queryWrapper.lambda().eq(OfFixedAssetsEntity::getIsFixedAssets, (Object)isFixedAssets);
        }
        queryWrapper.lambda().eq(OfFixedAssetsEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDelete());
        return this.ofFixedAssetsMapper.selectGroupByEnabledMark((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, Object> importPreview(List<OfFixedAssetsImportModel> personList) {
        ArrayList dataRow = new ArrayList();
        ArrayList columns = new ArrayList();
        if (personList != null) {
            int i;
            for (i = 0; i < personList.size(); ++i) {
                HashMap<String, Object> dataRowMap = new HashMap<String, Object>();
                OfFixedAssetsImportModel model = personList.get(i);
                dataRowMap.put("access", model.getAccess());
                dataRowMap.put("isFixedAssets", model.getIsFixedAssets());
                dataRowMap.put("inventoryWay", model.getInventoryWay());
                dataRowMap.put("code", model.getCode());
                dataRowMap.put("name", model.getName());
                dataRowMap.put("fixedAssetsTypeId", model.getFixedAssetsTypeId());
                dataRowMap.put("unitPrice", model.getUnitPrice());
                dataRowMap.put("basSpaceId", model.getBasSpaceId());
                dataRowMap.put("inDate", ObjectUtil.isNotEmpty((Object)model.getInDate()) ? DateUtil.daFormat((Date)model.getInDate()) : null);
                dataRowMap.put("brand", model.getBrand());
                dataRowMap.put("modelNumber", model.getModelNumber());
                dataRowMap.put("description", model.getDescription());
                dataRowMap.put("enabledMark", model.getEnabledMark());
                dataRowMap.put("enableDate", ObjectUtil.isNotEmpty((Object)model.getEnableDate()) ? DateUtil.daFormat((Date)model.getEnableDate()) : null);
                dataRowMap.put("baseOrganizeName", model.getBaseOrganizeName());
                dataRowMap.put("baseUserName", model.getBaseUserName());
                dataRowMap.put("rfidCode", model.getRfidCode());
                dataRowMap.put("remark", model.getRemark());
                dataRowMap.put("projectName", model.getProjectName());
                dataRowMap.put("quantity", model.getQuantity());
                dataRowMap.put("unit", model.getUnit());
                dataRowMap.put("labelCase", model.getLabelCase());
                dataRowMap.put("borrowCase", model.getBorrowCase());
                dataRow.add(dataRowMap);
            }
            for (i = 1; i < 7; ++i) {
                HashMap<String, Object> columnsMap = new HashMap<String, Object>();
                columnsMap.put("AllowDBNull", true);
                columnsMap.put("AutoIncrement", false);
                columnsMap.put("AutoIncrementSeed", 0);
                columnsMap.put("AutoIncrementStep", 1);
                columnsMap.put("Caption", this.getColumns(i));
                columnsMap.put("ColumnMapping", 1);
                columnsMap.put("ColumnName", this.getColumns(i));
                columnsMap.put("Container", null);
                columnsMap.put("DataType", "System.String, mscorlib, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b77a5c561934e089");
                columnsMap.put("DateTimeMode", 3);
                columnsMap.put("DefaultValue", null);
                columnsMap.put("DesignMode", false);
                columnsMap.put("Expression", "");
                columnsMap.put("ExtendedProperties", "");
                columnsMap.put("MaxLength", -1);
                columnsMap.put("Namespace", "");
                columnsMap.put("Ordinal", 0);
                columnsMap.put("Prefix", "");
                columnsMap.put("ReadOnly", false);
                columnsMap.put("Site", null);
                columnsMap.put("Table", personList);
                columnsMap.put("Unique", false);
                columns.add(columnsMap);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataRow", dataRow);
        map.put("columns", columns);
        return map;
    }

    @Override
    public OfFixedAssetsImportVO importData(List<OfFixedAssetsImportModel> dt, String menuId) throws Exception {
        UserInfo userInfo = this.userProvider.get();
        List codes = this.listObjs((Wrapper)new QueryWrapper().lambda().select(new SFunction[]{OfFixedAssetsEntity::getCode}), Object::toString);
        HashSet<String> codeSet = new HashSet<String>(codes);
        Map<String, String> assetTypeMap = this.ofFixedAssetsTypeService.getAssetsTypeCache("-1", menuId);
        Map basSpaceMap = this.basSpaceService.getBasSpaceCache("-1", menuId);
        List sorts = this.dictionaryDataService.getList(Constants.DICTIONARY_SORT);
        HashMap<String, String> sortMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)sorts)) {
            for (DictionaryDataEntity dict : sorts) {
                sortMap.put(dict.getFullName(), dict.getEnCode());
            }
        }
        List accesss = this.dictionaryDataService.getList(Constants.DICTIONARY_ACCESS);
        HashMap<String, String> accessMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)accesss)) {
            for (DictionaryDataEntity dict : accesss) {
                accessMap.put(dict.getFullName(), dict.getEnCode());
            }
        }
        List states = this.dictionaryDataService.getList(Constants.DICTIONARY_TYPE);
        HashMap<String, String> stateMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)states)) {
            for (DictionaryDataEntity dict : states) {
                stateMap.put(dict.getFullName(), dict.getEnCode());
            }
        }
        Map<String, String> organizeMap = this.getOrganizeCache();
        List userList = this.userService.getList();
        HashMap<String, String> organizeUserMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            for (UserEntity user : userList) {
                organizeUserMap.put(user.getOrganizeId() + user.getRealName(), user.getId());
            }
        }
        int sum = 0;
        int num = 0;
        ArrayList<OfFixedAssetsImportModel> errList = new ArrayList<OfFixedAssetsImportModel>();
        for (OfFixedAssetsImportModel model : dt) {
            try {
                this.validateImportData(model, codeSet, assetTypeMap, basSpaceMap, stateMap, organizeMap, organizeUserMap, sortMap, accessMap);
                OfFixedAssetsEntity entity = (OfFixedAssetsEntity)JsonUtil.getJsonToBean((Object)((Object)model), OfFixedAssetsEntity.class);
                entity.setId(RandomUtil.uuId());
                entity.setEnabledMark(EnabledMarkEnum.KC.getMark());
                entity.setDataState(DataStateEnum.ZC.getState());
                entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getDelete());
                entity.setCreatorUserId(this.userProvider.get().getUserId());
                entity.setCreatorTime(new Date());
                String inventoryWay = entity.getInventoryWay();
                if (StringUtils.isNotEmpty((String)inventoryWay) && "\u5426".equals(inventoryWay)) {
                    entity.setInventoryWay(InventoryWayEnum.NO.getMark());
                } else {
                    entity.setInventoryWay(InventoryWayEnum.YES.getMark());
                }
                String companyId = userInfo.getOrganizeId();
                entity.setCompanyId(companyId);
                ((OfFixedAssetsMapper)this.baseMapper).insert(entity);
                String newValue = JsonUtil.getObjectToString((Object)entity);
                String description = userInfo.getUserName() + "\u5165\u5e93\u4e86" + entity.getName();
                this.ofFixedAssetsLogsService.create(entity.getId(), newValue, null, description, userInfo.getUserId(), new Date());
                ++sum;
            }
            catch (ExcelValidationException e) {
                this.log.error("\u5bfc\u5165\u7b2c" + (num + 1) + "\u6761\u6570\u636e\u5931\u8d25");
                int index = 0;
                int size = e.getErrorMessages().size();
                StringBuilder em = new StringBuilder();
                for (Map.Entry<String, String> error : e.getErrorMessages().entrySet()) {
                    em.append(error.getKey()).append(" : ").append(error.getValue());
                    if (index != size - 1) {
                        em.append("\n");
                    }
                    ++index;
                }
                model.setErrorMessage(em.toString());
                this.log.error(model.getErrorMessage());
                errList.add(model);
                ++num;
            }
            catch (Exception e) {
                this.log.error("\u5bfc\u5165\u7b2c" + (num + 1) + "\u6761\u6570\u636e\u5931\u8d25");
                model.setErrorMessage(e.toString());
                errList.add(model);
                ++num;
            }
        }
        OfFixedAssetsImportVO vo = new OfFixedAssetsImportVO();
        vo.setSnum(sum);
        vo.setFnum(num);
        if (vo.getFnum() > 0) {
            vo.setResultType(1);
            vo.setFailResult(JsonUtil.getJsonToList(errList, OfFixedAssetsImportModel.class));
            return vo;
        }
        vo.setResultType(0);
        return vo;
    }

    public void validateImportData(OfFixedAssetsImportModel model, HashSet<String> codeSet, Map<String, String> assetTypeMap) {
        this.validateImportData(model, codeSet, assetTypeMap, null, null, null, null, null, null);
    }

    public void validateImportData(OfFixedAssetsImportModel model, HashSet<String> codeSet, Map<String, String> assetTypeMap, Map<String, String> basSpaceMap, Map<String, String> stateMap, Map<String, String> organizeMap, Map<String, String> organizeUserMap, Map<String, String> sortMap, Map<String, String> accessMap) throws ExcelValidationException {
        String baseUserRealName;
        String baseOrganizeName;
        String access;
        String enabledMark;
        String fixedAssetsTypeId;
        HashMap<String, String> errorMessages = new HashMap<String, String>();
        String code = StringUtils.trim((String)model.getCode());
        if (StringUtils.isEmpty((String)code)) {
            errorMessages.put("\u8d44\u4ea7\u7f16\u7801", "isNull");
        } else if (codeSet.contains(code)) {
            errorMessages.put("\u8d44\u4ea7\u7f16\u7801", "\u8d44\u4ea7\u7f16\u7801\u5728(\u5168\u5c40)\u53f0\u8d26\u4e2d\u5df2\u5b58\u5728\u6216\u5bfc\u5165\u6570\u636e\u5b58\u5728\u91cd\u590d" + code);
        } else {
            codeSet.add(code);
        }
        String name = model.getName();
        if (StringUtils.isEmpty((String)name)) {
            errorMessages.put("\u8d44\u4ea7\u540d\u79f0", "isNull");
        }
        if (StringUtils.isNotEmpty((String)(fixedAssetsTypeId = model.getFixedAssetsTypeId()))) {
            if (assetTypeMap.containsKey(fixedAssetsTypeId = fixedAssetsTypeId.replaceAll("/", ""))) {
                model.setFixedAssetsTypeId(assetTypeMap.get(fixedAssetsTypeId));
            } else {
                errorMessages.put("\u8d44\u4ea7\u7c7b\u578b", "\u4e3a\u7a7a\u6216\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u672a\u6307\u5b9a\u672b\u7ea7" + fixedAssetsTypeId);
            }
        } else {
            errorMessages.put("\u8d44\u4ea7\u7c7b\u578b", "isNull");
        }
        String modelNumber = model.getModelNumber();
        if (basSpaceMap != null && !basSpaceMap.isEmpty()) {
            String basSpaceId = model.getBasSpaceId();
            if (StringUtils.isNotEmpty((String)basSpaceId)) {
                if (basSpaceMap.containsKey(basSpaceId = basSpaceId.replaceAll("/", ""))) {
                    model.setBasSpaceId(basSpaceMap.get(basSpaceId));
                } else {
                    errorMessages.put("\u6240\u5c5e\u7a7a\u95f4", "\u4e3a\u7a7a\u6216\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u672a\u6307\u5b9a\u672b\u7ea7" + basSpaceId);
                }
            } else {
                errorMessages.put("\u6240\u5c5e\u7a7a\u95f4", "isNull");
            }
        }
        if (stateMap != null && !stateMap.isEmpty() && StringUtils.isNotEmpty((String)(enabledMark = model.getEnabledMark()))) {
            if (stateMap.containsKey(enabledMark)) {
                model.setEnabledMark(stateMap.get(enabledMark));
            } else {
                errorMessages.put("\u8d44\u4ea7\u72b6\u6001", "\u4e3a\u7a7a\u6216\u914d\u7f6e\u4e0d\u5b58\u5728" + enabledMark);
            }
        }
        if (sortMap != null && !sortMap.isEmpty()) {
            String isFixedAssets = model.getIsFixedAssets();
            if (StringUtils.isNotEmpty((String)isFixedAssets)) {
                if (sortMap.containsKey(isFixedAssets)) {
                    model.setIsFixedAssets(sortMap.get(isFixedAssets));
                } else {
                    errorMessages.put("\u53f0\u8d26\u5206\u7c7b", "\u4e3a\u7a7a\u6216\u914d\u7f6e\u4e0d\u5b58\u5728" + isFixedAssets);
                }
            } else {
                errorMessages.put("\u8d44\u4ea7\u72b6\u6001", "isEmpty");
            }
        }
        if (accessMap != null && !accessMap.isEmpty() && StringUtils.isNotEmpty((String)(access = model.getAccess()))) {
            if (accessMap.containsKey(access)) {
                model.setAccess(accessMap.get(access));
            } else {
                errorMessages.put("\u83b7\u53d6\u65b9\u5f0f", "\u4e3a\u7a7a\u6216\u914d\u7f6e\u4e0d\u5b58\u5728" + access);
            }
        }
        String baseOrganizeId = "";
        if (organizeMap != null && !organizeMap.isEmpty() && StringUtils.isNotEmpty((String)(baseOrganizeName = model.getBaseOrganizeName())) && organizeMap.containsKey(baseOrganizeName = baseOrganizeName.replaceAll("/", ""))) {
            baseOrganizeId = organizeMap.get(baseOrganizeName);
        }
        if (organizeUserMap != null && !organizeUserMap.isEmpty() && StringUtils.isNotEmpty((String)(baseUserRealName = model.getBaseUserName()))) {
            if (StringUtils.isNotEmpty((String)baseOrganizeId)) {
                String userKey = baseOrganizeId + baseUserRealName;
                if (organizeUserMap.containsKey(userKey)) {
                    model.setBaseUserId(organizeUserMap.get(userKey));
                }
            } else {
                List matchingKeys = organizeUserMap.keySet().stream().filter(key -> key.contains(baseUserRealName)).collect(Collectors.toList());
                if (matchingKeys != null && matchingKeys.size() != 0) {
                    model.setBaseUserId(organizeUserMap.get(matchingKeys.get(0)));
                }
            }
        }
        if (!errorMessages.isEmpty()) {
            throw new ExcelValidationException(errorMessages);
        }
    }

    public Map<String, String> getOrganizeCache() {
        HashMap<String, String> organizeMap = new HashMap<String, String>();
        List allList = this.organizeService.getList();
        List data = allList.stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());
        List models = JsonUtil.getJsonToList(data, OrganizeModel.class);
        if (!CollectionUtils.isEmpty((Collection)models)) {
            List trees = TreeDotUtils.convertListToTreeDotFilter((List)models);
            List listVO = JsonUtil.getJsonToList((Object)trees, OrganizeDepartSelectorListVO.class);
            this.recursionTree(listVO, organizeMap, "");
        }
        return organizeMap;
    }

    public void recursionTree(List<OrganizeDepartSelectorListVO> trees, Map<String, String> organizeMap, String key) {
        trees.stream().forEach(item -> {
            String childKey = key + item.getFullName();
            organizeMap.put(childKey, item.getId());
            List listChild = item.getChildren();
            if (CollectionUtils.isEmpty((Collection)listChild)) {
                return;
            }
            this.recursionTree(listChild, organizeMap, childKey);
        });
    }

    private OfFixedAssetsEntity dealIsCustomUser(OfFixedAssetsEntity subentity) {
        if (Constants.YES.equals(subentity.getIsCustomUser())) {
            subentity.setBaseUserId("");
        } else if (Constants.NO.equals(subentity.getIsCustomUser()) || StringUtils.isEmpty((String)subentity.getIsCustomUser())) {
            subentity.setIsCustomUser(Constants.NO);
            subentity.setBaseUserName("");
            subentity.setBaseOrganizeName("");
        }
        return subentity;
    }

    private String getUserName(OfFixedAssetsEntity entity) {
        StringBuilder baseUserName = new StringBuilder();
        if (Constants.YES.equals(entity.getIsCustomUser())) {
            if (StringUtils.isNotEmpty((String)entity.getBaseOrganizeName())) {
                baseUserName.append(entity.getBaseOrganizeName());
            }
            if (StringUtils.isNotEmpty((String)entity.getBaseUserName())) {
                baseUserName.append(entity.getBaseUserName());
            }
            baseUserName.append("(\u975e\u7cfb\u7edf\u7528\u6237)");
        } else if (Constants.NO.equals(entity.getIsCustomUser()) || StringUtils.isEmpty((String)entity.getIsCustomUser())) {
            baseUserName.append(this.baseDataUtil.userSelectValueNoAccount(entity.getBaseUserId()));
        }
        return baseUserName.toString();
    }

    private String getColumns(Integer key) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u8d44\u4ea7\u540d\u79f0");
        map.put(2, "\u8d44\u4ea7\u7c7b\u578b");
        map.put(3, "RFID\u7f16\u53f7");
        map.put(4, "\u6240\u5c5e\u7a7a\u95f4");
        map.put(5, "\u91c7\u8d2d\u65e5\u671f");
        map.put(6, "\u89c4\u683c\u63cf\u8ff0");
        return (String)map.get(key);
    }
}

