/*
 Navicat Premium Data Transfer

 Source Server         : 10.70.10.64_3306
 Source Server Type    : MySQL
 Source Server Version : 50724 (5.7.24)
 Source Host           : 10.70.10.64:3306
 Source Schema         : jsbos_manager

 Target Server Type    : MySQL
 Target Server Version : 50724 (5.7.24)
 File Encoding         : 65001

 Date: 25/07/2024 16:58:23
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for of_fixed_assets_type
-- ----------------------------
DROP TABLE IF EXISTS `of_fixed_assets_type`;
CREATE TABLE `of_fixed_assets_type`  (
  `id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '固定资产分类编码',
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '固定资产分类名称',
  `parent_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '父级固定资产分类ID',
  `sort_code` bigint(50) NULL DEFAULT NULL COMMENT '排序码',
  `description` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `parent_ids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '节点所有上级编码（快速检索下级节点）',
  `tree_names` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '节点的全名称（用“/”分隔，快速获取当前节点完整路径）',
  `enabled_mark` int(11) NULL DEFAULT NULL COMMENT '有效标志(0-禁用，1-启用)',
  `global_mark` int(11) NULL DEFAULT NULL COMMENT '全局标识,1:全局；2:组织。',
  `organize_tds_tree` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '所属组织',
  `company_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属公司',
  `creator_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建用户',
  `creator_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `last_modify_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改用户',
  `last_modify_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `delete_time` datetime NULL DEFAULT NULL COMMENT '删除时间',
  `delete_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除用户',
  `delete_mark` int(11) NULL DEFAULT NULL COMMENT '删除标志(0-正常，1-删除)',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '固定资产类型' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for of_fixed_assets_repair
-- ----------------------------
DROP TABLE IF EXISTS `of_fixed_assets_repair`;
CREATE TABLE `of_fixed_assets_repair`  (
  `id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `assets_id` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产台账ID(表of_fixed_assets主键ID)',
  `business_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '业务编号',
  `status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '办理状态(已完成;草稿;拒绝;审批中;取消。)',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '业务名称',
  `repair_status` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '维修状态(等待维修;维修中;维修结束。)',
  `type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '报修类型',
  `plan_finish_date` date NULL DEFAULT NULL COMMENT '计划完成日期',
  `actual_finish_date` date NULL DEFAULT NULL COMMENT '实际完成日期',
  `content` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '报修内容',
  `report_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '报修人',
  `report_user_name` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '报修人',
  `pictures` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '物品图片',
  `description` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `creator_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建用户',
  `creator_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `last_modify_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改用户',
  `last_modify_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `delete_mark` int(2) NULL DEFAULT 0 COMMENT '有效标志(0:正常 1:删除)',
  `delete_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除人ID',
  `delete_time` datetime NULL DEFAULT NULL COMMENT '删除时间',
  `version` int(11) NOT NULL DEFAULT 1 COMMENT '版本号',
  `company_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属公司',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '固定资产报修业务' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for of_fixed_assets_order_item
-- ----------------------------
DROP TABLE IF EXISTS `of_fixed_assets_order_item`;
CREATE TABLE `of_fixed_assets_order_item`  (
  `id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `fixed_assets_order_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '盘点表ID',
  `fixed_assets_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '固定资产ID',
  `fixed_assets_state` int(50) NULL DEFAULT NULL COMMENT '盘点状态：-1:待盘 0:正常 1:位置不符 8:盘盈 9:盘亏',
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产编码-二维码编码（冗余）',
  `rfid_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'rfid编码（冗余）',
  `rfid_decode` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'rfid解码',
  `fixed_assets_type_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产类型ID',
  `base_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产使用负责人(领用人)',
  `bas_space_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属空间ID（台账登记空间）',
  `bas_space_id_act` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '盘库所属空间ID（实际盘库空间）',
  `report_state` char(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '自主盘点状态，RS01:未开始; RS02:进行中; RS03:已完成。',
  `report_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '上报人ID',
  `report_time` datetime NULL DEFAULT NULL COMMENT '上报时间',
  `report_json` json NULL COMMENT '上报确认信息',
  `files` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '附件集合json',
  `action_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '处置方式：0:无需处置 1:变更所属空间  8:录入库存  9:下库',
  `description` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `company_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属公司',
  `creator_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建用户',
  `creator_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `last_modify_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改用户',
  `last_modify_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '固定资产盘点记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for of_fixed_assets_order
-- ----------------------------
DROP TABLE IF EXISTS `of_fixed_assets_order`;
CREATE TABLE `of_fixed_assets_order`  (
  `id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `order_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '盘点单编码',
  `order_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产盘点名称',
  `order_date` datetime NULL DEFAULT NULL COMMENT '计划盘点日期',
  `order_end_date` datetime NULL DEFAULT NULL COMMENT '计划结束日期',
  `assets_sorts` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '台账分类s',
  `fixed_assets_type_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '资产类型IDs',
  `bas_space_ids` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '计划盘点空间ids',
  `assets_names` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产名称（多选）',
  `order_sdate_act` datetime NULL DEFAULT NULL COMMENT '实际盘点开始时间',
  `order_edate_act` datetime NULL DEFAULT NULL COMMENT '实际盘点结束日期',
  `base_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '盘点人',
  `order_state` int(10) NULL DEFAULT NULL COMMENT '盘点状态 0：未开始  1：进行中 9：已完成',
  `description` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `company_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属公司',
  `creator_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建用户',
  `creator_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `last_modify_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改用户',
  `last_modify_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '固定资产盘点表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for of_fixed_assets_logs_inventory
-- ----------------------------
DROP TABLE IF EXISTS `of_fixed_assets_logs_inventory`;
CREATE TABLE `of_fixed_assets_logs_inventory`  (
  `id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键ID',
  `order_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '盘点计划ID',
  `item_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '待盘资产明细ID',
  `way` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '盘点方式(W01:PC端;W02:手机端;W03:RFID手持机;W04:自主盘点.)',
  `inventory_by_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '盘点人ID',
  `inventory_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '盘点人姓名',
  `inventory_time` datetime NULL DEFAULT NULL COMMENT '盘点时间',
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `company_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属公司',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '固定资产盘点日志' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for of_fixed_assets_logs
-- ----------------------------
DROP TABLE IF EXISTS `of_fixed_assets_logs`;
CREATE TABLE `of_fixed_assets_logs`  (
  `id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `fixed_assets_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '固定资产ID',
  `new_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '新值',
  `old_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '旧值',
  `description` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `company_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属公司',
  `creator_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建用户',
  `creator_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `last_modify_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改用户',
  `last_modify_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '固定资产台账日志' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for of_fixed_assets_depreciation
-- ----------------------------
DROP TABLE IF EXISTS `of_fixed_assets_depreciation`;
CREATE TABLE `of_fixed_assets_depreciation`  (
  `id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '编码',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '折旧方案名称',
  `depreciation_method` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '折旧方法,将应提折旧总额在固定资产各使用期间进行分配时所采用的具体计算方法 S AN..30 一段任意字符描述的文字，参见数据元字典 5.6 折旧方法字典',
  `depreciation_life` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '折旧年限,规定的固定资产可进行折旧的时间，单位：年N N2 大于零的自然数',
  `residual_ratio` decimal(5, 2) NULL DEFAULT NULL COMMENT '残值率,资产折旧期满后的剩余值与原值比率 N N5,2 介于 0-1 之间的任意数值',
  `residual_value_select` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '残值选择(跟随资产;当前方案。)',
  `first_depreciation_method` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '首次折旧方式',
  `enabled_mark` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '有效标志(0:禁用; 1:正常)',
  `description` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `creator_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建用户',
  `creator_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `last_modify_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改用户',
  `last_modify_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `delete_mark` int(2) NULL DEFAULT 0 COMMENT '有效标志(0:正常 1:删除)',
  `delete_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除人ID',
  `delete_time` datetime NULL DEFAULT NULL COMMENT '删除时间',
  `version` int(11) NOT NULL DEFAULT 1 COMMENT '版本号',
  `company_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属公司',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '固定资产折旧方案' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for of_fixed_assets
-- ----------------------------
DROP TABLE IF EXISTS `of_fixed_assets`;
CREATE TABLE `of_fixed_assets`  (
  `id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产编码-二维码编码',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产名称',
  `fixed_assets_type_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产类型ID',
  `type_child` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产子类,在资产类别的条目下设定的资产子目录类 S AN..30 一段任意字符描述的文字',
  `rfid_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'rfid编码',
  `rfid_decode` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'rfid解码',
  `bas_space_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属空间ID',
  `in_date` datetime NULL DEFAULT NULL COMMENT '采购日期',
  `in_year` int(4) NULL DEFAULT NULL COMMENT '购置年度,获得资产所有权的年度 T yyyy',
  `in_certificate` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '采购凭证,资产采购的订单号 N N10 大于零的自然数',
  `in_warehouse_num` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '入库单号,资产入库的唯一标识码 N N10 大于零的自然数',
  `in_agent` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '采购人,资产采购项目执行负责人姓名 S AN..10 一段任意字符描述的文字',
  `unit_price` double(20, 2) NULL DEFAULT NULL COMMENT '单价,购置时该资产单位数量的价格 N N20,2 大于零的任意数值',
  `cost_center` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '成本中心,资产所属单位 S AN..30 一段任意字符描述的文字',
  `capitalization_date` datetime NULL DEFAULT NULL COMMENT '资本化日期,预定的财务启用折旧日期',
  `description` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产规格描述',
  `quantity` int(11) NULL DEFAULT NULL COMMENT '数量',
  `unit` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '计量单位',
  `base_organize_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产领用/借用部门',
  `base_organize_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产领用/借用部门名称',
  `base_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产领用/借用负责人',
  `base_user_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产领用/借用人名称',
  `is_custom_user` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产领用/借用人是否系统用户,Y:是;N:否;',
  `borrow_case` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产领用/借用说明',
  `borrow_date` datetime NULL DEFAULT NULL COMMENT '借出日期',
  `return_date` datetime NULL DEFAULT NULL COMMENT '预计归还日期',
  `enabled_mark` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产状态,010:待用 020:在用 021:借用中 030:现场停用 040:退库停用 050:预报废 060:报废 070:投放 080:试用 090:库存',
  `is_fixed_assets` char(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '台账分类,S01:账内资产；S02:低值易耗；S03:账外资产.',
  `data_state` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT 'zc' COMMENT '数据状态,zc:暂存;qr:确认;',
  `inventory_way` char(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '010' COMMENT '是否盘点标识,010:是;020:否;',
  `label_case` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '标签粘贴情况,单标签;双标签;无标签;',
  `project_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '项目名称，募投项目的资产。',
  `access` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '获取方式,资产增加的方式，如自购、盘盈 S AN..30 参见数据元字典 5.3获取方式字典',
  `asset_purpose` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产用途,资产的使用范围 S AN..30 参见数据元字典 5.4资产用途字典',
  `expenditure_source` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '经费来源,购买该资产的经费来源 S AN..30 参见数据元字典 5.5 经费来源字典',
  `depreciation_method` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '折旧方法,将应提折旧总额在固定资产各使用期间进行分配时所采用的具体计算方法 S AN..30 一段任意字符描述的文字，参见数据元字典 5.6 折旧方法字典',
  `depreciation_life` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '折旧年限,规定的固定资产可进行折旧的时间，单位：年N N2 大于零的自然数',
  `brand` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '品牌,不同厂家的资产识别标志 S AN..30 一段任意字符描述的文字',
  `manufacturer` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '制造商,资产的生产厂商 S AN..30 一段任意字符描述的文字',
  `manufacturer_country` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '制造商国别,资产生产厂商所属的国别 S AN..30 一段任意字符描述的文字，参见 ISO3166-1',
  `model_number` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '型号,设备的出厂型号 S AN..30 一段任意字符描述的文字',
  `check_date` datetime NULL DEFAULT NULL COMMENT '验收日期,设备到达医院后进行验收的日期 T8 yyyymmdd',
  `enable_date` datetime NULL DEFAULT NULL COMMENT '启用日期,资产使用的开始日期 T8 yyyymmdd',
  `net_worth` double(20, 2) NULL DEFAULT NULL COMMENT '净值,资产当期价值 N N20,2 大于零的任意数值',
  `residual_worth` double(10, 2) NULL DEFAULT NULL COMMENT '残值,资产折旧期满后的剩余值 N N10,2 大于零的任意数值',
  `residual_ratio` double(5, 2) NULL DEFAULT NULL COMMENT '残值率,资产折旧期满后的剩余值与原值比率 N N5,2 介于 0-1 之间的任意数值',
  `person_in_charge` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '责任人,用来记录资产管理负责人姓名 S AN..30 一段任意字符描述的文字',
  `files` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '物品图片附件集合json',
  `company_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属公司',
  `creator_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建用户',
  `creator_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `last_modify_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改用户',
  `last_modify_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `delete_mark` int(50) NULL DEFAULT NULL COMMENT '有效标志',
  `delete_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除用户',
  `delete_time` datetime NULL DEFAULT NULL COMMENT '删除时间',
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '固定资产列表' ROW_FORMAT = Dynamic;

SET FOREIGN_KEY_CHECKS = 1;
