-- 1. 资产台账统计指标
SELECT curdate()                    AS count_date,
       t.company_id,
       t.bas_space_id               AS space_id,
       s.space_name,
       t.fixed_assets_type_id       AS fix_type1_id,
       t1.`name`                    AS fix_type1_name,
       t.is_fixed_assets,
       COUNT(1)                     AS scount,
       IFNULL(SUM(t.unit_price), 0) AS sprice,
       IFNULL(SUM(t.quantity), 0)   AS quantity_sum
FROM of_fixed_assets t
         INNER JOIN bas_space s ON s.id = t.bas_space_id
         INNER JOIN of_fixed_assets_type t1 ON t1.id = t.fixed_assets_type_id
WHERE t.delete_mark = 0
  AND t.enabled_mark <> '060'
GROUP BY  t.company_id, t.bas_space_id, s.space_name, t.fixed_assets_type_id, t1.`name`, t.is_fixed_assets

-- 2.盘点计划统计指标
SELECT item.fixed_assets_order_id AS order_id,
       item.order_name            AS order_name,
       item.company_id,
       item.bas_space_id          AS space_id,
       item.space_name            AS space_name,
       item.fixed_assets_type_id  AS fix_type1_id,
       item.fix_type1_name        AS fix_type1_name,
       item.is_fixed_assets,
       COUNT(1)                   AS total_count,
       SUM(item.unfinish)         AS unfinish_count,
       SUM(item.finish)           AS complete_count
FROM (
         SELECT CASE WHEN ti.fixed_assets_state IN ('-1', '8') THEN 1 ELSE 0 END     AS unfinish,
                CASE WHEN ti.fixed_assets_state IN ('0', '1', '9') THEN 1 ELSE 0 END AS finish,
                ti.fixed_assets_order_id,
                CONCAT(t.order_name, '(', t.order_code, ')')                         AS order_name,
                ti.fixed_assets_type_id,
                tp.`name`                                                            AS fix_type1_name,
                ti.bas_space_id,
                s.space_name,
                ti.fixed_assets_id,
                ti.fixed_assets_state,
                t.company_id,
                a.is_fixed_assets
         FROM of_fixed_assets_order_item ti
                  LEFT JOIN of_fixed_assets a ON a.id = ti.fixed_assets_id
                  LEFT JOIN bas_space s ON s.id = ti.bas_space_id
                  LEFT JOIN of_fixed_assets_type tp ON tp.id = ti.fixed_assets_type_id
                  INNER JOIN of_fixed_assets_order t ON t.order_state IN ('0', '1') AND ti.fixed_assets_order_id = t.id
     ) item
GROUP BY item.company_id, item.bas_space_id, item.space_name, item.fixed_assets_order_id, item.order_name, item.fixed_assets_type_id,
         item.fix_type1_name, item.is_fixed_assets

-- 3.按园区统计资产价值
SELECT c.id                         AS space_id,
       c.company_id,
       c.space_name,
       sum(IFNULL(a.unit_price, 0)) AS total_price
FROM of_fixed_assets a
         JOIN bas_space b on (a.bas_space_id = b.id)
         join bas_space c on (c.parent_id = '-1' AND (LOCATE(c.id, b.parent_ids) OR c.id = b.id))
WHERE a.delete_mark = 0
  AND a.enabled_mark <> '060'
GROUP BY c.company_id, c.id, c.space_name


-- 4.按园区统计高值和非高值资产数量
SELECT res.company_id, res.space_id,
       res.space_name,
       IFNULL(sum(res.fixed_assets), 0)    AS high_value_num,
       IFNULL(sum(res.no_fixed_assets), 0) AS low_value_num,
       IFNULL(sum(res.off_book_assets), 0) AS off_book_value_num
FROM (
         SELECT a.id                                                AS assets_id,
                a.code                                              AS assets_code,
                a.`name`                                            AS assets_name,
                c.company_id,
                c.id                                                AS space_id,
                c.space_name                                        AS space_name,
                a.is_fixed_assets,
                CASE a.is_fixed_assets WHEN 'S01' THEN 1 ELSE 0 END AS fixed_assets,
                CASE a.is_fixed_assets WHEN 'S02' THEN 1 ELSE 0 END AS no_fixed_assets,
                CASE a.is_fixed_assets WHEN 'S03' THEN 1 ELSE 0 END AS off_book_assets
         FROM of_fixed_assets a
                  JOIN bas_space b on (a.bas_space_id = b.id)
                  join bas_space c on (c.parent_id = '-1' AND (LOCATE(c.id, b.parent_ids) OR c.id = b.id))
         WHERE a.delete_mark = 0 AND a.enabled_mark <> '060'
     ) res
GROUP BY res.company_id, res.space_id, res.space_name

