/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.enums;

import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.source.impl.DbOracle;
import com.bringspring.common.database.source.impl.DbPostgre;

public enum DbAliasEnum {
    ALLOW_NULL("ALLOW_NULL"){

        @Override
        public Integer isTrue() {
            return 1;
        }

        @Override
        public Integer isFalse() {
            return 0;
        }
    }
    ,
    PRIMARY_KEY("PRIMARY_KEY"){

        @Override
        public Integer isTrue() {
            return 1;
        }

        @Override
        public Integer isFalse() {
            return 0;
        }
    }
    ,
    TOTAL_RECORD("totalRecord");

    private final String alias;

    public Integer isTrue() {
        return null;
    }

    public Integer isFalse() {
        return null;
    }

    private DbAliasEnum(String alias) {
        this.alias = alias;
    }

    public String AS() {
        return this.alias;
    }

    public String asByDb(DbBase db) {
        if (DbPostgre.class.equals(db.getClass())) {
            return this.alias.toLowerCase();
        }
        if (DbOracle.class.equals(db.getClass())) {
            return this.alias.toUpperCase();
        }
        return this.alias;
    }

    public static String getAsByDb(DbBase db, String keyWord) {
        if (DbPostgre.class.equals(db.getClass())) {
            return keyWord.toLowerCase();
        }
        if (DbOracle.class.equals(db.getClass())) {
            return keyWord.toUpperCase();
        }
        return keyWord;
    }
}

