/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.filter;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.ActionResultCode;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.license.client.LicenseVerify;
import com.bringspring.common.license.license.CustomLicenseManager;
import com.bringspring.common.license.license.model.LicenseCheckModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.common.util.jwt.JwtUtil;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class TokenInterceptor
implements HandlerInterceptor {
    private UserProvider userProvider;
    private ConfigValueUtil configValueUtil;
    private RedisUtil redisUtil;

    private void init() {
        this.userProvider = SpringContext.getBean(UserProvider.class);
        this.configValueUtil = SpringContext.getBean(ConfigValueUtil.class);
        this.redisUtil = SpringContext.getBean(RedisUtil.class);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.init();
        String method = request.getMethod();
        if ("OPTIONS".equals(method)) {
            return true;
        }
        LicenseVerify licenseVerify = new LicenseVerify();
        boolean verifyResult = licenseVerify.verify();
        if (!verifyResult) {
            ActionResult<JSONObject> result = ActionResult.fail(ActionResultCode.LicenseError.getCode(), ActionResultCode.LicenseError.getMessage());
            CustomLicenseManager customLicenseManager = new CustomLicenseManager();
            LicenseCheckModel model = customLicenseManager.getServerInfos();
            String pcCode = Md5Util.getStringMd5(JSONObject.toJSONString((Object)model));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("machineCode", (Object)pcCode);
            jsonObject.put("isExist", (Object)false);
            result.setData(jsonObject);
            ServletUtils.renderString(response, JsonUtil.getObjectToString(result));
            return false;
        }
        if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
            UserInfo userInfo = this.userProvider.get();
            DataSourceContextHolder.setDatasource(userInfo.getTenantId(), userInfo.getTenantDbConnectionString());
        }
        String token = UserProvider.getToken();
        boolean notCheckLogin = false;
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            notCheckLogin = handlerMethod.hasMethodAnnotation(NotCheckLogin.class);
        }
        if (!notCheckLogin || "false".equals(this.configValueUtil.getTestVersion())) {
            return this.tokenByPass(request, response, token);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
            DataSourceContextHolder.clearDatasourceType();
        }
    }

    private void tokenTimeout(UserInfo userInfo) {
        String tenantId = StringUtils.isNotEmpty(userInfo.getTenantId()) ? userInfo.getTenantId() : "";
        String userId = userInfo.getUserId();
        String onlineInfo = tenantId + "login_online_" + userId;
        this.redisUtil.expire(onlineInfo, userInfo.getTokenTimeout() * 60);
        this.redisUtil.expire(userInfo.getId(), userInfo.getTokenTimeout() * 60);
    }

    private boolean tokenByPass(HttpServletRequest request, HttpServletResponse response, String token) {
        UserInfo userInfo = this.userProvider.get();
        String realToken = JwtUtil.getRealToken(token);
        if (StringUtils.isEmpty(realToken) || !this.redisUtil.exists(realToken)) {
            ActionResult result = ActionResult.fail(ActionResultCode.SessionOverdue.getCode(), ActionResultCode.SessionOverdue.getMessage());
            ServletUtils.renderString(response, JsonUtil.getObjectToString(result));
            return false;
        }
        Date exp = JwtUtil.getExp(token);
        if (exp.getTime() < System.currentTimeMillis()) {
            ActionResult result = ActionResult.fail(ActionResultCode.SessionOverdue.getCode(), ActionResultCode.SessionOverdue.getMessage());
            ServletUtils.renderString(response, JsonUtil.getObjectToString(result));
            return false;
        }
        Integer singleLogin = JwtUtil.getSingleLogin(token);
        if (!"1".equals(String.valueOf(singleLogin)) && !this.userProvider.isOnLine()) {
            ActionResult result = ActionResult.fail(ActionResultCode.SessionOffLine.getCode(), ActionResultCode.SessionOffLine.getMessage());
            this.redisUtil.remove(realToken);
            ServletUtils.renderString(response, JsonUtil.getObjectToString(result));
            return false;
        }
        this.tokenTimeout(userInfo);
        return true;
    }
}

