/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.license.controller;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.ActionResultCode;
import com.bringspring.common.base.NoDataSourceBind;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.license.client.LicenseCheckListener;
import com.bringspring.common.license.client.LicenseManagerHolder;
import com.bringspring.common.license.license.CustomLicenseManager;
import com.bringspring.common.license.license.model.LicenseCheckModel;
import com.bringspring.common.util.FilePathUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.file.UploadUtil;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u4ea7\u54c1\u6388\u6743"}, value="License")
@RestController
@RequestMapping(value={"/api/white/license"})
public class LicenseController {
    private static final Logger log = LoggerFactory.getLogger(LicenseController.class);
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private LicenseCheckListener licenseCheckListener;

    @NoDataSourceBind
    @ApiOperation(value="\u83b7\u53d6\u6388\u6743\u4fe1\u606f")
    @GetMapping(value={"/getLicenseInfo"})
    public ActionResult getInfo() {
        CustomLicenseManager customLicenseManager = new CustomLicenseManager();
        LicenseCheckModel model = customLicenseManager.getServerInfos();
        String pcCode = Md5Util.getStringMd5(JSONObject.toJSONString((Object)model));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("machineCode", (Object)pcCode);
        try {
            LicenseManager licenseManager = LicenseManagerHolder.getInstance(null);
            LicenseContent licenseContent = licenseManager.verify();
            jsonObject.put("isExist", (Object)true);
            jsonObject.put("startDate", (Object)licenseContent.getNotBefore());
            jsonObject.put("endDate", (Object)licenseContent.getNotAfter());
            jsonObject.put("extra", licenseContent.getExtra());
            jsonObject.put("info", (Object)licenseContent.getInfo());
            jsonObject.put("type", (Object)licenseContent.getConsumerType());
            return ActionResult.success(jsonObject);
        }
        catch (Exception e) {
            jsonObject.put("isExist", (Object)false);
            ActionResult<JSONObject> result = ActionResult.fail(ActionResultCode.LicenseError.getCode(), ActionResultCode.LicenseError.getMessage());
            result.setData(jsonObject);
            return result;
        }
    }

    @NoDataSourceBind
    @ApiOperation(value="\u4e0a\u4f20\u6388\u6743\u6587\u4ef6")
    @PostMapping(value={"/Uploader/{type}"}, consumes={"multipart/form-data"})
    public ActionResult uploader(@RequestPart(value="file") MultipartFile file, @PathVariable(value="type") String type) {
        String fileType = UpUtil.getFileType(file);
        if (!"lic".equals(fileType)) {
            return ActionResult.fail(MsgCode.FA017.get());
        }
        String fileName = "license.lic";
        String filePath = FilePathUtil.getFilePath(type.toLowerCase());
        UploadUtil.uploadFile(this.configValueUtil.getFileType(), type, fileName, file, filePath);
        log.debug("===========\u4e0a\u4f20\u6388\u6743\u6587\u4ef6\u6210\u529f\uff0c\u5f00\u59cb\u5b89\u88c5===========");
        boolean install = this.licenseCheckListener.install();
        if (!install) {
            return ActionResult.fail("\u4e0d\u662f\u5408\u6cd5\u7684\u6388\u6743\u6587\u4ef6\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        return this.getInfo();
    }
}

