/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import com.bringspring.common.util.CodeUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.XSSEscape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Collections;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DownUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dowloadExcel(Workbook workbook, String fileName) {
        try {
            HttpServletResponse response = ServletUtils.getResponse();
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            ServletOutputStream outputStream = response.getOutputStream();
            try {
                workbook.write((OutputStream)outputStream);
            }
            finally {
                if (Collections.singletonList(outputStream).get(0) != null) {
                    outputStream.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dowloadFile(File file, String fileName) {
        String escapeFileName = XSSEscape.escape(fileName);
        HttpServletResponse response = ServletUtils.getResponse();
        HttpServletRequest request = ServletUtils.getRequest();
        try {
            FileInputStream is = new FileInputStream(file);
            try {
                BufferedInputStream bis = new BufferedInputStream(is);
                try {
                    response.setCharacterEncoding("UTF-8");
                    response.setContentType("application/x-download");
                    String codeFileName = "";
                    String agent = request.getHeader("USER-AGENT").toLowerCase();
                    codeFileName = -1 != agent.indexOf("msie") || -1 != agent.indexOf("trident") ? URLEncoder.encode(escapeFileName, "UTF-8") : (-1 != agent.indexOf("mozilla") ? new String(escapeFileName.getBytes("UTF-8"), "iso-8859-1") : URLEncoder.encode(escapeFileName, "UTF-8"));
                    response.setHeader("Content-Disposition", "attachment;filename=\"" + codeFileName + "\"");
                    ServletOutputStream os = response.getOutputStream();
                    try {
                        int i;
                        byte[] buff = new byte[8192];
                        while ((i = bis.read(buff)) != -1) {
                            os.write(buff, 0, i);
                        }
                        os.flush();
                    }
                    finally {
                        if (Collections.singletonList(os).get(0) != null) {
                            os.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(bis).get(0) != null) {
                        bis.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(is).get(0) != null) {
                    ((InputStream)is).close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean dowloadFile(String paths, String fileName, String downName) {
        LOG.error("\u538b\u7f29\u5305\u8def\u5f84\uff1a------------------------" + paths);
        if (StringUtils.isNotEmpty(downName)) {
            fileName = downName;
        }
        String escapeFileName = XSSEscape.escape(fileName);
        HttpServletResponse response = ServletUtils.getResponse();
        HttpServletRequest request = ServletUtils.getRequest();
        try {
            FileInputStream is = new FileInputStream(new File(XSSEscape.escapePath(paths)));
            try {
                BufferedInputStream bis = new BufferedInputStream(is);
                try {
                    response.setCharacterEncoding("UTF-8");
                    response.setContentType("text/plain");
                    if (escapeFileName.contains(".svg")) {
                        response.setContentType("image/svg+xml");
                    }
                    String codeFileName = "";
                    String agent = request.getHeader("USER-AGENT").toLowerCase();
                    codeFileName = -1 != agent.indexOf("msie") || -1 != agent.indexOf("trident") ? URLEncoder.encode(escapeFileName, "UTF-8") : (-1 != agent.indexOf("mozilla") ? new String(escapeFileName.getBytes("UTF-8"), "iso-8859-1") : URLEncoder.encode(escapeFileName, "UTF-8"));
                    response.setHeader("Content-Disposition", "attachment;filename=" + new String(codeFileName.getBytes(), "utf-8"));
                    ServletOutputStream os = response.getOutputStream();
                    try {
                        int i;
                        byte[] buff = new byte[8192];
                        while ((i = bis.read(buff)) != -1) {
                            os.write(buff, 0, i);
                        }
                        os.flush();
                    }
                    finally {
                        if (Collections.singletonList(os).get(0) != null) {
                            os.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(bis).get(0) != null) {
                        bis.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(is).get(0) != null) {
                    ((InputStream)is).close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void downCode(Integer stringLength) {
        HttpServletResponse response = DownUtil.getResponse();
        CodeUtil codeUtil = new CodeUtil();
        codeUtil.getRandcode(response, stringLength);
    }

    public static void write(BufferedImage image) {
        try {
            HttpServletResponse response = DownUtil.getResponse();
            ServletOutputStream outputStream = response.getOutputStream();
            try {
                ImageIO.write((RenderedImage)image, "PNG", (OutputStream)outputStream);
            }
            finally {
                if (Collections.singletonList(outputStream).get(0) != null) {
                    outputStream.close();
                }
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public static HttpServletResponse getResponse() {
        HttpServletResponse response = ServletUtils.getResponse();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("image/jpeg");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expire", 0L);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dowloadFile(String file) {
        try {
            OutputStream outputStream = null;
            try {
                FileInputStream in = null;
                try {
                    int n;
                    in = new FileInputStream(file);
                    outputStream = new BufferedOutputStream((OutputStream)ServletUtils.getResponse().getOutputStream());
                    byte[] buff = new byte[1024];
                    while ((n = ((InputStream)in).read(buff)) != -1) {
                        outputStream.write(buff, 0, n);
                    }
                    outputStream.flush();
                }
                finally {
                    if (Collections.singletonList(in).get(0) != null) {
                        ((InputStream)in).close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(outputStream).get(0) != null) {
                    outputStream.close();
                }
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }
}

