/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import com.bringspring.common.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;

public class Md5Util {
    protected static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected static MessageDigest messagedigest = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMd5String(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            byte[] buffer = new byte[1024];
            int numRead = 0;
            while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
                messagedigest.update(buffer, 0, numRead);
            }
            ((InputStream)fis).close();
            String string = Md5Util.bufferToHex(messagedigest.digest());
            return string;
        }
        finally {
            if (Collections.singletonList(fis).get(0) != null) {
                ((InputStream)fis).close();
            }
        }
    }

    public static String getStringMd5(String str) {
        MessageDigest messagedigest = null;
        try {
            messagedigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty(str)) {
            return "";
        }
        byte[] buffer = str.getBytes();
        if (messagedigest != null) {
            messagedigest.update(buffer);
        }
        return Md5Util.bufferToHex(messagedigest.digest());
    }

    public static String bufferToHex(byte[] bytes) {
        return Md5Util.bufferToHex(bytes, 0, bytes.length);
    }

    private static String bufferToHex(byte[] bytes, int m, int n) {
        StringBuffer stringbuffer = new StringBuffer(2 * n);
        int k = m + n;
        for (int l = m; l < k; ++l) {
            Md5Util.appendHexPair(bytes[l], stringbuffer);
        }
        return stringbuffer.toString();
    }

    private static void appendHexPair(byte bt, StringBuffer stringbuffer) {
        char c0 = hexDigits[(bt & 0xF0) >> 4];
        char c1 = hexDigits[bt & 0xF];
        stringbuffer.append(c0);
        stringbuffer.append(c1);
    }

    private static final String toHex(byte[] hash) {
        if (hash == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(hash.length * 2);
        for (int i = 0; i < hash.length; ++i) {
            if ((hash[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(hash[i] & 0xFF, 16));
        }
        return buf.toString();
    }

    public static String hash(String s) {
        try {
            return new String(Md5Util.toHex(Md5Util.getStringMd5(s).getBytes("UTF-8")).getBytes("UTF-8"), "UTF-8");
        }
        catch (Exception e) {
            return s;
        }
    }

    static {
        try {
            messagedigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

