/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.base.ActionResultCode;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.model.OnlineUserModel;
import com.bringspring.common.model.OnlineUserProvider;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.jwt.JwtUtil;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserProvider {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;

    public static String getToken() {
        String toke = UserProvider.getAuthorize();
        return toke;
    }

    public UserInfo get(String token) {
        UserInfo userInfo = new UserInfo();
        String tokens = null;
        if (token != null) {
            tokens = JwtUtil.getRealToken(token);
        } else {
            tokens = UserProvider.getToken();
            tokens = JwtUtil.getRealToken(tokens);
        }
        if (tokens != null) {
            userInfo = JsonUtil.getJsonToBean(String.valueOf(this.redisUtil.getString(tokens)), UserInfo.class);
        }
        if (userInfo == null) {
            userInfo = new UserInfo();
        }
        return userInfo;
    }

    public UserInfo get(String userId, String tenantId) {
        String OnlineInfo;
        UserInfo userInfo;
        tenantId = "null".equals(String.valueOf(tenantId)) ? "" : tenantId;
        String token = tenantId + "login_online_" + userId;
        if (ServletUtils.getIsMobileDevice()) {
            token = tenantId + "login_online_mobile_" + userId;
        }
        return (userInfo = JsonUtil.getJsonToBean(String.valueOf(this.redisUtil.getString(OnlineInfo = String.valueOf(this.redisUtil.getString(token)))), UserInfo.class)) == null ? new UserInfo() : userInfo;
    }

    public UserInfo get() {
        String token = UserProvider.getToken();
        return this.get(token);
    }

    public static String getAuthorize() {
        String authorize = ServletUtils.getHeader("Authorization");
        return authorize;
    }

    public void add(UserInfo userInfo) {
        String userId = userInfo.getUserId();
        long time = DateUtil.getTime(userInfo.getOverdueTime()) - DateUtil.getTime(new Date());
        String authorize = String.valueOf(this.redisUtil.getString(this.cacheKeyUtil.getUserAuthorize() + userId));
        String loginOnlineKey = this.cacheKeyUtil.getLoginOnline() + userId;
        this.redisUtil.remove(authorize);
        this.redisUtil.insert(userInfo.getId(), userInfo, time);
        if (ServletUtils.getIsMobileDevice()) {
            this.redisUtil.insert(this.cacheKeyUtil.getMobileLoginOnline() + userId, userInfo.getId(), time);
            if (ServletUtils.getHeader("clientId") != null) {
                String clientId = ServletUtils.getHeader("clientId");
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put(userInfo.getUserId(), clientId);
                this.redisUtil.insert(this.cacheKeyUtil.getMobileDeviceList(), map);
            }
        } else {
            this.redisUtil.insert(loginOnlineKey, userInfo.getId(), time);
        }
    }

    public void removeWebSocket(UserInfo userInfo) {
        boolean isMobileDevice = ServletUtils.getIsMobileDevice();
        String userId = String.valueOf(userInfo.getUserId());
        String tenandId = "null".equals(String.valueOf(userInfo.getTenantId())) ? "" : userInfo.getTenantId();
        OnlineUserModel user = OnlineUserProvider.getOnlineUserList().stream().filter(t -> userId.equals(t.getUserId()) && tenandId.equals(t.getTenantId()) && isMobileDevice == t.getIsMobileDevice()).findFirst().orElse(null);
        if (user != null) {
            JSONObject object = new JSONObject();
            object.put("method", (Object)"logout");
            object.put("msg", (Object)ActionResultCode.SessionOffLine.getMessage());
            user.getWebSocket().getAsyncRemote().sendText(object.toJSONString());
        }
    }

    public void remove() {
        UserInfo userInfo = this.get();
        String userId = userInfo.getUserId();
        if (ServletUtils.getIsMobileDevice()) {
            this.redisUtil.removeHash(this.cacheKeyUtil.getMobileDeviceList(), userId);
        }
        if (userInfo.getId() != null) {
            this.redisUtil.remove(userInfo.getId());
        }
        this.redisUtil.remove(this.cacheKeyUtil.getUserAuthorize() + userId);
        this.redisUtil.remove(this.cacheKeyUtil.getLoginOnline() + userId);
        this.redisUtil.remove(this.cacheKeyUtil.getSystemInfo());
    }

    public void removeCurrent() {
        UserInfo userInfo = this.get();
        String userId = userInfo.getUserId();
        if (ServletUtils.getIsMobileDevice()) {
            String key = String.valueOf(this.redisUtil.getString(this.cacheKeyUtil.getMobileLoginOnline() + userInfo.getUserId()));
            this.redisUtil.remove(key);
            this.redisUtil.remove(this.cacheKeyUtil.getMobileLoginOnline() + userInfo.getUserId());
        } else {
            String key = String.valueOf(this.redisUtil.getString(this.cacheKeyUtil.getLoginOnline() + userInfo.getUserId()));
            this.redisUtil.remove(key);
            this.redisUtil.remove(this.cacheKeyUtil.getLoginOnline() + userInfo.getUserId());
        }
        this.redisUtil.remove(this.cacheKeyUtil.getUserAuthorize() + userId);
        this.redisUtil.remove(this.cacheKeyUtil.getSystemInfo());
    }

    public void removeOnLine(String userId) {
        if (userId == null) {
            return;
        }
        String onlineToken = String.valueOf(this.redisUtil.getString(this.cacheKeyUtil.getLoginOnline() + userId));
        String mobileOnlineToken = String.valueOf(this.redisUtil.getString(this.cacheKeyUtil.getMobileLoginOnline() + userId));
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)onlineToken)) {
            this.redisUtil.remove(this.cacheKeyUtil.getLoginOnline() + userId);
            this.redisUtil.remove(onlineToken);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mobileOnlineToken)) {
            this.redisUtil.remove(this.cacheKeyUtil.getMobileLoginOnline() + userId);
            this.redisUtil.removeHash(this.cacheKeyUtil.getMobileDeviceList(), userId);
        }
    }

    public boolean isOnLine() {
        UserInfo userInfo = this.get();
        String online = ServletUtils.getIsMobileDevice() ? userInfo.getTenantId() + "login_online_mobile_" + userInfo.getUserId() : userInfo.getTenantId() + "login_online_" + userInfo.getUserId();
        return this.redisUtil.exists(online) && userInfo.getId().equals(this.redisUtil.getString(online).toString());
    }

    public boolean isOverdue() {
        UserInfo userInfo = this.get();
        return !StringUtils.isEmpty(userInfo.getId());
    }

    public boolean isLogined() {
        UserInfo userInfo = this.get();
        String userOnline = (ServletUtils.getIsMobileDevice() ? this.cacheKeyUtil.getMobileLoginOnline() : this.cacheKeyUtil.getLoginOnline()) + userInfo.getUserId();
        Object online = this.redisUtil.getString(userOnline);
        return online == null;
    }
}

