/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util.treeutil;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.treeutil.TreeListModel;
import com.bringspring.common.util.treeutil.TreeViewModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class ListToTreeUtil {
    public static List<TreeViewModel> toTreeView(List<TreeViewModel> data) {
        List<TreeViewModel> treeList = ListToTreeUtil.getChildNodeList(data, "0");
        return treeList;
    }

    private static List<TreeViewModel> getChildNodeList(List<TreeViewModel> data, String parentId) {
        ArrayList<TreeViewModel> treeList = new ArrayList<TreeViewModel>();
        List childNodeList = data.stream().filter(t -> String.valueOf(t.getParentId()).equals(parentId)).collect(Collectors.toList());
        for (TreeViewModel entity : childNodeList) {
            TreeViewModel model = new TreeViewModel();
            model.setId(entity.getId());
            model.setText(entity.getText());
            model.setParentId(entity.getParentId());
            model.setIsexpand(entity.getIsexpand());
            model.setComplete(entity.getComplete());
            model.setHasChildren(entity.getHasChildren() == null ? data.stream().filter(t -> String.valueOf(t.getParentId()).equals(String.valueOf(entity.getId()))).count() != 0L : false);
            if (entity.getShowcheck().booleanValue()) {
                model.setCheckstate(entity.getCheckstate());
                model.setShowcheck(true);
            }
            if (entity.getImg() != null) {
                model.setImg(entity.getImg());
            }
            if (entity.getCssClass() != null) {
                model.setCssClass(entity.getCssClass());
            }
            if (entity.getClick() != null) {
                model.setClick(entity.getClick());
            }
            if (entity.getCode() != null) {
                model.setCode(entity.getCode());
            }
            if (entity.getTitle() != null) {
                model.setTitle(entity.getTitle());
            }
            if (entity.getHt() != null) {
                model.setHt(entity.getHt());
            }
            model.setChildNodes(ListToTreeUtil.getChildNodeList(data, entity.getId()));
            treeList.add(model);
        }
        return treeList;
    }

    public static Object listTree(List<TreeListModel> data) {
        ArrayList<Object> treeGridList = new ArrayList<Object>();
        ListToTreeUtil.getChildNodeList(data, -1, "0", treeGridList);
        HashMap<String, ArrayList<Object>> map = new HashMap<String, ArrayList<Object>>(16);
        map.put("rows", treeGridList);
        return map;
    }

    public static Object listTree(List<TreeListModel> data, String parentId, int level) {
        ArrayList<Object> treeGridList = new ArrayList<Object>();
        ListToTreeUtil.getChildNodeList(data, level, parentId, treeGridList);
        HashMap<String, ArrayList<Object>> map = new HashMap<String, ArrayList<Object>>(16);
        map.put("rows", treeGridList);
        return map;
    }

    private static void getChildNodeList(List<TreeListModel> data, int level, String parentId, List<Object> treeGridList) {
        List childNodeList = data.stream().filter(t -> t.getParentId().equals(parentId)).collect(Collectors.toList());
        if (childNodeList.size() > 0) {
            ++level;
        }
        for (TreeListModel entity : childNodeList) {
            Map<Object, Object> ht = new HashMap<String, Integer>(16);
            if (entity.getHt() != null) {
                ht = entity.getHt();
            }
            ht.put("level", entity.getLevel() == null ? level : entity.getLevel());
            if (entity.getIsLeaf() != null) {
                ht.put("isLeaf", entity.getIsLeaf());
            } else {
                ht.put("isLeaf", data.stream().filter(t -> t.getParentId().equals(entity.getId())).count() == 0L);
            }
            ht.put("parent", parentId);
            ht.put("expanded", entity.getExpanded());
            ht.put("loaded", entity.getLoaded());
            treeGridList.add(ht);
            ListToTreeUtil.getChildNodeList(data, level, entity.getId(), treeGridList);
        }
    }

    public static <T> JSONArray treeWhere(List<T> data, List<T> dataAll, String id, String parentId) {
        JSONArray resultData = new JSONArray();
        if (data.size() == dataAll.size()) {
            resultData.addAll(data);
            return resultData;
        }
        ArrayList dataListAll = new ArrayList();
        CollectionUtils.addAll(dataListAll, dataAll);
        dataListAll.removeAll(data);
        for (int i = 0; i < data.size(); ++i) {
            T entity = data.get(i);
            JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString(entity));
            String firstParentId = json.getString(parentId);
            if (resultData.stream().filter(t -> t.equals(json)).count() == 0L) {
                resultData.add(entity);
            }
            if ("-1".equals(firstParentId)) continue;
            ListToTreeUtil.ParentData(dataListAll, json, resultData, id, parentId);
        }
        return resultData;
    }

    public static <T> JSONArray treeWhere(List<T> data, List<T> dataAll) {
        String id = "id";
        String parentId = "parentId";
        return ListToTreeUtil.treeWhere(data, dataAll, id, parentId);
    }

    private static <T> JSONArray ParentData(List<T> dataAll, JSONObject json, JSONArray resultData, String id, String parentId) {
        List data = dataAll.stream().filter(t -> JSONObject.parseObject((String)JSONObject.toJSONString((Object)t)).get((Object)id).equals(json.getString(parentId))).collect(Collectors.toList());
        dataAll.removeAll(data);
        for (int i = 0; i < data.size(); ++i) {
            Object entity = data.get(i);
            JSONObject object = JSONObject.parseObject((String)JSONObject.toJSONString(entity));
            String parentIds = object.getString(parentId);
            if (resultData.stream().filter(t -> t.equals(object)).count() == 0L) {
                resultData.add(entity);
            }
            if ("-1".equals(parentIds)) break;
            ListToTreeUtil.ParentData(dataAll, object, resultData, id, parentId);
        }
        return resultData;
    }

    public static <T> JSONArray treeWhere(String fid, List<T> dataAll, String id, String parentId) {
        JSONArray resultData = new JSONArray();
        List data = dataAll.stream().filter(t -> JSONObject.parseObject((String)JSONObject.toJSONString((Object)t)).get((Object)parentId).equals(fid)).collect(Collectors.toList());
        ArrayList dataListAll = new ArrayList();
        CollectionUtils.addAll(dataListAll, dataAll);
        dataListAll.removeAll(data);
        for (int i = 0; i < data.size(); ++i) {
            Object entity = data.get(i);
            JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString(entity));
            String fId = json.getString(id);
            String fParentId = json.getString(parentId);
            if (!fid.equals(fParentId)) continue;
            resultData.add(entity);
            ListToTreeUtil.ChildData(fId, dataListAll, resultData, id, parentId);
        }
        return resultData;
    }

    public static <T> JSONArray treeWhere(String fid, List<T> data) {
        String id = "id";
        String parentId = "parentId";
        return ListToTreeUtil.treeWhere(fid, data, id, parentId);
    }

    public static <T> JSONArray ChildData(String fid, List<T> dataAll, JSONArray resultData, String id, String parentId) {
        List data = dataAll.stream().filter(t -> JSONObject.parseObject((String)JSONObject.toJSONString((Object)t)).get((Object)parentId).equals(fid)).collect(Collectors.toList());
        dataAll.removeAll(data);
        for (int i = 0; i < data.size(); ++i) {
            Object entity = data.get(i);
            JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString(entity));
            String fId = json.getString(id);
            String fParentId = json.getString(parentId);
            if (!fid.equals(fParentId)) continue;
            resultData.add(entity);
            ListToTreeUtil.ChildData(fId, dataAll, resultData, id, parentId);
        }
        return resultData;
    }
}

