/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.plugins;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.dynamic.datasource.aop.DynamicDataSourceAnnotationInterceptor;
import com.baomidou.dynamic.datasource.creator.DefaultDataSourceCreator;
import com.baomidou.dynamic.datasource.processor.DsProcessor;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.plugins.DynamicSourceGeneratorInterface;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import org.aopalliance.intercept.MethodInvocation;

public class DynamicGeneratorInterceptor
extends DynamicDataSourceAnnotationInterceptor {
    private DynamicRoutingDataSource dynamicRoutingDataSource;
    private DefaultDataSourceCreator dataSourceCreator;

    public DynamicGeneratorInterceptor(Boolean allowedPublicOnly, DsProcessor dsProcessor) {
        super(allowedPublicOnly, dsProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        block11: {
            try {
                DS ds;
                if (!(methodInvocation.getThis() instanceof DynamicSourceGeneratorInterface) || (ds = methodInvocation.getThis().getClass().getAnnotation(DS.class)) == null || !StringUtils.isNotEmpty(ds.value())) break block11;
                String datasourceName = ds.value();
                DynamicSourceGeneratorInterface m = (DynamicSourceGeneratorInterface)methodInvocation.getThis();
                String now = null;
                try {
                    boolean invalid = true;
                    if (Boolean.TRUE.equals(m.cachedConnection())) {
                        if (this.dynamicRoutingDataSource == null) {
                            this.dynamicRoutingDataSource = SpringContext.getBean(DynamicRoutingDataSource.class);
                            this.dataSourceCreator = SpringContext.getBean(DefaultDataSourceCreator.class);
                        }
                        if (this.dynamicRoutingDataSource.getDataSources().containsKey(datasourceName)) {
                            invalid = false;
                        }
                    }
                    if (invalid) {
                        now = DynamicDataSourceContextHolder.push(null);
                        DataSourceModel dataSource = m.getDataSource();
                        if (dataSource != null) {
                            DataSourceProperty dataSourceProperty = new DataSourceProperty();
                            dataSourceProperty.setUsername(dataSource.getUserName());
                            dataSourceProperty.setPassword(dataSource.getPassword());
                            dataSourceProperty.setUrl(ConnUtil.getUrl(dataSource));
                            dataSourceProperty.setDriverClassName(dataSource.getDriver());
                            this.dynamicRoutingDataSource.addDataSource(datasourceName, this.dataSourceCreator.createDataSource(dataSourceProperty));
                        }
                    }
                }
                finally {
                    if (now != null) {
                        DynamicDataSourceContextHolder.poll();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return methodInvocation.proceed();
    }
}

