/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.license.client;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.license.client.LicenseVerify;
import com.bringspring.common.license.client.model.LicenseVerifyParam;
import com.bringspring.common.license.license.CustomLicenseManager;
import com.bringspring.common.license.license.model.LicenseCheckModel;
import com.bringspring.common.util.Md5Util;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class LicenseCheckListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(LicenseCheckListener.class);
    @Value(value="${config.subject:jsbos}")
    private String subject;
    @Value(value="${config.publicAlias:jsbos}")
    private String publicAlias;
    @Value(value="${config.storePass:RongKe@888}")
    private String storePass;
    @Value(value="${config.licensePath}")
    private String licensePath;
    @Value(value="${config.publicKeysStorePath:jsbos_public.keystore}")
    private String publicKeysStorePath;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext context = event.getApplicationContext().getParent();
        if (context == null) {
            this.install();
        }
    }

    public boolean install() {
        if (StringUtils.isNotBlank((CharSequence)this.licensePath)) {
            log.debug("============= \u5f00\u59cb\u5b89\u88c5\u8bc1\u4e66 =============+");
            CustomLicenseManager customLicenseManager = new CustomLicenseManager();
            LicenseCheckModel model = customLicenseManager.getServerInfos();
            String pcCode = Md5Util.getStringMd5(JSONObject.toJSONString((Object)model));
            log.debug("============= \u5668\u7801\uff1a%s =============", (Object)pcCode);
            LicenseVerifyParam param = new LicenseVerifyParam();
            param.setSubject(this.subject);
            param.setPublicAlias(this.publicAlias);
            param.setStorePass(this.storePass);
            param.setLicensePath(this.licensePath);
            param.setPublicKeysStorePath(this.publicKeysStorePath);
            LicenseVerify licenseVerify = new LicenseVerify();
            try {
                licenseVerify.install(param);
                log.debug("============= \u8bc1\u4e66\u5b89\u88c5\u6210\u529f =============");
            }
            catch (Exception e) {
                log.error("============= \u8bc1\u4e66\u5b89\u88c5\u5931\u8d25 =============", (Object)e.getMessage());
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        LicenseVerifyParam param = new LicenseVerifyParam();
        param.setSubject("jsbos");
        param.setPublicAlias("jsbos");
        param.setStorePass("RongKe@888");
        param.setLicensePath("D:/License/license.lic");
        param.setPublicKeysStorePath("jsbos_public.keystore");
        LicenseVerify licenseVerify = new LicenseVerify();
        try {
            licenseVerify.install(param);
            log.debug("++++++++ \u8bc1\u4e66\u5b89\u88c5\u6210\u529f ++++++++");
        }
        catch (Exception e) {
            log.error("++++++++ \u8bc1\u4e66\u5b89\u88c5\u5931\u8d25 ++++++++");
        }
    }
}

