/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class WordUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changWord(String inputUrl, String outputUrl, Map<String, String> textMap, List<String[]> tableList) {
        boolean changeFlag = true;
        try {
            XWPFDocument document = new XWPFDocument(POIXMLDocument.openPackage((String)inputUrl));
            try {
                WordUtil.changeText(document, textMap);
                WordUtil.changeTable(document, textMap, tableList);
                File file = new File(outputUrl);
                FileOutputStream stream = new FileOutputStream(file);
                try {
                    document.write((OutputStream)stream);
                    stream.close();
                }
                finally {
                    if (Collections.singletonList(stream).get(0) != null) {
                        stream.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(document).get(0) != null) {
                    document.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void changeText(XWPFDocument document, Map<String, String> textMap) {
        List paragraphs = document.getParagraphs();
        for (XWPFParagraph paragraph : paragraphs) {
            String text = paragraph.getText();
            if (!WordUtil.checkText(text)) continue;
            List runs = paragraph.getRuns();
            for (XWPFRun run : runs) {
                run.setText(WordUtil.changeValue(run.toString(), textMap), 0);
            }
        }
    }

    public static void changeTable(XWPFDocument document, Map<String, String> textMap, List<String[]> tableList) {
        List tables = document.getTables();
        for (int i = 0; i < tables.size(); ++i) {
            XWPFTable table = (XWPFTable)tables.get(i);
            if (table.getRows().size() <= 1) continue;
            if (WordUtil.checkText(table.getText())) {
                List rows = table.getRows();
                WordUtil.eachTable(rows, textMap);
                continue;
            }
            WordUtil.insertTable(table, tableList);
        }
    }

    public static void eachTable(List<XWPFTableRow> rows, Map<String, String> textMap) {
        for (XWPFTableRow row : rows) {
            List cells = row.getTableCells();
            for (XWPFTableCell cell : cells) {
                if (!WordUtil.checkText(cell.getText())) continue;
                List paragraphs = cell.getParagraphs();
                for (XWPFParagraph paragraph : paragraphs) {
                    List runs = paragraph.getRuns();
                    for (XWPFRun run : runs) {
                        run.setText(WordUtil.changeValue(run.toString(), textMap), 0);
                    }
                }
            }
        }
    }

    public static void insertTable(XWPFTable table, List<String[]> tableList) {
        for (int i = 1; i < tableList.size(); ++i) {
            XWPFTableRow xWPFTableRow = table.createRow();
        }
        List rows = table.getRows();
        for (int i = 1; i < rows.size(); ++i) {
            XWPFTableRow newRow = table.getRow(i);
            List cells = newRow.getTableCells();
            for (int j = 0; j < cells.size(); ++j) {
                XWPFTableCell cell = (XWPFTableCell)cells.get(j);
                cell.setText(tableList.get(i - 1)[j]);
            }
        }
    }

    public static boolean checkText(String text) {
        boolean check = false;
        if (text.indexOf("$") != -1) {
            check = true;
        }
        return check;
    }

    public static String changeValue(String value, Map<String, String> textMap) {
        Set<Map.Entry<String, String>> textSets = textMap.entrySet();
        for (Map.Entry<String, String> textSet : textSets) {
            String key = "${" + textSet.getKey() + "}";
            if (value.indexOf(key) == -1) continue;
            value = textSet.getValue();
        }
        if (WordUtil.checkText(value)) {
            value = "";
        }
        return value;
    }
}

