/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util.file;

import com.bringspring.common.model.FileModel;
import com.bringspring.common.model.ImageVO;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.DownUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.VisusalImgUrl;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.common.util.minio.MinioUploadUtil;
import io.minio.messages.Item;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.multipart.MultipartFile;

public class UploadUtil {
    private static MinioUploadUtil minioUploadUtil = SpringContext.getBean(MinioUploadUtil.class);

    public static void uploadFile(String type, String bucketName, String objectName, MultipartFile multipartFile, String filePath) {
        switch (type) {
            case "minio": {
                minioUploadUtil.uploadFile(multipartFile, bucketName.toLowerCase(), objectName);
                break;
            }
            default: {
                FileUtil.upFile(multipartFile, filePath, objectName);
            }
        }
    }

    public static void uploadFile(String type, String bucketName, String objectName, MultipartFile multipartFile, String filePath, String secondFilePath) {
        switch (type) {
            case "minio": {
                String fileName = secondFilePath + objectName;
                minioUploadUtil.uploadFile(multipartFile, bucketName.toLowerCase(), fileName);
                break;
            }
            default: {
                filePath = filePath + secondFilePath;
                FileUtil.upFile(multipartFile, filePath, objectName);
            }
        }
    }

    public static void uploadFile(String type, String filePath, String bucketName, String fileName) throws IOException {
        switch (type) {
            case "minio": {
                minioUploadUtil.uploadFiles(filePath, bucketName.toLowerCase(), fileName);
                break;
            }
        }
    }

    public static void removeFile(String type, String bucketName, String fileName) {
        switch (type) {
            case "minio": {
                minioUploadUtil.removeFile(bucketName.toLowerCase(), fileName);
                break;
            }
        }
    }

    public static void downFile(String type, String fileName, String bucketName, String filePath, String downName) {
        switch (type) {
            case "minio": {
                minioUploadUtil.downFile(fileName, bucketName.toLowerCase(), downName);
                break;
            }
            default: {
                if (!StringUtils.isNotEmpty(filePath)) break;
                DownUtil.dowloadFile(filePath + fileName, fileName, downName);
            }
        }
    }

    public static void downFile(String type, String fileName, String bucketName, String filePath, String secondFilePath, String downName) {
        switch (type) {
            case "minio": {
                fileName = secondFilePath + fileName;
                minioUploadUtil.downFile(fileName, bucketName.toLowerCase(), downName);
                break;
            }
            default: {
                if (!StringUtils.isNotEmpty(filePath)) break;
                filePath = filePath + secondFilePath;
                DownUtil.dowloadFile(filePath + fileName, fileName, downName);
            }
        }
    }

    public static void removeFile(String type, String fileName, String bucketName, String filePath) {
        switch (type) {
            case "minio": {
                minioUploadUtil.removeFile(bucketName.toLowerCase(), fileName);
                break;
            }
            default: {
                if (!StringUtils.isNotEmpty(filePath)) break;
                DownUtil.deleteFile(filePath + fileName);
            }
        }
    }

    public static void removeFile(String type, String fileName, String bucketName, String filePath, String secondFilePath) {
        secondFilePath = StringUtils.isNotEmpty(secondFilePath) ? secondFilePath : "";
        switch (type) {
            case "minio": {
                fileName = secondFilePath + fileName;
                minioUploadUtil.removeFile(bucketName.toLowerCase(), fileName);
                break;
            }
            default: {
                if (!StringUtils.isNotEmpty(filePath)) break;
                filePath = filePath + secondFilePath;
                DownUtil.deleteFile(filePath + fileName);
            }
        }
    }

    public static void writeImage(String type, String fileName, String bucketName, String filePath) {
        switch (type) {
            case "minio": {
                minioUploadUtil.dowloadMinioFile(fileName, bucketName.toLowerCase());
                break;
            }
            default: {
                if (!StringUtils.isNotEmpty(filePath)) break;
                DownUtil.dowloadFile(filePath + fileName);
            }
        }
    }

    public static void writeImage(String type, String fileName, String bucketName, String filePath, String secondFilePath) {
        switch (type) {
            case "minio": {
                fileName = secondFilePath + fileName;
                minioUploadUtil.dowloadMinioFile(fileName, bucketName.toLowerCase());
                break;
            }
            default: {
                if (!StringUtils.isNotEmpty(filePath)) break;
                filePath = filePath + secondFilePath;
                DownUtil.dowloadFile(filePath + fileName);
            }
        }
    }

    public static void streamToDown(String type, String fileName, String bucketName, String filePath) {
        switch (type) {
            case "minio": {
                minioUploadUtil.streamToDown(bucketName.toLowerCase(), filePath, fileName);
                break;
            }
        }
    }

    public static boolean downCode(String type, String fileName, String bucketName, String filePath, String zipFile) {
        boolean exists = true;
        switch (type) {
            case "minio": {
                minioUploadUtil.downFile(fileName, bucketName.toLowerCase(), null);
                break;
            }
            default: {
                if (FileUtil.fileIsExists(filePath)) {
                    FileUtil.toZip(zipFile, true, filePath);
                    DownUtil.dowloadFile(zipFile, fileName, null);
                    break;
                }
                exists = false;
            }
        }
        return exists;
    }

    public static void uploadFolder(String type, String folderName, String bucketName, String filePath) {
        switch (type) {
            case "minio": {
                minioUploadUtil.putFolder(filePath + folderName, bucketName, folderName);
                break;
            }
        }
    }

    public static List getFileList(String type, String bucketName, String path, String keyWord, boolean flag) {
        List<FileModel> data = new ArrayList<FileModel>();
        switch (type) {
            case "minio": {
                List fileList = minioUploadUtil.getFileList(bucketName);
                if (fileList == null) break;
                for (int i = 0; i < fileList.size(); ++i) {
                    FileModel fileModel = new FileModel();
                    fileModel.setFileId(i + "");
                    Item item = (Item)fileList.get(i);
                    String objectName = item.objectName();
                    fileModel.setFileName(objectName);
                    fileModel.setFileType(FileUtil.getFileType(objectName));
                    fileModel.setFileSize(FileUtil.getSize(String.valueOf(item.size())));
                    fileModel.setFileTime(item.lastModified() != null ? DateUtil.getZonedDateTimeToString(item.lastModified()) : "");
                    data.add(fileModel);
                }
                if (flag) {
                    data = UploadUtil.getFileModels(data);
                }
                if (keyWord == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)keyWord)) break;
                data = data.stream().filter(t -> t.getFileName().contains(keyWord)).collect(Collectors.toList());
                break;
            }
            default: {
                File filePath = new File(XSSEscape.escapePath(path));
                List<File> files = FileUtil.getFile(filePath);
                if (files == null) break;
                for (int i = 0; i < files.size(); ++i) {
                    File item = files.get(i);
                    FileModel fileModel = new FileModel();
                    fileModel.setFileId(i + "");
                    fileModel.setFileName(item.getName());
                    fileModel.setFileType(FileUtil.getFileType(item));
                    fileModel.setFileSize(FileUtil.getSize(String.valueOf(item.length())));
                    fileModel.setFileTime(FileUtil.getCreateTime(path + item.getName()));
                    data.add(fileModel);
                }
                data = UploadUtil.getFileModels(data);
                if (keyWord == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)keyWord)) break;
                data = data.stream().filter(t -> t.getFileName().contains(keyWord)).collect(Collectors.toList());
            }
        }
        return data;
    }

    private static List<FileModel> getFileModels(List<FileModel> data) {
        data = data.stream().filter(m -> "xlsx".equals(m.getFileType()) || "xls".equals(m.getFileType()) || "docx".equals(m.getFileType()) || "doc".equals(m.getFileType()) || "pptx".equals(m.getFileType()) || "ppt".equals(m.getFileType()) || "pdf".equals(m.getFileType())).collect(Collectors.toList());
        return data;
    }

    public static List getFileList(String fileType, String bucketName, String path, String type) {
        String newPath = XSSEscape.escape(path);
        String newType = XSSEscape.escape(type);
        ArrayList<ImageVO> vo = new ArrayList<ImageVO>();
        switch (fileType) {
            case "minio": {
                List fileList = minioUploadUtil.getFileList(bucketName, newType);
                for (int i = 0; i < fileList.size(); ++i) {
                    ImageVO imageVO = new ImageVO();
                    Item item = (Item)fileList.get(i);
                    String[] objectName = item.objectName().split("/");
                    String fileName = objectName[1];
                    imageVO.setLink(VisusalImgUrl.url + newType + "/" + fileName);
                    imageVO.setOriginalName(fileName);
                    vo.add(imageVO);
                }
                break;
            }
            default: {
                List<File> fileLists = FileUtil.getFile(new File(newPath));
                for (File file : fileLists) {
                    ImageVO imageVO = new ImageVO();
                    String fileName = file.getName();
                    imageVO.setLink(VisusalImgUrl.url + newType + "/" + fileName);
                    imageVO.setOriginalName(fileName);
                    vo.add(imageVO);
                }
            }
        }
        return vo;
    }

    public static void copyObject(String type, String filePath, String fileName, String copyToFilePath, String copyToFileName) {
        switch (type) {
            case "minio": {
                minioUploadUtil.copyObject("temporary", fileName, "mail", copyToFileName);
                break;
            }
            default: {
                FileUtil.copyFile(filePath + fileName, copyToFilePath + copyToFileName);
            }
        }
    }

    public static void downToLocal(String type, String fileName, String bucketName, String filePath) {
        switch (type) {
            case "minio": {
                minioUploadUtil.downToLocal(bucketName.toLowerCase(), filePath, fileName);
                break;
            }
        }
    }
}

