/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.context.SpringContext;

public class FilePathUtil {
    private static ConfigValueUtil configValueUtil = SpringContext.getBean(ConfigValueUtil.class);

    public static String getFilePath(String fileType) {
        fileType = XSSEscape.escape(fileType);
        String filePath = null;
        switch (fileType.toLowerCase()) {
            case "license": {
                filePath = configValueUtil.getLicenseFilePath();
                break;
            }
            case "useravatar": {
                filePath = configValueUtil.getUserAvatarFilePath();
                break;
            }
            case "mail": {
                filePath = configValueUtil.getEmailFilePath();
                break;
            }
            case "im": {
                filePath = configValueUtil.getImContentFilePath();
                break;
            }
            case "document": {
                filePath = configValueUtil.getDocumentFilePath();
                break;
            }
            case "documentzip": {
                filePath = configValueUtil.getDocumentZip();
                break;
            }
            case "dataBackup": {
                filePath = configValueUtil.getDataBackupFilePath();
                break;
            }
            case "allowuploadfiletype": {
                filePath = configValueUtil.getAllowUploadFileType();
                break;
            }
            case "preview": {
                filePath = configValueUtil.getDocumentPreviewPath();
                break;
            }
            case "templatefile": {
                filePath = configValueUtil.getTemplateFilePath();
                break;
            }
            case "servicedirectory": {
                break;
            }
            case "webdirectory": {
                filePath = configValueUtil.getCodeAreasName();
                break;
            }
            case "bivisualpath": {
                filePath = configValueUtil.getBiVisualPath();
                break;
            }
            case "annex": {
                filePath = configValueUtil.getWebAnnexFilePath();
                break;
            }
            case "annexpic": {
                filePath = configValueUtil.getWebAnnexFilePath();
                break;
            }
            case "temporary": {
                filePath = configValueUtil.getTemporaryFilePath();
                break;
            }
            case "workflow": {
                filePath = configValueUtil.getTemporaryFilePath();
                break;
            }
            case "export": {
                filePath = configValueUtil.getTemporaryFilePath();
                break;
            }
            case "documentecbp": {
                filePath = configValueUtil.getDocumentEcbpFilePath();
                break;
            }
        }
        return filePath;
    }
}

