package com.bringspring.common.config;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.cache.CacheManagerCustomizer;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.*;
import org.springframework.util.DigestUtils;

import java.nio.charset.StandardCharsets;

/**
 * 配置类
 * 下面配置了3个，
 * 一个是 localCacheManager，底层用的是ConcurrentMap，
 * 一个是 ehCacheCacheManager，底层用的是ehcache，
 * 一个是 redisCacheManager，底层用的是redis。
 *
 * @EnableCaching不能少,如果没有此配置类，可以把注解@EnableCaching放到启动类上，@EnableCaching：表示开启缓存功能
 */
@Slf4j
@Configuration
@EnableCaching
//@EnableConfigurationProperties({CacheProperties.class, RedisProperties.class})
public class CacheManagerConfig {
//    @Autowired
//    private CacheProperties cacheProperties;
//    @Autowired
//    private RedisProperties redisProperties;

    /**
     * cacheManager名称
     */
    public interface CacheManagerName {
        /**
         * local
         */
        String LOCAL_CACHE_MANAGER = "localCacheManager";

        /**
         * ehCache
         */
        String EHCACHE_CACHE_MAANGER = "ehcacheCacheManager";

        /**
         * redis
         */
        String REDIS_CACHE_MANAGER = "redisCacheManager";
    }

    /**
     * 创建localCacheManager
     */
//    @Bean(CacheManagerConfig.CacheManagerName.LOCAL_CACHE_MANAGER)
//    public CacheManager localCacheManager() {
//
//        return new ConcurrentMapCacheManager();
//    }

    /**
     * 创建ehcacheCacheManager
     */
//    @Primary
//    @Bean(CacheManagerConfig.CacheManagerName.EHCACHE_CACHE_MAANGER)
//    public EhCacheCacheManager ehcacheCacheManager() {
//        EhCacheCacheManager ehCacheManager = new EhCacheCacheManager();
//        return ehCacheManager;
//    }


    /**
     * 默认的redisCacheManager
     *
     * @return
     */
//    @Bean(CacheManagerConfig.CacheManagerName.REDIS_CACHE_MANAGER)
//    public RedisCacheManager redisCacheManager() {
//
//        GenericJackson2JsonRedisSerializer genericJackson2JsonRedisSerializer =
//                new GenericJackson2JsonRedisSerializer();
//        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
//
//        // 设置缓存key、value的序列化方式
//        RedisCacheConfiguration config =
//                RedisCacheConfiguration.defaultCacheConfig().serializeKeysWith(RedisSerializationContext
//                .SerializationPair.fromSerializer(stringRedisSerializer)).serializeValuesWith
//                (RedisSerializationContext.SerializationPair.fromSerializer(genericJackson2JsonRedisSerializer));
//        CacheProperties.Redis redisProperties = cacheProperties.getRedis();
//        if (redisProperties.getTimeToLive() != null) {
//            config = config.entryTtl(redisProperties.getTimeToLive());
//        }
//        if (redisProperties.getKeyPrefix() != null) {
//            config = config.prefixKeysWith(redisProperties.getKeyPrefix());
//        }
//        if (!redisProperties.isCacheNullValues()) {
//            config = config.disableCachingNullValues();
//        }
//        if (!redisProperties.isUseKeyPrefix()) {
//            config = config.disableKeyPrefix();
//        }
//        return RedisCacheManager.builder(jedisConnectionFactory()).cacheDefaults(config).build();
//    }
//
//    /**
//     * jedis连接工厂
//     *
//     * @return
//     */
//    @Bean
//    public JedisConnectionFactory jedisConnectionFactory() {
//        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
//        redisStandaloneConfiguration.setDatabase(redisProperties.getDatabase());
//        redisStandaloneConfiguration.setPort(redisProperties.getPort());
//        redisStandaloneConfiguration.setHostName(redisProperties.getHost());
//        redisStandaloneConfiguration.setPassword(RedisPassword.of(redisProperties.getPassword()));
//        JedisConnectionFactory factory = new JedisConnectionFactory(redisStandaloneConfiguration);
//        return factory;
//    }
//    @Bean(CacheManagerConfig.CacheManagerName.REDIS_CACHE_MANAGER)
//    public RedisCacheManager redisCacheManager(RedisConnectionFactory redisConnectionFactory) {
//        //初始化一个redisCacheWriter
//        RedisCacheWriter redisCacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter(redisConnectionFactory);
//        //初始化序列化方式为json
//        RedisSerializer redisSerializer = new GenericJackson2JsonRedisSerializer();
//        RedisSerializationContext.SerializationPair pair =
//                RedisSerializationContext.SerializationPair.fromSerializer(redisSerializer);
//        RedisCacheConfiguration redisCacheConfiguration =
//                RedisCacheConfiguration.defaultCacheConfig().serializeValuesWith(pair);
//
//        return new RedisCacheManager(redisCacheWriter, redisCacheConfiguration);
//    }

    /**
     * 自定义缓存数据 key 生成策略
     * target: 类
     * method: 方法
     * params: 参数
     *
     * @return KeyGenerator
     * 注意: 该方法只是声明了key的生成策略,还未被使用,需在@Cacheable注解中指定keyGenerator
     * 如: @Cacheable(value = "key", keyGenerator = "keyGenerator")
     */
    @Bean("cacheKeyGenerator")
    public KeyGenerator keyGenerator() {
        //new了一个KeyGenerator对象,采用lambda表达式写法
        //类名+方法名+参数列表的类型+参数值，然后再做md5转16进制作为key
        //使用冒号(:)进行分割，可以很多显示出层级关系
        return (target, method, params) -> {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append(target.getClass().getName());
            strBuilder.append(":");
            strBuilder.append(method.getName());
            for (Object obj : params) {
                if (obj != null) {
                    strBuilder.append(":");
                    strBuilder.append(obj.getClass().getName());
                    strBuilder.append(":");
                    strBuilder.append(JSON.toJSONString(obj));
                }
            }
            String str = strBuilder.toString();
            log.info("ehcache key str: " + str);
//            return str;
            String md5DigestAsHex = DigestUtils.md5DigestAsHex(str.getBytes(StandardCharsets.UTF_8));
            log.info("cache key md5DigestAsHex: " + md5DigestAsHex);
            return md5DigestAsHex;
        };
    }

//    @Bean(name = "redisTemplate")
//    public RedisTemplate<String, Object> redisTemplate() {
//        RedisTemplate<String, Object> redisTemplate = new RedisTemplate<>();
//        redisTemplate.setConnectionFactory(jedisConnectionFactory());
//
//        Jackson2JsonRedisSerializer<Object> jackson2JsonRedisSerializer =
//                new Jackson2JsonRedisSerializer<>(Object.class);
//        ObjectMapper objectMapper = new ObjectMapper();
//
//        GenericJackson2JsonRedisSerializer genericJackson2JsonRedisSerializer =
//                new GenericJackson2JsonRedisSerializer();
//        redisTemplate.setDefaultSerializer(genericJackson2JsonRedisSerializer);
//        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
//        objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
//        jackson2JsonRedisSerializer.setObjectMapper(objectMapper);
//        redisTemplate.setKeySerializer(new StringRedisSerializer());
//        redisTemplate.setHashKeySerializer(new StringRedisSerializer());
//        redisTemplate.setHashValueSerializer(genericJackson2JsonRedisSerializer);
//        redisTemplate.setValueSerializer(genericJackson2JsonRedisSerializer);
//        redisTemplate.afterPropertiesSet();
//        return redisTemplate;
//    }

}
