package com.bringspring.common.constant;
import com.bringspring.common.constant.model.MCode;

/**
 * 常用提示信息
 *
 * @author RKKJ开发平台组 YanYu
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/12/20
 */
public interface MsgCode {

    /**
     * 执行成功：SU（success）
     */
    MCode SU000 = MSG("SU000","Success");
    MCode SU001 = MSG("SU001","新建成功");
    MCode SU002 = MSG("SU002","保存成功");
    MCode SU003 = MSG("SU003","删除成功");
    MCode SU004 = MSG("SU004","更新成功");
    MCode SU005 = MSG("SU005","操作成功");
    MCode SU006 = MSG("SU006","提交成功，请耐心等待");
    MCode SU007 = MSG("SU007","复制成功");
    MCode SU008 = MSG("SU008","停止成功");
    MCode SU009 = MSG("SU009","终止成功");
    MCode SU010 = MSG("SU010","还原成功");
    MCode SU011 = MSG("SU011","发布成功");
    MCode SU012 = MSG("SU012","发送成功");
    MCode SU013 = MSG("SU013","接口修改成功");
    MCode SU014 = MSG("SU014","更新接口状态成功");
    MCode SU015 = MSG("SU015","上传成功");
    MCode SU016 = MSG("SU016","设置成功");
    MCode SU017 = MSG("SU017","验证成功");

    /**
     * 执行失败：FA（fail）
     */
    MCode FA001 = MSG("FA001","此条数据不存在");
    MCode FA002 = MSG("FA002","更新失败，数据不存在");
    MCode FA003 = MSG("FA003","删除失败，数据不存在");
    MCode FA004 = MSG("FA004","复制失败，数据不存在");
    MCode FA005 = MSG("FA005","发送失败，数据不存在");
    MCode FA006 = MSG("FA006","下载失败，数据不存在");
    MCode FA007 = MSG("FA007","操作失败，数据不存在");
    MCode FA008 = MSG("FA008","停止失败，数据不存在");
    MCode FA009 = MSG("FA009","终止失败，数据不存在");
    MCode FA010 = MSG("FA010","还原失败，数据不存在");
    MCode FA011 = MSG("FA011","发布失败，数据不存在");
    MCode FA012 = MSG("FA012","获取失败，数据不存在");
    MCode FA013 = MSG("FA013","接口修改失败，数据不存在");
    MCode FA014 = MSG("FA014","更新接口状态失败，数据不存在");
    MCode FA015 = MSG("FA015","预览失败，数据不存在");
    MCode FA016 = MSG("FA016","删除失败，该文件夹存在数据");
    MCode FA017 = MSG("FA017","上传失败，文件格式不允许上传");
    MCode FA018 = MSG("FA018","文件不存在");
    MCode FA019 = MSG("FA019","已失效");
    MCode FA020 = MSG("FA020","未查到信息");
    MCode FA021 = MSG("FA021","更新失败！您没有权限操作");
    MCode FA022 = MSG("FA022","更新失败！您没有权限操作 (角色只有超级管理员才能够操作)");
    MCode FA023 = MSG("FA023","更新失败！无法切换组织。");
    MCode FA024 = MSG("FA024","删除失败！已绑定用户");
    MCode FA025 = MSG("FA025","该组织内无角色或角色权限为空，组织切换失败");
    MCode FA026 = MSG("FA026","更新失败，关联组织不存在，请重新登录，或者刷新页面");

    /*======1 短语======*/
    MCode FA101 = MSG("FA101","保存失败");
    MCode FA102 = MSG("FA102","更新失败");



    /**
     * 重名判断
     */
    MCode EXIST001 = MSG("EXIST001","名称不能重复");
    MCode EXIST002 = MSG("EXIST002","编码不能重复");
    MCode EXIST003 = MSG("EXIST003","模板已存在");
    MCode EXIST004 = MSG("EXIST004","文件夹名称不能重复");

    /**
     * 导入导出：IMP（import/export）
     */
    MCode IMP001 = MSG("IMP001","导入成功");
    MCode IMP002 = MSG("IMP002","导入失败，文件格式错误");
    MCode IMP003 = MSG("IMP003","导入失败，数据已存在");
    MCode IMP004 = MSG("IMP004","导入失败，数据有误");

    /**
     * 其他
     */
    MCode PRI001 = MSG("PRI001","打印模板不存在");
    MCode PRI002 = MSG("PRI002","数字字典不存在printDev的字典分类");
    MCode PRI003 = MSG("PRI003","第1条SQL语句：查询出多条表头信息");
    MCode PRI004 = MSG("PRI004","第1条SQL语句：未查出表头信息");
    MCode PRI005 = MSG("PRI005","第{index}条SQL语句：");
    MCode COD001 = MSG("COD001","集合条件过滤获得目标为空");


    /**
     * 登录相关
     */
    /*=====0-账号相关====*/
    MCode LOG001 = MSG("LOG001","账户异常");
    MCode LOG002 = MSG("LOG002","注销成功");
    MCode LOG003 = MSG("LOG003","无效的账号");
    MCode LOG004 = MSG("LOG004","账号异常，请联系管理员修改所属组织信息");
    MCode LOG005 = MSG("LOG005","账号未被激活");
    MCode LOG006 = MSG("LOG006","账号被禁用");
    MCode LOG007 = MSG("LOG007","账号已被删除");
    MCode LOG010 = MSG("LOG010","此IP未在白名单中，请联系管理员");
    MCode LOG011 = MSG("LOG011","登录失败，用户暂未绑定角色");
    MCode LOG012 = MSG("LOG012","请联系管理员解除账号锁定！");
    MCode LOG013 = MSG("LOG013","请等待{time}分钟后再进行登录，或联系管理员解除账号锁定！");
    MCode LOG014 = MSG("LOG014","登录时用户的账号、手机、邮箱重复，请联系管理员排查！");

    /*======1-登录相关======*/
    MCode LOG101 = LOG("LOG101","账户或密码错误，请重新输入。");
    MCode LOG102 = LOG("LOG102","账号有误，请重新输入。");
    MCode LOG103 = LOG("LOG103","请输入验证码");
    MCode LOG104 = LOG("LOG104","验证码错误");
    MCode LOG105 = LOG("LOG105","登陆繁忙，请稍后再试");

    /*======2-密码修改========*/
    MCode LOG201 = LOG("LOG201","旧密码错误");
    MCode LOG202 = LOG("LOG202","修改成功，请牢记新密码。");
    MCode LOG203 = LOG("LOG203","修改失败，账号不存在。");

    /**
     * 数据库
     */
    MCode DB001 = DB("DB001","数据类型编码不符合标准（请注意大小写）。MySQL , SQLServer , Oracle , DM8 , KingbaseES , PostgreSQL");
    MCode DB002 = DB("DB002","请检查 1、连接信息 2、网络通信 3、数据库服务启动状态。 详情：");
    MCode DB003 = DB("DB003","通过url找不到对应数据库");
    MCode DB004 = DB("DB004","查询结果集为空。");

    /**
     * 工作流相关错误码
     */
    /*========0-状态、短提示==========*/
    MCode WF001 = WF("WF001","必填值");
    MCode WF002 = WF("WF002","【审核通过】");
    MCode WF003 = WF("WF003","【审核同意】");
    MCode WF004 = WF("WF004","【审核退回】");
    MCode WF005 = WF("WF005","审批已完成");
    MCode WF006 = WF("WF006","开始");
    MCode WF007 = WF("WF007","结束");
    MCode WF008 = WF("WF008","必须有表");

    /*=========1-提示语句=========*/
    MCode WF101 = WF("WF101","新增异常，需自主排查。");
    MCode WF102 = WF("WF102","修改异常，需自主排查。");
    MCode WF103 = WF("WF103","复制异常，需自主排查。");
    MCode WF104 = WF("WF104","当前流程被处理，无法撤回流程");
    MCode WF105 = WF("WF105","任务待审状态才能撤回");
    MCode WF106 = WF("WF106","撤回节点下一节点已操作");
    MCode WF107 = WF("WF107","包含子流程不能撤回");
    MCode WF108 = WF("WF108","当前流程正在运行不能重复提交");
    MCode WF109 = WF("WF109","单据规则不存在");
    MCode WF110 = WF("WF110","包含子流程不能操作");
    MCode WF111 = WF("WF111","当前流程未完成,不能修改工作流引擎");
    MCode WF112 = WF("WF112","已审核完成");
    MCode WF113 = WF("WF113","未找到流程引擎");
    MCode WF114 = WF("WF114","驳回节点不能是子流程");
    MCode WF115 = WF("WF115","该流程工单已删除");
    MCode WF116 = WF("WF116","当前流程正在运行不能删除");
    MCode WF117 = WF("WF117","功能流程不能删除");
    MCode WF118 = WF("WF118","子表数据不能删除");
    MCode WF119 = WF("WF119","系统表单反射失败");
    MCode WF120 = WF("WF120","该流程工单已撤回");
    MCode WF121 = WF("WF121","该流程工单已终止");
    MCode WF122 = WF("WF122","没有权限操作");
    MCode WF123 = WF("WF123","该流程待办已删除");


    static MCode MSG(String code,String desc){
        return new MCode("message",code, desc);
    }

    static MCode LOG(String code,String desc){
        return new MCode("login",code, desc);
    }

    static MCode DB(String code,String desc){
        return new MCode("database",code, desc);
    }

    static MCode WF(String code,String desc){
        return new MCode("workflow",code, desc);
    }


}
