package com.bringspring.common.event.strategy;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 初始化消息通道
 */
@Component
public class ActionMethodContext implements InitializingBean, ApplicationContextAware {

    private ApplicationContext applicationContext;

    private Map<String, ActionStrategy> methodMap = new HashMap<>();

    @Override
    public void afterPropertiesSet() throws Exception {
        //获取所有实现的ActionStrategy的bean
        applicationContext.getBeansOfType(ActionStrategy.class).values()
                .stream().forEach(actionStrategy ->methodMap.put(actionStrategy.actionMethod(),actionStrategy));
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    /**
     * 根据类型获取对应的策略方法
     * @param actionMethod
     * @return
     */
    public ActionStrategy getActionMethod(String actionMethod) {
        return methodMap.get(actionMethod);
    }

}
