package com.bringspring.common.util;

import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.common.util.enums.FileTypeEnum;
import org.bouncycastle.LICENSE;

/**
 * @author ：RKKJ开发平台组
 * @version: V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date ：2022/4/26 15:58
 */
public class FilePathUtil {

    private static ConfigValueUtil configValueUtil = SpringContext.getBean(ConfigValueUtil.class);

    /**
     * 通过fileType获取文件夹名称
     *
     * @param fileType 文件类型
     * @return
     */
    public static String getFilePath(String fileType) {
        fileType = XSSEscape.escape(fileType);
        String filePath = null;
        //获取文件保存路径
        switch (fileType.toLowerCase()) {

            //授权文件
            case FileTypeEnum.LICENSE:
                filePath = configValueUtil.getLicenseFilePath();
                break;
            //用户头像存储路径
            case FileTypeEnum.USERAVATAR:
                filePath = configValueUtil.getUserAvatarFilePath();
                break;
            //邮件文件存储路径
            case FileTypeEnum.MAIL:
                filePath = configValueUtil.getEmailFilePath();
                break;
            //IM聊天图片+语音存储路径
            case FileTypeEnum.IM:
                filePath = configValueUtil.getImContentFilePath();
                break;
            //文档管理存储路径
            case FileTypeEnum.DOCUMENT:
                filePath = configValueUtil.getDocumentFilePath();
                break;
            //文件夹压缩下载存储路径
            case FileTypeEnum.DOCUMENTZIP:
                filePath = configValueUtil.getDocumentZip();
                break;
            //数据库备份文件路径
            case FileTypeEnum.DATABACKUP:
                filePath = configValueUtil.getDataBackupFilePath();
                break;
            //允许上传文件类型
            case FileTypeEnum.ALLOWUPLOADFILETYPE:
                filePath = configValueUtil.getAllowUploadFileType();
                break;
            //文件在线预览存储pdf
            case FileTypeEnum.DOCUMENTPREVIEWPATH:
                filePath = configValueUtil.getDocumentPreviewPath();
                break;
            //文件模板存储路径
            case FileTypeEnum.TEMPLATEFILE:
                filePath = configValueUtil.getTemplateFilePath();
                break;
            //前端文件目录
            case FileTypeEnum.SERVICEDIRECTORY:
                break;
            //后端文件目录
            case FileTypeEnum.WEBDIRECTORY:
                filePath = configValueUtil.getCodeAreasName();
                break;
            //大屏图片文件夹
            case FileTypeEnum.BIVISUALPATH:
                filePath = configValueUtil.getBiVisualPath();
                break;
            //前端附件文件目录
            case FileTypeEnum.ANNEX:
                filePath = configValueUtil.getWebAnnexFilePath();
                break;
            case FileTypeEnum.ANNEXPIC:
                filePath = configValueUtil.getWebAnnexFilePath();
                break;
            //临时文件存储路径
            case FileTypeEnum.TEMPORARY:
                filePath = configValueUtil.getTemporaryFilePath();
                break;
            //临时文件存储路径 工作流
            case FileTypeEnum.WORKFLOW:
                filePath = configValueUtil.getTemporaryFilePath();
                break;
            //临时文件存储路径 导出
            case FileTypeEnum.EXPORT:
                filePath = configValueUtil.getTemporaryFilePath();
                break;
            //边缘计算文件存储
            case FileTypeEnum.DOCUMENTECBP:
                filePath = configValueUtil.getDocumentEcbpFilePath();
                break;
            //物联网解析包
            case FileTypeEnum.IOTANALYSIS:
                filePath = configValueUtil.getIotAnalysisFilePath();
                break;
            default:
                break;
        }
        return filePath;
    }
}
