package com.bringspring.common.util;

import cn.hutool.core.util.StrUtil;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/16 8:59
 */
public class UpUtil {

    /**
     * 获取上传文件
     */
    public static List<MultipartFile> getFileAll() {
        MultipartResolver resolver = new StandardServletMultipartResolver();
        MultipartHttpServletRequest mRequest = resolver.resolveMultipart(ServletUtils.getRequest());
        Map<String, MultipartFile> fileMap = mRequest.getFileMap();
        List<MultipartFile> list = new ArrayList<>();
        for (Map.Entry<String, MultipartFile> map : fileMap.entrySet()) {
            list.add(map.getValue());
        }
        return list;
    }


    /**
     * 获取文件类型
     */
    public static String getFileType(MultipartFile multipartFile) {
        if (multipartFile.getContentType() != null) {
            String[] split = multipartFile.getOriginalFilename().split("\\.");
            if (split.length > 1) {
                String s = split[split.length - 1];
                if (StrUtil.equals(s.toUpperCase(), "MOV")) s = "mp4";
                return s;
            } else {
                if (multipartFile.getContentType().toLowerCase().equals("audio/mpeg")) {
                    return "mp3";
                }
                // 某些文件类型没有在名称上展现
                String[] contentType = multipartFile.getContentType().split("/");
                if (contentType.length > 1) {
                    return contentType[contentType.length - 1];
                }
            }
        }
        return "";
    }

}
