/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.source.impl;

import com.baomidou.mybatisplus.annotation.DbType;
import com.bringspring.common.database.enums.DbAliasEnum;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.model.dto.DataSourceDTO;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.sql.impl.SqlKingbase;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;

public class DbKingbase
extends DbBase {
    @Override
    protected void init() {
        this.setInstance("KingbaseES", DbType.KINGBASE_ES, "54321", "kingbase8", "com.kingbase8.Driver", "jdbc:kingbase8://{host}:{port}/{dbname}?currentSchema={schema}", new SqlKingbase());
    }

    @Override
    public String getConnUrl(String prepareUrl, String host, Integer port, String dbName, String schema) {
        return super.getConnUrl(prepareUrl, host, port, dbName, this.getCheckSchema(schema));
    }

    @Override
    public DbTableFieldModel getPartFieldModel(ResultSet result) throws SQLException, DataException {
        DbTableFieldModel model = new DbTableFieldModel();
        if (result.getString(DbAliasEnum.PRIMARY_KEY.AS()) != null) {
            model.setPrimaryKey(DbAliasEnum.PRIMARY_KEY.isTrue());
        } else {
            model.setPrimaryKey(DbAliasEnum.PRIMARY_KEY.isFalse());
        }
        if (result.getBoolean(DbAliasEnum.ALLOW_NULL.AS())) {
            model.setAllowNull(DbAliasEnum.ALLOW_NULL.isFalse());
        } else {
            model.setAllowNull(DbAliasEnum.ALLOW_NULL.isTrue());
        }
        return model;
    }

    @Override
    public LinkedList<Object> getStructParams(String structParams, String table, DataSourceMod dbSourceOrDbLink) {
        DataSourceDTO dataSourceDTO = dbSourceOrDbLink.convertDTO();
        dataSourceDTO.setDbName(dataSourceDTO.getUserName());
        dataSourceDTO.setDbSchema(this.getCheckSchema(dataSourceDTO.getDbSchema()));
        return super.getStructParams(structParams, table, dataSourceDTO);
    }

    private String getCheckSchema(String schema) {
        if (StringUtils.isEmpty(schema)) {
            schema = "public";
        }
        return schema;
    }
}

