/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.filter;

import com.bringspring.common.filter.RepeatSubmitRule;
import com.bringspring.common.filter.TokenInterceptor;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebFilterConfig
implements WebMvcConfigurer {
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new RepeatSubmitRule());
        InterceptorRegistration registration = registry.addInterceptor((HandlerInterceptor)new TokenInterceptor());
        registration.excludePathPatterns(this.excludePath());
    }

    private List<String> excludePath() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("/web/**");
        list.add("/api/service/**");
        list.add("/api/white/**");
        list.add("/api/oauth/Login");
        list.add("/api/oauth/LogingByQy");
        list.add("/api/oauth/getUserIdByCode");
        list.add("/api/oauth/getFile");
        list.add("/api/app/Version");
        list.add("/api/file/Uploader/**");
        list.add("/api/file/Download/**");
        list.add("/api/visualdev/Generater/DownloadVisCode/**");
        list.add("/api/file/DownloadModel/**");
        list.add("/api/file/Image/**");
        list.add("/api/file/ImageCode/**");
        list.add("/api/extend/DocumentPreview/**");
        list.add("/api/extend/Document/getShareEntityById/{id}");
        list.add("/api/visualdev/DataScreen/Images/**");
        list.add("/api/extend/DocumentPreview/down/{fileName}");
        list.add("/api/system/DataMap/**");
        list.add("/api/file/**");
        list.add("/api/file/onlinePreview");
        list.add("/api/file/onlinePreview");
        list.add("/api/file/VisusalImg/**");
        list.add("/api/blade-visual/map/data");
        list.add("/api/blade-visual/category/list");
        list.add("/api/blade-visual/visual/put-file/**");
        list.add("/api/blade-visual/visual/put-file/**");
        list.add("/message/websocket");
        list.add("/api/system/DictionaryData/{dictionaryTypeId}/Data/Selector");
        list.add("/swagger-ui/**");
        list.add("/swagger-ui/index.html");
        list.add("/swagger-resources/**");
        list.add("/webjars/**");
        list.add("/v3/**");
        list.add("/api/system/DataMap/{id}/Data");
        list.add("/api/system/DataInterface/{id}/Actions/Response");
        list.add("/api/oauth/ImageCode/{codeLength}/{timestamp}");
        list.add("/api/oauth/SmsCode/**");
        list.add("/api/oauth/register");
        list.add("/api/oauth/getConfig/{account}");
        list.add("/api/oauth/getQyhConfig");
        list.add("/api/oauth/getSystemAddress/{terminal}");
        list.add("/api/system/Menu/systemList");
        list.add("/");
        list.add("/static/**");
        list.add("/cdn/**");
        list.add("/*.icon");
        list.add("/*.js");
        list.add("/index.html");
        return list;
    }
}

