package com.bringspring.common.license.license.model;

import com.bringspring.common.license.utils.AbstractServerInfo;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;

/**
 * @desc 自定义需要校验的License参数
 *
 * @author 朱俊杰
 * 
 * @date 2019/3/14 10:00
 */
@Setter
@Getter
@ToString
public class LicenseCheckModel implements Serializable {


    /**
     * 可被允许的CPU序列号
     */
    private String cpuSerial;

    /**
     * 可被允许的主板序列号
     */
    private String mainBoardSerial;

    public static LicenseCheckModel installServerInfo(AbstractServerInfo serverInfo){
        LicenseCheckModel result = new LicenseCheckModel();
        try {
            result.setCpuSerial(serverInfo.getCPUSerial());
            result.setMainBoardSerial(serverInfo.getMainBoardSerial());
        }catch (Exception e){
            e.printStackTrace();
        }
        return result;
    }
}
