package com.bringspring.common.util.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 查询功能
 *
 * @author JSBOS开发平台组
 */
public enum SearchMethodEnum {
    /**
     * 等于
     */
    Equal("==", "等于"),
    /**
     * 不等于
     */
    NotEqual("<>", "不等于"),
    /**
     * 大于
     */
    GreaterThan(">", "大于"),
    /**
     * 小于
     */
    LessThan("<", "小于"),
    /**
     * 大于等于
     */
    GreaterThanOrEqual(">=", "大于等于"),
    /**
     * 小于等于
     */
    LessThanOrEqual("<=", "小于等于"),
    /**
     * 介于
     */
    Between("between", "介于"),
    /**
     * 包含任意一个
     */
    Included("in", "包含任意一个"),
    /**
     * 不包含任意一个
     */
    NotIncluded("notIn", "不包含任意一个"),
    /**
     * 为空
     */
    IsNull("null", "为空"),
    /**
     * 不为空
     */
    IsNotNull("notNull", "不为空"),
    /**
     * 包含
     */
    Like("like", "包含"),
    /**
     * 不包含
     */
    NotLike("notLike", "不包含"),

    /**
     * 并且
     */
    And("and", "并且"),
    /**
     * 或者
     */
    Or("or", "或者");


    SearchMethodEnum(String symbol, String message) {
        this.symbol = symbol;
        this.message = message;
    }

    private String symbol;
    private String message;

    public String getSymbol() {
        return symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static SearchMethodEnum getSearchMethod(String symbol) {
        for (SearchMethodEnum status : SearchMethodEnum.values()) {
            if (status.getSymbol().equals(symbol)) {
                return status;
            }
        }
        return Equal;
    }

    public static List<Map<String, Object>> getSymbolOptionsBase() {
        List<Map<String, Object>> options = new ArrayList<>();
        options.add(new HashMap<String, Object>() {{
            put("value", Equal.getSymbol());
            put("label", Equal.getMessage());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", NotEqual.getSymbol());
            put("label", NotEqual.getMessage());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", Like.getSymbol());
            put("label", Like.getMessage());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", NotLike.getSymbol());
            put("label", NotLike.getMessage());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", IsNull.getSymbol());
            put("label", IsNull.getMessage());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", IsNotNull.getSymbol());
            put("label", IsNotNull.getMessage());
        }});
        return options;
    }

    public static List<Map<String, Object>> getSymbolOptionsBatch() {
        List<Map<String, Object>> options = new ArrayList<>();
        options.add(new HashMap<String, Object>() {{
            put("value", Included.getSymbol());
            put("label", Included.getMessage());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", NotIncluded.getSymbol());
            put("label", NotIncluded.getMessage());
        }});
        return options;
    }

    public static List<Map<String, Object>> getSymbolOptionsDateNum() {
        List<Map<String, Object>> options = new ArrayList<>();
        getSymbolOptionsBase().forEach(options::add);
        options.removeIf(map -> map.get("value").equals(Like.getSymbol()) || map.get("value").equals(NotLike.getSymbol()));
        options.add(new HashMap<String, Object>() {{
            put("value", Between.getSymbol());
            put("label", Between.getMessage());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", GreaterThan.getSymbol());
            put("label", GreaterThan.getMessage());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", LessThan.getSymbol());
            put("label", LessThan.getMessage());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", GreaterThanOrEqual.getSymbol());
            put("label", GreaterThanOrEqual.getMessage());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", LessThanOrEqual.getSymbol());
            put("label", LessThanOrEqual.getMessage());
        }});
        return options;
    }

    public static List<Map<String, Object>> getSymbolOptionsSelect() {
        List<Map<String, Object>> options = new ArrayList<>();
        getSymbolOptionsBase().forEach(options::add);
        options.removeIf(map -> map.get("value").equals(Like.getSymbol()) || map.get("value").equals(NotLike.getSymbol()));
        options.add(new HashMap<String, Object>() {{
            put("value", Included.getSymbol());
            put("label", Included.getMessage());
        }});
        options.add(new HashMap<String, Object>() {{
            put("value", NotIncluded.getSymbol());
            put("label", NotIncluded.getMessage());
        }});
        return options;
    }
}
