/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.bringspring.common.database.model.dto.DataSourceDTO;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.util.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="spring.datasource")
public class DataSourceModel
implements DataSourceMod {
    @TableField(value="DB_TYPE")
    private String dbType;
    @TableField(value="HOST")
    private String host;
    @TableField(value="PORT")
    private Integer port;
    @TableField(value="DB_NAME")
    private String dbName;
    @TableField(value="USER_NAME")
    private String userName;
    @TableField(value="PASSWORD")
    private String password;
    @TableField(value="TABLE_SPACE")
    private String dbTableSpace;
    @TableField(value="DB_SCHEMA")
    private String dbSchema;
    @TableField(exist=false)
    private String urlParams;
    @TableField(exist=false)
    private String url;
    @TableField(exist=false)
    private String prepareUrl;
    @TableField(exist=false)
    private String driver;
    @TableField(value="Oracle_Param")
    private String oracleParam;

    @Override
    public DataSourceDTO convertDTO() {
        return this.convertDTO(null);
    }

    @Override
    public DataSourceDTO convertDTO(String dbName) {
        return this.convertDTO(dbName, 1);
    }

    protected DataSourceDTO convertDTO(String dbName, Integer dataSourceFrom) {
        DataSourceDTO dataSourceDTO = new DataSourceDTO();
        BeanUtils.copyProperties((Object)this, (Object)dataSourceDTO);
        if (StringUtils.isNotEmpty(dbName)) {
            dataSourceDTO.setDbName(dbName);
        }
        dataSourceDTO.setDataSourceFrom(dataSourceFrom);
        return dataSourceDTO;
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDbTableSpace() {
        return this.dbTableSpace;
    }

    public String getDbSchema() {
        return this.dbSchema;
    }

    public String getUrlParams() {
        return this.urlParams;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPrepareUrl() {
        return this.prepareUrl;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getOracleParam() {
        return this.oracleParam;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDbTableSpace(String dbTableSpace) {
        this.dbTableSpace = dbTableSpace;
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public void setUrlParams(String urlParams) {
        this.urlParams = urlParams;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPrepareUrl(String prepareUrl) {
        this.prepareUrl = prepareUrl;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setOracleParam(String oracleParam) {
        this.oracleParam = oracleParam;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceModel)) {
            return false;
        }
        DataSourceModel other = (DataSourceModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$dbType = this.getDbType();
        String other$dbType = other.getDbType();
        if (this$dbType == null ? other$dbType != null : !this$dbType.equals(other$dbType)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$dbTableSpace = this.getDbTableSpace();
        String other$dbTableSpace = other.getDbTableSpace();
        if (this$dbTableSpace == null ? other$dbTableSpace != null : !this$dbTableSpace.equals(other$dbTableSpace)) {
            return false;
        }
        String this$dbSchema = this.getDbSchema();
        String other$dbSchema = other.getDbSchema();
        if (this$dbSchema == null ? other$dbSchema != null : !this$dbSchema.equals(other$dbSchema)) {
            return false;
        }
        String this$urlParams = this.getUrlParams();
        String other$urlParams = other.getUrlParams();
        if (this$urlParams == null ? other$urlParams != null : !this$urlParams.equals(other$urlParams)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$prepareUrl = this.getPrepareUrl();
        String other$prepareUrl = other.getPrepareUrl();
        if (this$prepareUrl == null ? other$prepareUrl != null : !this$prepareUrl.equals(other$prepareUrl)) {
            return false;
        }
        String this$driver = this.getDriver();
        String other$driver = other.getDriver();
        if (this$driver == null ? other$driver != null : !this$driver.equals(other$driver)) {
            return false;
        }
        String this$oracleParam = this.getOracleParam();
        String other$oracleParam = other.getOracleParam();
        return !(this$oracleParam == null ? other$oracleParam != null : !this$oracleParam.equals(other$oracleParam));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSourceModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $dbType = this.getDbType();
        result = result * 59 + ($dbType == null ? 43 : $dbType.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $dbTableSpace = this.getDbTableSpace();
        result = result * 59 + ($dbTableSpace == null ? 43 : $dbTableSpace.hashCode());
        String $dbSchema = this.getDbSchema();
        result = result * 59 + ($dbSchema == null ? 43 : $dbSchema.hashCode());
        String $urlParams = this.getUrlParams();
        result = result * 59 + ($urlParams == null ? 43 : $urlParams.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $prepareUrl = this.getPrepareUrl();
        result = result * 59 + ($prepareUrl == null ? 43 : $prepareUrl.hashCode());
        String $driver = this.getDriver();
        result = result * 59 + ($driver == null ? 43 : $driver.hashCode());
        String $oracleParam = this.getOracleParam();
        result = result * 59 + ($oracleParam == null ? 43 : $oracleParam.hashCode());
        return result;
    }

    public String toString() {
        return "DataSourceModel(dbType=" + this.getDbType() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", dbName=" + this.getDbName() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", dbTableSpace=" + this.getDbTableSpace() + ", dbSchema=" + this.getDbSchema() + ", urlParams=" + this.getUrlParams() + ", url=" + this.getUrl() + ", prepareUrl=" + this.getPrepareUrl() + ", driver=" + this.getDriver() + ", oracleParam=" + this.getOracleParam() + ")";
    }
}

